/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.config.CasCoreNotificationsConfiguration;
import org.apereo.cas.config.CasCoreServicesConfiguration;
import org.apereo.cas.config.CasCoreUtilConfiguration;
import org.apereo.cas.config.CasCoreWebConfiguration;
import org.apereo.cas.config.CasServiceRegistryInitializationConfiguration;
import org.apereo.cas.config.CasWebApplicationServiceFactoryConfiguration;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.services.ServiceRegistryInitializer;
import org.apereo.cas.services.ServicesManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.test.context.TestPropertySource;

@Tag(value="RegisteredService")
@SpringBootTest(classes={RefreshAutoConfiguration.class, WebMvcAutoConfiguration.class, CasCoreServicesConfiguration.class, CasCoreUtilConfiguration.class, CasCoreWebConfiguration.class, CasWebApplicationServiceFactoryConfiguration.class, CasCoreNotificationsConfiguration.class, CasServiceRegistryInitializationConfiguration.class}, properties={"cas.service-registry.core.init-from-json=true"})
class CasServiceRegistryInitializationConfigurationTests {
    @Autowired
    @Qualifier(value="serviceRegistryInitializer")
    private ServiceRegistryInitializer serviceRegistryInitializer;
    @Autowired
    @Qualifier(value="embeddedJsonServiceRegistry")
    private ServiceRegistry embeddedJsonServiceRegistry;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    @Qualifier(value="webApplicationServiceFactory")
    private ServiceFactory<WebApplicationService> webApplicationServiceFactory;

    CasServiceRegistryInitializationConfigurationTests() {
    }

    @Nested
    @TestPropertySource(properties={"cas.service-registry.json.location=unknown-bad-location"})
    public class WithUnknownServiceRegistryLocation {
        @Test
        void verifyOperation() throws Throwable {
            Assertions.assertNotNull((Object)CasServiceRegistryInitializationConfigurationTests.this.serviceRegistryInitializer);
            Assertions.assertNotNull((Object)CasServiceRegistryInitializationConfigurationTests.this.embeddedJsonServiceRegistry);
            Assertions.assertEquals((long)1L, (long)CasServiceRegistryInitializationConfigurationTests.this.servicesManager.count());
            Assertions.assertNotNull((Object)CasServiceRegistryInitializationConfigurationTests.this.servicesManager.findServiceBy(12345L));
            WebApplicationService service = (WebApplicationService)CasServiceRegistryInitializationConfigurationTests.this.webApplicationServiceFactory.createService("https://init.cas.org");
            Assertions.assertNotNull((Object)CasServiceRegistryInitializationConfigurationTests.this.servicesManager.findServiceBy((Service)service));
        }
    }

    @Nested
    public class WithoutServiceRegistryLocation {
        @Test
        void verifyOperation() throws Throwable {
            Assertions.assertNotNull((Object)CasServiceRegistryInitializationConfigurationTests.this.serviceRegistryInitializer);
            Assertions.assertNotNull((Object)CasServiceRegistryInitializationConfigurationTests.this.embeddedJsonServiceRegistry);
            Assertions.assertEquals((long)1L, (long)CasServiceRegistryInitializationConfigurationTests.this.servicesManager.count());
            Assertions.assertNotNull((Object)CasServiceRegistryInitializationConfigurationTests.this.servicesManager.findServiceBy(12345L));
            WebApplicationService service = (WebApplicationService)CasServiceRegistryInitializationConfigurationTests.this.webApplicationServiceFactory.createService("https://init.cas.org");
            Assertions.assertNotNull((Object)CasServiceRegistryInitializationConfigurationTests.this.servicesManager.findServiceBy((Service)service));
        }
    }
}

