/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import lombok.Generated;
import org.apereo.cas.authentication.principal.PersistentIdGenerator;
import org.apereo.cas.authentication.principal.ShibbolethCompatiblePersistentIdGenerator;
import org.apereo.cas.configuration.model.support.mfa.BaseMultifactorAuthenticationProviderProperties;
import org.apereo.cas.services.AnonymousRegisteredServiceUsernameAttributeProvider;
import org.apereo.cas.services.BaseRegisteredService;
import org.apereo.cas.services.BaseWebBasedRegisteredService;
import org.apereo.cas.services.CasRegisteredService;
import org.apereo.cas.services.DefaultRegisteredServiceAccessStrategy;
import org.apereo.cas.services.DefaultRegisteredServiceContact;
import org.apereo.cas.services.DefaultRegisteredServiceDelegatedAuthenticationPolicy;
import org.apereo.cas.services.DefaultRegisteredServiceExpirationPolicy;
import org.apereo.cas.services.DefaultRegisteredServiceMultifactorPolicy;
import org.apereo.cas.services.DefaultRegisteredServiceProperty;
import org.apereo.cas.services.DefaultRegisteredServiceUsernameProvider;
import org.apereo.cas.services.PrincipalAttributeRegisteredServiceUsernameProvider;
import org.apereo.cas.services.RegexMatchingRegisteredServiceProxyPolicy;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredServiceAttributeFilter;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceConsentPolicy;
import org.apereo.cas.services.RegisteredServiceDelegatedAuthenticationPolicy;
import org.apereo.cas.services.RegisteredServiceExpirationPolicy;
import org.apereo.cas.services.RegisteredServiceMultifactorPolicy;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.apereo.cas.services.RegisteredServiceProxyPolicy;
import org.apereo.cas.services.RegisteredServicePublicKey;
import org.apereo.cas.services.RegisteredServicePublicKeyImpl;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.RegisteredServiceUsernameAttributeProvider;
import org.apereo.cas.services.RemoteEndpointServiceAccessStrategy;
import org.apereo.cas.services.ReturnAllAttributeReleasePolicy;
import org.apereo.cas.services.ReturnAllowedAttributeReleasePolicy;
import org.apereo.cas.services.ReturnMappedAttributeReleasePolicy;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.services.TimeBasedRegisteredServiceAccessStrategy;
import org.apereo.cas.services.WebBasedRegisteredService;
import org.apereo.cas.services.consent.DefaultRegisteredServiceConsentPolicy;
import org.apereo.cas.services.support.RegisteredServiceMappedRegexAttributeFilter;
import org.apereo.cas.services.support.RegisteredServiceRegexAttributeFilter;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.RandomUtils;
import org.apereo.services.persondir.util.CaseCanonicalizationMode;
import org.awaitility.Awaitility;
import org.jooq.lambda.Unchecked;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.junitpioneer.jupiter.RetryingTest;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public abstract class AbstractServiceRegistryTests {
    public static final int LOAD_SIZE = 1;
    private ServiceRegistry serviceRegistry;

    protected static BaseRegisteredService buildRegisteredServiceInstance(long randomId, Class<? extends BaseWebBasedRegisteredService> registeredServiceClass) {
        String id = String.format("^http://www.serviceid%s.org", randomId);
        BaseWebBasedRegisteredService rs = RegisteredServiceTestUtils.getRegisteredService(id, registeredServiceClass);
        AbstractServiceRegistryTests.initializeServiceInstance((BaseRegisteredService)rs);
        return rs;
    }

    protected static BaseRegisteredService initializeServiceInstance(BaseRegisteredService rs) {
        HashMap<String, DefaultRegisteredServiceProperty> propertyMap = new HashMap<String, DefaultRegisteredServiceProperty>();
        DefaultRegisteredServiceProperty property = new DefaultRegisteredServiceProperty();
        HashSet<String> values = new HashSet<String>();
        values.add("value1");
        values.add("value2");
        property.setValues(values);
        propertyMap.put("field1", property);
        rs.setProperties(propertyMap);
        return rs;
    }

    protected static int getLoadSize() {
        return 1;
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.serviceRegistry = this.getNewServiceRegistry();
        this.clearServiceRegistry();
        this.initializeServiceRegistry();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.clearServiceRegistry();
        this.tearDownServiceRegistry();
    }

    @RetryingTest(value=3)
    @Order(value=1000)
    void verifyEmptyRegistry() {
        this.serviceRegistry.deleteAll();
        Assertions.assertEquals((int)0, (int)this.serviceRegistry.load().size(), (String)"Loaded too many");
        Assertions.assertEquals((long)0L, (long)this.serviceRegistry.size(), (String)"Counted too many");
    }

    @Test
    void verifySave() {
        this.getRegisteredServiceTypes().forEach(type -> {
            BaseRegisteredService svc = AbstractServiceRegistryTests.buildRegisteredServiceInstance(RandomUtils.nextInt(), type);
            this.serviceRegistry.save(() -> svc, result -> Assertions.assertEquals((Object)result.getServiceId(), (Object)svc.getServiceId(), type::getName), 1L);
        });
    }

    @Test
    void verifySaveAndLoad() {
        this.getRegisteredServiceTypes().forEach(type -> {
            this.serviceRegistry.deleteAll();
            for (int i = 0; i < AbstractServiceRegistryTests.getLoadSize(); ++i) {
                BaseRegisteredService svc = AbstractServiceRegistryTests.buildRegisteredServiceInstance(i, type);
                this.serviceRegistry.save((RegisteredService)svc);
                RegisteredService svc2 = this.serviceRegistry.findServiceByExactServiceName(svc.getName());
                Assertions.assertNotNull((Object)svc2, type::getName);
                RegisteredService svc3 = this.serviceRegistry.findServiceById(svc2.getId());
                Assertions.assertEquals((Object)svc2, (Object)svc3);
                this.serviceRegistry.delete(svc2);
            }
            Collection results = this.serviceRegistry.load();
            Assertions.assertTrue((boolean)results.isEmpty());
            Assertions.assertEquals((long)0L, (long)this.serviceRegistry.getServicesStream().count());
            Assertions.assertEquals((long)0L, (long)this.serviceRegistry.size());
        });
    }

    @Test
    void verifyNonExistingService() throws Throwable {
        Assertions.assertNull((Object)this.serviceRegistry.findServiceById(9999991L));
    }

    @Test
    void verifySavingServices() {
        this.getRegisteredServiceTypes().forEach(type -> {
            BaseRegisteredService registeredService = AbstractServiceRegistryTests.buildRegisteredServiceInstance(100L, type);
            this.serviceRegistry.save((RegisteredService)registeredService);
            Collection services = this.serviceRegistry.load();
            Assertions.assertTrue((boolean)services.stream().anyMatch(svc -> svc.equals((Object)registeredService)));
            BaseRegisteredService registeredService2 = AbstractServiceRegistryTests.buildRegisteredServiceInstance(101L, type);
            this.serviceRegistry.save((RegisteredService)registeredService2);
            Collection services2 = this.serviceRegistry.load();
            Assertions.assertTrue((boolean)services2.stream().anyMatch(svc -> svc.equals((Object)registeredService)));
        });
    }

    @Test
    void verifyUpdatingServices() {
        this.getRegisteredServiceTypes().forEach(type -> {
            this.serviceRegistry.save((RegisteredService)AbstractServiceRegistryTests.buildRegisteredServiceInstance(200L, type));
            Collection services = this.serviceRegistry.load();
            Assertions.assertFalse((boolean)services.isEmpty());
            BaseRegisteredService rs = (BaseRegisteredService)this.serviceRegistry.findServiceById(((RegisteredService)services.iterator().next()).getId());
            Assertions.assertNotNull((Object)rs, type::getName);
            rs.setEvaluationOrder(9999);
            rs.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)new DefaultRegisteredServiceUsernameProvider());
            rs.setDescription("The new description");
            rs.setServiceId("https://hello.world");
            rs.setTheme("some-theme");
            if (rs instanceof CasRegisteredService) {
                RegexMatchingRegisteredServiceProxyPolicy policy = new RegexMatchingRegisteredServiceProxyPolicy();
                policy.setPattern("https");
                ((CasRegisteredService)rs).setProxyPolicy((RegisteredServiceProxyPolicy)policy);
            }
            rs.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)new ReturnAllowedAttributeReleasePolicy());
            Assertions.assertNotNull((Object)this.serviceRegistry.save((RegisteredService)rs), type::getName);
            WebBasedRegisteredService rs3 = (WebBasedRegisteredService)this.serviceRegistry.findServiceById(rs.getId());
            Assertions.assertEquals((Object)rs3.getDescription(), (Object)rs.getDescription());
            Assertions.assertEquals((int)rs3.getEvaluationOrder(), (int)rs.getEvaluationOrder());
            Assertions.assertEquals((Object)rs3.getUsernameAttributeProvider(), (Object)rs.getUsernameAttributeProvider());
            Assertions.assertEquals((Object)rs3.getServiceId(), (Object)rs.getServiceId());
            Assertions.assertEquals((Object)rs3.getTheme(), (Object)rs.getTheme());
            Collection rs4 = this.serviceRegistry.findServicePredicate(registeredService -> registeredService.getId() == rs.getId());
            Assertions.assertTrue((boolean)rs4.stream().map(rs5 -> rs5.getName().equals(rs.getName())).findFirst().isPresent());
        });
    }

    @Test
    void verifyDeletingSingleService() {
        this.getRegisteredServiceTypes().forEach(type -> {
            BaseRegisteredService rs = AbstractServiceRegistryTests.buildRegisteredServiceInstance(300L, type);
            BaseRegisteredService rs2 = AbstractServiceRegistryTests.buildRegisteredServiceInstance(301L, type);
            this.serviceRegistry.save((RegisteredService)rs2);
            this.serviceRegistry.save((RegisteredService)rs);
            this.serviceRegistry.load();
            this.serviceRegistry.delete((RegisteredService)rs2);
            Assertions.assertFalse((boolean)this.serviceRegistry.load().isEmpty());
            RegisteredService rsNew = this.serviceRegistry.findServiceByExactServiceName(rs.getName());
            Assertions.assertNotNull((Object)rsNew);
        });
    }

    @Test
    void verifyDeletingServices() {
        this.getRegisteredServiceTypes().forEach(type -> {
            this.serviceRegistry.save((RegisteredService)AbstractServiceRegistryTests.buildRegisteredServiceInstance(400L, type));
            this.serviceRegistry.save((RegisteredService)AbstractServiceRegistryTests.buildRegisteredServiceInstance(401L, type));
            Collection services = this.serviceRegistry.load();
            services.forEach(registeredService -> this.serviceRegistry.delete(registeredService));
            Assertions.assertEquals((int)0, (int)this.serviceRegistry.load().size());
        });
    }

    @Test
    void verifyExpiredServiceDeleted() {
        this.getRegisteredServiceTypes().forEach(type -> {
            BaseRegisteredService service = AbstractServiceRegistryTests.buildRegisteredServiceInstance(RandomUtils.nextInt(), type);
            service.setExpirationPolicy((RegisteredServiceExpirationPolicy)new DefaultRegisteredServiceExpirationPolicy(true, LocalDateTime.now(ZoneId.systemDefault()).minusSeconds(1L)));
            RegisteredService savedService = this.serviceRegistry.save((RegisteredService)service);
            this.serviceRegistry.load();
            Awaitility.await().untilAsserted(() -> Assertions.assertNotNull((Object)this.serviceRegistry.findServiceByExactServiceName(savedService.getName())));
        });
    }

    @Test
    void verifyServiceLookupByServiceId() {
        this.getRegisteredServiceTypes().forEach(type -> {
            BaseRegisteredService r1 = AbstractServiceRegistryTests.buildRegisteredServiceInstance(RandomUtils.nextInt(), type);
            String id = UUID.randomUUID().toString();
            r1.setServiceId(".*%s.*".formatted(id));
            r1.setEvaluationOrder(100);
            this.serviceRegistry.save((RegisteredService)r1);
            BaseRegisteredService r2 = AbstractServiceRegistryTests.buildRegisteredServiceInstance(RandomUtils.nextInt(), type);
            r2.setServiceId(r1.getServiceId());
            r2.setEvaluationOrder(1);
            this.serviceRegistry.save((RegisteredService)r2);
            RegisteredService svc = this.serviceRegistry.findServiceBy(id);
            Assertions.assertNotNull((Object)svc);
            Assertions.assertEquals((Object)r2, (Object)svc);
            Assertions.assertNull((Object)this.serviceRegistry.findServiceBy("this-service-id-does-not-exist"));
        });
    }

    @Test
    void verifyExpiredServiceDisabled() {
        this.getRegisteredServiceTypes().forEach(type -> {
            BaseRegisteredService r = AbstractServiceRegistryTests.buildRegisteredServiceInstance(RandomUtils.nextInt(), type);
            LocalDateTime expirationDate = LocalDateTime.now(ZoneId.systemDefault()).plusSeconds(1L);
            r.setExpirationPolicy((RegisteredServiceExpirationPolicy)new DefaultRegisteredServiceExpirationPolicy(false, expirationDate));
            RegisteredService r2 = this.serviceRegistry.save((RegisteredService)r);
            RegisteredService svc = this.serviceRegistry.findServiceByExactServiceName(r2.getName());
            Assertions.assertNotNull((Object)svc, () -> "1: " + type.getName());
            RegisteredService svc2 = this.serviceRegistry.findServiceByExactServiceName(r2.getName());
            Assertions.assertNotNull((Object)svc2, () -> "2: " + type.getName());
        });
    }

    @Test
    public void checkSaveMethodWithNonExistentServiceAndNoAttributes() {
        this.getRegisteredServiceTypes().forEach(type -> {
            BaseRegisteredService r = AbstractServiceRegistryTests.buildRegisteredServiceInstance(RandomUtils.nextInt(), type);
            RegisteredService r2 = this.serviceRegistry.save((RegisteredService)r);
            RegisteredService r3 = this.serviceRegistry.findServiceById(r2.getId());
            Assertions.assertEquals((Object)r2, (Object)r3);
            Assertions.assertNotNull((Object)this.serviceRegistry.findServiceByExactServiceId(r.getServiceId()));
            Assertions.assertNotNull((Object)this.serviceRegistry.findServiceByExactServiceName(r.getName()));
        });
    }

    @Test
    public void checkSaveMethodWithDelegatedAuthnPolicy() {
        this.getRegisteredServiceTypes().forEach(type -> {
            BaseRegisteredService r = AbstractServiceRegistryTests.buildRegisteredServiceInstance(RandomUtils.nextInt(), type);
            DefaultRegisteredServiceAccessStrategy strategy = new DefaultRegisteredServiceAccessStrategy();
            List providers = CollectionUtils.wrapList((Object[])new String[]{"one", "two"});
            strategy.setDelegatedAuthenticationPolicy((RegisteredServiceDelegatedAuthenticationPolicy)new DefaultRegisteredServiceDelegatedAuthenticationPolicy((Collection)providers, true, false, null));
            r.setAccessStrategy((RegisteredServiceAccessStrategy)strategy);
            RegisteredService r2 = this.serviceRegistry.save((RegisteredService)r);
            RegisteredService r3 = this.serviceRegistry.findServiceById(r2.getId());
            Assertions.assertEquals((Object)r2, (Object)r3);
        });
    }

    @Test
    public void execSaveWithAuthnMethodPolicy() {
        this.getRegisteredServiceTypes().forEach(type -> {
            BaseRegisteredService r = AbstractServiceRegistryTests.buildRegisteredServiceInstance(RandomUtils.nextInt(), type);
            DefaultRegisteredServiceMultifactorPolicy policy = new DefaultRegisteredServiceMultifactorPolicy();
            policy.setFailureMode(BaseMultifactorAuthenticationProviderProperties.MultifactorAuthenticationProviderFailureModes.PHANTOM);
            HashSet<String> set = new HashSet<String>();
            set.add("duoAuthenticationProvider");
            policy.setMultifactorAuthenticationProviders(set);
            policy.setPrincipalAttributeNameTrigger("memberOf");
            policy.setPrincipalAttributeValueToMatch("cas|CAS|admin");
            r.setMultifactorAuthenticationPolicy((RegisteredServiceMultifactorPolicy)policy);
            RegisteredService r2 = this.serviceRegistry.save((RegisteredService)r);
            RegisteredService r3 = this.serviceRegistry.findServiceById(r2.getId());
            Assertions.assertEquals((Object)r2, (Object)r3);
        });
    }

    @Test
    public void execSaveMethodWithDefaultUsernameAttribute() {
        this.getRegisteredServiceTypes().forEach(type -> {
            BaseRegisteredService r = AbstractServiceRegistryTests.buildRegisteredServiceInstance(RandomUtils.nextInt(), type);
            r.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)new DefaultRegisteredServiceUsernameProvider());
            RegisteredService r2 = this.serviceRegistry.save((RegisteredService)r);
            RegisteredService r3 = this.serviceRegistry.findServiceById(r2.getId());
            Assertions.assertEquals((Object)r2, (Object)r3);
        });
    }

    @Test
    public void execSaveMethodWithConsentPolicy() {
        this.getRegisteredServiceTypes().forEach(type -> {
            BaseRegisteredService r = AbstractServiceRegistryTests.buildRegisteredServiceInstance(RandomUtils.nextInt(), type);
            ReturnAllAttributeReleasePolicy policy = new ReturnAllAttributeReleasePolicy();
            policy.setConsentPolicy((RegisteredServiceConsentPolicy)new DefaultRegisteredServiceConsentPolicy(CollectionUtils.wrapSet((Object)"test"), CollectionUtils.wrapSet((Object)"test")));
            r.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)policy);
            RegisteredService r2 = this.serviceRegistry.save((RegisteredService)r);
            RegisteredService r3 = this.serviceRegistry.findServiceById(r2.getId());
            Assertions.assertEquals((Object)r2, (Object)r3);
        });
    }

    @Test
    public void ensureSaveMethodWithDefaultPrincipalAttribute() {
        this.getRegisteredServiceTypes().forEach(type -> {
            BaseRegisteredService r = AbstractServiceRegistryTests.buildRegisteredServiceInstance(RandomUtils.nextInt(), type);
            PrincipalAttributeRegisteredServiceUsernameProvider provider = new PrincipalAttributeRegisteredServiceUsernameProvider();
            provider.setCanonicalizationMode(CaseCanonicalizationMode.UPPER.name());
            provider.setUsernameAttribute("cn");
            r.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)provider);
            RegisteredService r2 = this.serviceRegistry.save((RegisteredService)r);
            RegisteredService r3 = this.serviceRegistry.findServiceById(r2.getId());
            Assertions.assertEquals((Object)r2, (Object)r3);
        });
    }

    @Test
    void verifySaveMethodWithDefaultAnonymousAttribute() {
        this.getRegisteredServiceTypes().forEach(type -> {
            BaseRegisteredService r = AbstractServiceRegistryTests.buildRegisteredServiceInstance(RandomUtils.nextInt(), type);
            r.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)new AnonymousRegisteredServiceUsernameAttributeProvider((PersistentIdGenerator)new ShibbolethCompatiblePersistentIdGenerator("helloworld")));
            RegisteredService r2 = this.serviceRegistry.save((RegisteredService)r);
            this.serviceRegistry.load();
            RegisteredService r3 = this.serviceRegistry.findServiceById(r2.getId());
            AnonymousRegisteredServiceUsernameAttributeProvider anon = (AnonymousRegisteredServiceUsernameAttributeProvider)r3.getUsernameAttributeProvider();
            ShibbolethCompatiblePersistentIdGenerator ss = (ShibbolethCompatiblePersistentIdGenerator)anon.getPersistentIdGenerator();
            Assertions.assertEquals((Object)"helloworld", (Object)ss.getSalt());
            Assertions.assertEquals((Object)r2, (Object)r3);
        });
    }

    @Test
    void verifyServiceExpirationPolicy() {
        this.getRegisteredServiceTypes().forEach(type -> {
            BaseRegisteredService r = AbstractServiceRegistryTests.buildRegisteredServiceInstance(RandomUtils.nextInt(), type);
            r.setExpirationPolicy((RegisteredServiceExpirationPolicy)new DefaultRegisteredServiceExpirationPolicy(true, LocalDate.now(ZoneId.systemDefault()).toString()));
            RegisteredService r2 = this.serviceRegistry.save((RegisteredService)r);
            RegisteredService r3 = this.serviceRegistry.findServiceById(r2.getId());
            Assertions.assertEquals((Object)r2, (Object)r3);
            Assertions.assertNotNull((Object)r3.getExpirationPolicy());
            Assertions.assertEquals((Object)r2.getExpirationPolicy(), (Object)r3.getExpirationPolicy());
        });
    }

    @Test
    void verifySaveAttributeReleasePolicy() {
        this.getRegisteredServiceTypes().forEach(type -> {
            BaseRegisteredService r = AbstractServiceRegistryTests.buildRegisteredServiceInstance(RandomUtils.nextInt(), type);
            r.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)new ReturnAllAttributeReleasePolicy());
            RegisteredService r2 = this.serviceRegistry.save((RegisteredService)r);
            RegisteredService r3 = this.serviceRegistry.findServiceById(r2.getId());
            Assertions.assertEquals((Object)r2, (Object)r3);
            Assertions.assertNotNull((Object)r3.getAttributeReleasePolicy());
            Assertions.assertEquals((Object)r2.getAttributeReleasePolicy(), (Object)r3.getAttributeReleasePolicy());
        });
    }

    @Test
    void verifySaveMethodWithExistingServiceNoAttribute() {
        this.getRegisteredServiceTypes().forEach(type -> {
            BaseRegisteredService r = AbstractServiceRegistryTests.buildRegisteredServiceInstance(RandomUtils.nextInt(), type);
            this.serviceRegistry.save((RegisteredService)r);
            r.setTheme("mytheme");
            this.serviceRegistry.save((RegisteredService)r);
            RegisteredService r2 = this.serviceRegistry.save((RegisteredService)r);
            RegisteredService r3 = this.serviceRegistry.findServiceById(r2.getId());
            Assertions.assertEquals((Object)r2, (Object)r3);
        });
    }

    @Test
    void verifySaveAttributeReleasePolicyMappingRules() {
        this.getRegisteredServiceTypes().forEach(type -> {
            BaseRegisteredService r = AbstractServiceRegistryTests.buildRegisteredServiceInstance(RandomUtils.nextInt(), type);
            ArrayListMultimap map = ArrayListMultimap.create();
            map.put((Object)"attr1", (Object)"newattr1");
            map.put((Object)"attr2", (Object)"newattr2");
            map.put((Object)"attr2", (Object)"newattr3");
            ReturnMappedAttributeReleasePolicy policy = new ReturnMappedAttributeReleasePolicy();
            policy.setAllowedAttributes(CollectionUtils.wrap((Multimap)map));
            r.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)policy);
            RegisteredService r2 = this.serviceRegistry.save((RegisteredService)r);
            RegisteredService r3 = this.serviceRegistry.findServiceById(r2.getId());
            Assertions.assertEquals((Object)r2, (Object)r3);
            Assertions.assertNotNull((Object)r3.getAttributeReleasePolicy());
            Assertions.assertEquals((Object)r2.getAttributeReleasePolicy(), (Object)r3.getAttributeReleasePolicy());
        });
    }

    @Test
    void verifySaveAttributeReleasePolicyAllowedAttrRules() {
        this.getRegisteredServiceTypes().forEach(type -> {
            BaseRegisteredService r = AbstractServiceRegistryTests.buildRegisteredServiceInstance(RandomUtils.nextInt(), type);
            ReturnAllowedAttributeReleasePolicy policy = new ReturnAllowedAttributeReleasePolicy();
            policy.setAllowedAttributes(Arrays.asList("1", "2", "3"));
            r.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)policy);
            RegisteredService r2 = this.serviceRegistry.save((RegisteredService)r);
            RegisteredService r3 = this.serviceRegistry.findServiceById(r2.getId());
            Assertions.assertEquals((Object)r2, (Object)r3);
            Assertions.assertNotNull((Object)r3.getAttributeReleasePolicy());
            Assertions.assertEquals((Object)r2.getAttributeReleasePolicy(), (Object)r3.getAttributeReleasePolicy());
        });
    }

    @Test
    void verifySaveAttributeReleasePolicyAllowedAttrRulesAndFilter() {
        this.getRegisteredServiceTypes().forEach(type -> {
            RegexMatchingRegisteredServiceProxyPolicy policy;
            BaseRegisteredService r = AbstractServiceRegistryTests.buildRegisteredServiceInstance(RandomUtils.nextInt(), type);
            r.setAccessStrategy((RegisteredServiceAccessStrategy)new DefaultRegisteredServiceAccessStrategy(true, false));
            if (r instanceof CasRegisteredService) {
                policy = new RegexMatchingRegisteredServiceProxyPolicy();
                policy.setPattern("https");
                ((CasRegisteredService)r).setProxyPolicy((RegisteredServiceProxyPolicy)policy);
            }
            r.getAuthenticationPolicy().getRequiredAuthenticationHandlers().addAll(CollectionUtils.wrapHashSet((Object[])new String[]{"h1", "h2"}));
            policy = new ReturnAllowedAttributeReleasePolicy();
            policy.setAllowedAttributes(Arrays.asList("1", "2", "3"));
            r.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)policy);
            r.getAttributeReleasePolicy().setAttributeFilter((RegisteredServiceAttributeFilter)new RegisteredServiceRegexAttributeFilter("\\w+"));
            RegisteredService r2 = this.serviceRegistry.save((RegisteredService)r);
            RegisteredService r3 = this.serviceRegistry.findServiceById(r2.getId());
            Assertions.assertEquals((Object)r2, (Object)r3);
            Assertions.assertNotNull((Object)r3.getAttributeReleasePolicy());
            Assertions.assertEquals((Object)r2.getAttributeReleasePolicy(), (Object)r3.getAttributeReleasePolicy());
        });
    }

    @Test
    void verifyServiceType() {
        this.getRegisteredServiceTypes().forEach(type -> {
            BaseRegisteredService r = AbstractServiceRegistryTests.buildRegisteredServiceInstance(RandomUtils.nextInt(), type);
            RegisteredService r2 = this.serviceRegistry.save((RegisteredService)r);
            Assertions.assertSame((Object)r2.getClass(), (Object)type);
        });
    }

    @Test
    void verifyServiceRemovals() {
        this.getRegisteredServiceTypes().forEach(type -> {
            ArrayList list = IntStream.range(1, 5).mapToObj(i -> AbstractServiceRegistryTests.buildRegisteredServiceInstance(RandomUtils.nextInt(), type)).map(r -> this.serviceRegistry.save((RegisteredService)r)).collect(Collectors.toCollection(() -> new ArrayList(5)));
            list.forEach(Unchecked.consumer(r2 -> {
                Thread.sleep(500L);
                this.serviceRegistry.delete(r2);
                Thread.sleep(2000L);
                Assertions.assertNull((Object)this.serviceRegistry.findServiceById(r2.getId()));
            }));
        });
    }

    @Test
    public void checkForAuthorizationStrategy() {
        this.getRegisteredServiceTypes().forEach(type -> {
            BaseRegisteredService r = AbstractServiceRegistryTests.buildRegisteredServiceInstance(RandomUtils.nextInt(), type);
            DefaultRegisteredServiceAccessStrategy authz = new DefaultRegisteredServiceAccessStrategy(false, false);
            HashMap<String, Set<String>> attrs = new HashMap<String, Set<String>>();
            attrs.put("cn", Collections.singleton("v1, v2, v3"));
            attrs.put("memberOf", Collections.singleton("v4, v5, v6"));
            authz.setRequiredAttributes(attrs);
            r.setAccessStrategy((RegisteredServiceAccessStrategy)authz);
            RegisteredService r2 = this.serviceRegistry.save((RegisteredService)r);
            RegisteredService r3 = this.serviceRegistry.findServiceById(r2.getId());
            Assertions.assertEquals((Object)r2, (Object)r3);
        });
    }

    @Test
    void verifyAccessStrategyWithStarEndDate() {
        this.getRegisteredServiceTypes().forEach(type -> {
            BaseRegisteredService r = AbstractServiceRegistryTests.buildRegisteredServiceInstance(RandomUtils.nextInt(), type);
            TimeBasedRegisteredServiceAccessStrategy authz = new TimeBasedRegisteredServiceAccessStrategy();
            authz.setStartingDateTime(ZonedDateTime.now(ZoneOffset.UTC).plusDays(1L).toString());
            authz.setEndingDateTime(ZonedDateTime.now(ZoneOffset.UTC).plusDays(10L).toString());
            r.setAccessStrategy((RegisteredServiceAccessStrategy)authz);
            RegisteredService r2 = this.serviceRegistry.save((RegisteredService)r);
            RegisteredService r3 = this.serviceRegistry.findServiceById(r2.getId());
            Assertions.assertEquals((Object)r2, (Object)r3);
        });
    }

    @Test
    void verifyAccessStrategyWithEndpoint() {
        this.getRegisteredServiceTypes().forEach(type -> {
            BaseRegisteredService r = AbstractServiceRegistryTests.buildRegisteredServiceInstance(RandomUtils.nextInt(), type);
            RemoteEndpointServiceAccessStrategy authz = new RemoteEndpointServiceAccessStrategy();
            authz.setEndpointUrl("http://www.google.com?this=that");
            authz.setAcceptableResponseCodes("200,405,403");
            r.setAccessStrategy((RegisteredServiceAccessStrategy)authz);
            RegisteredService r2 = this.serviceRegistry.save((RegisteredService)r);
            RegisteredService r3 = this.serviceRegistry.findServiceById(r2.getId());
            Assertions.assertEquals((Object)r2, (Object)r3);
        });
    }

    @Test
    public void serializePublicKeyForServiceAndVerify() {
        this.getRegisteredServiceTypes().forEach(type -> {
            RegisteredServicePublicKeyImpl publicKey = new RegisteredServicePublicKeyImpl("classpath:RSA1024Public.key", "RSA");
            BaseRegisteredService registeredService = AbstractServiceRegistryTests.buildRegisteredServiceInstance(RandomUtils.nextInt(), type);
            registeredService.setPublicKey((RegisteredServicePublicKey)publicKey);
            this.serviceRegistry.save((RegisteredService)registeredService);
            this.serviceRegistry.load();
            Assertions.assertNotNull((Object)this.serviceRegistry.findServiceByExactServiceName(registeredService.getName()));
        });
    }

    @Test
    void verifyMappedRegexAttributeFilter() {
        this.getRegisteredServiceTypes().forEach(type -> {
            BaseRegisteredService registeredService = AbstractServiceRegistryTests.buildRegisteredServiceInstance(RandomUtils.nextInt(), type);
            ReturnAllowedAttributeReleasePolicy p = new ReturnAllowedAttributeReleasePolicy();
            RegisteredServiceMappedRegexAttributeFilter filter = new RegisteredServiceMappedRegexAttributeFilter();
            filter.setCompleteMatch(true);
            filter.setPatterns(CollectionUtils.wrap((String)"one", (Object)"two"));
            p.setAttributeFilter((RegisteredServiceAttributeFilter)filter);
            registeredService.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)p);
            this.serviceRegistry.save((RegisteredService)registeredService);
            this.serviceRegistry.load();
        });
    }

    @Test
    void verifyServiceContacts() {
        this.getRegisteredServiceTypes().forEach(type -> {
            BaseRegisteredService r = AbstractServiceRegistryTests.buildRegisteredServiceInstance(RandomUtils.nextInt(), type);
            DefaultRegisteredServiceContact contact = new DefaultRegisteredServiceContact();
            contact.setDepartment("Department");
            contact.setEmail("cas@example.org");
            contact.setName("Contact");
            contact.setPhone("123-456-7890");
            r.setContacts(CollectionUtils.wrap((Object)contact));
            this.serviceRegistry.save((RegisteredService)r);
            this.serviceRegistry.load();
            this.serviceRegistry.delete((RegisteredService)r);
        });
    }

    @Test
    public void persistCustomServiceProperties() {
        this.getRegisteredServiceTypes().forEach(type -> {
            BaseRegisteredService r = AbstractServiceRegistryTests.buildRegisteredServiceInstance(RandomUtils.nextInt(), type);
            HashMap<String, DefaultRegisteredServiceProperty> properties = new HashMap<String, DefaultRegisteredServiceProperty>();
            DefaultRegisteredServiceProperty property = new DefaultRegisteredServiceProperty();
            HashSet<String> values = new HashSet<String>();
            values.add("value1");
            values.add("value2");
            property.setValues(values);
            properties.put("field1", property);
            DefaultRegisteredServiceProperty property2 = new DefaultRegisteredServiceProperty();
            HashSet<String> values2 = new HashSet<String>();
            values2.add("value12");
            values2.add("value22");
            property2.setValues(values2);
            properties.put("field2", property2);
            r.setProperties(properties);
            this.serviceRegistry.save((RegisteredService)r);
            this.serviceRegistry.load();
            Assertions.assertNotNull((Object)this.serviceRegistry.findServiceByExactServiceName(r.getName()));
            Assertions.assertEquals((int)2, (int)r.getProperties().size());
            Assertions.assertNotNull(r.getProperties().get("field1"));
            RegisteredServiceProperty prop = (RegisteredServiceProperty)r.getProperties().get("field1");
            Assertions.assertEquals((int)2, (int)prop.getValues().size());
            this.serviceRegistry.delete((RegisteredService)r);
        });
    }

    protected abstract ServiceRegistry getNewServiceRegistry() throws Exception;

    protected void initializeServiceRegistry() throws Exception {
    }

    protected void tearDownServiceRegistry() throws Exception {
    }

    protected void clearServiceRegistry() {
        this.getServiceRegistry().deleteAll();
        Assertions.assertTrue((boolean)this.getServiceRegistry().load().isEmpty());
    }

    protected Stream<Class<? extends BaseWebBasedRegisteredService>> getRegisteredServiceTypes() {
        return Stream.of(CasRegisteredService.class);
    }

    @Generated
    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Generated
    protected AbstractServiceRegistryTests() {
    }
}

