/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.authentication.principal.WebApplicationServiceFactory;
import org.apereo.cas.services.CasRegisteredService;
import org.apereo.cas.services.DefaultRegisteredServiceExpirationPolicy;
import org.apereo.cas.services.DefaultServicesManagerRegisteredServiceLocator;
import org.apereo.cas.services.InMemoryServiceRegistry;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceExpirationPolicy;
import org.apereo.cas.services.RegisteredServicesTemplatesManager;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.ServicesManagerConfigurationContext;
import org.apereo.cas.services.mgmt.DefaultServicesManager;
import org.apereo.cas.util.RandomUtils;
import org.jooq.lambda.Unchecked;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.StaticApplicationContext;

public abstract class AbstractServicesManagerTests<T extends ServicesManager> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractServicesManagerTests.class);
    private static final String TEST = "test";
    protected final ServiceFactory<WebApplicationService> serviceFactory = new WebApplicationServiceFactory();
    protected final List<RegisteredService> listOfDefaultServices = new ArrayList<RegisteredService>();
    protected ServiceRegistry serviceRegistry;
    protected ServicesManager servicesManager;

    protected AbstractServicesManagerTests() {
        CasRegisteredService r = new CasRegisteredService();
        r.setId(2500L);
        r.setServiceId("serviceId");
        r.setName("serviceName");
        r.setEvaluationOrder(1000);
        this.listOfDefaultServices.add((RegisteredService)r);
    }

    @BeforeEach
    public void initialize() {
        this.serviceRegistry = this.getServiceRegistryInstance();
        this.servicesManager = this.getServicesManagerInstance();
        this.servicesManager.deleteAll();
        this.servicesManager.load();
    }

    @Test
    void verifySaveAndGet() throws Throwable {
        CasRegisteredService services = new CasRegisteredService();
        services.setId(1100L);
        services.setName(TEST);
        services.setServiceId(TEST);
        this.servicesManager.save((RegisteredService)services);
        Assertions.assertNotNull((Object)this.servicesManager.findServiceBy(1100L));
        Assertions.assertNotNull((Object)this.servicesManager.findServiceBy(1100L, CasRegisteredService.class));
        Assertions.assertNotNull((Object)this.servicesManager.findServiceByName(TEST));
        Assertions.assertNotNull((Object)this.servicesManager.findServiceByName(TEST, CasRegisteredService.class));
        Assertions.assertTrue((this.servicesManager.count() > 0L ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)this.servicesManager.getAllServicesOfType(CasRegisteredService.class).isEmpty());
        RegisteredService mockSvc = (RegisteredService)Mockito.mock(RegisteredService.class);
        Assertions.assertTrue((boolean)this.servicesManager.getAllServicesOfType(mockSvc.getClass()).isEmpty());
    }

    @Test
    void verifySaveInRegistryAndGetById() throws Throwable {
        CasRegisteredService service = new CasRegisteredService();
        service.setId(2100L);
        service.setName(TEST);
        service.setServiceId(TEST);
        Assertions.assertFalse((boolean)this.isServiceInCache(null, 2100L));
        this.serviceRegistry.save((RegisteredService)service);
        Assertions.assertNotNull((Object)this.serviceRegistry.findServiceById(2100L));
        Assertions.assertNotNull((Object)this.servicesManager.findServiceBy(2100L));
        Assertions.assertTrue((boolean)this.isServiceInCache(null, 2100L));
    }

    @Test
    void verifySaveInRegistryAndGetByServiceId() throws Throwable {
        CasRegisteredService service = new CasRegisteredService();
        service.setId(3100L);
        service.setName(TEST);
        service.setServiceId(TEST);
        Assertions.assertFalse((boolean)this.isServiceInCache(TEST, 0L));
        this.serviceRegistry.save((RegisteredService)service);
        Assertions.assertNotNull((Object)this.serviceRegistry.findServiceByExactServiceId(TEST));
        WebApplicationService svc = new WebApplicationServiceFactory().createService(TEST);
        Assertions.assertNotNull((Object)this.servicesManager.findServiceBy((Service)svc, CasRegisteredService.class));
        Assertions.assertTrue((boolean)this.isServiceInCache(TEST, 0L));
    }

    @Test
    void verifyDelete() throws Throwable {
        CasRegisteredService r = new CasRegisteredService();
        r.setId(1000L);
        r.setName(TEST);
        r.setServiceId(TEST);
        this.servicesManager.save((RegisteredService)r);
        Assertions.assertTrue((boolean)this.isServiceInCache(null, 1000L));
        Assertions.assertNotNull((Object)this.servicesManager.findServiceBy(this.serviceFactory.createService(r.getServiceId())));
        this.servicesManager.delete((RegisteredService)r);
        Assertions.assertNull((Object)this.servicesManager.findServiceBy(r.getId()));
        Assertions.assertFalse((boolean)this.isServiceInCache(null, 1000L));
    }

    @Test
    void verifyExpiredNotify() throws Throwable {
        CasRegisteredService r = new CasRegisteredService();
        r.setId(2000L);
        r.setName(TEST);
        r.setServiceId(TEST);
        DefaultRegisteredServiceExpirationPolicy expirationPolicy = new DefaultRegisteredServiceExpirationPolicy();
        expirationPolicy.setNotifyWhenExpired(true);
        expirationPolicy.setExpirationDate(LocalDateTime.now(ZoneOffset.UTC).minusDays(2L).toString());
        r.setExpirationPolicy((RegisteredServiceExpirationPolicy)expirationPolicy);
        this.servicesManager.save((RegisteredService)r);
        Assertions.assertNotNull((Object)this.servicesManager.findServiceBy(this.serviceFactory.createService(r.getServiceId())));
    }

    @Test
    void verifyExpiredNotifyAndDelete() throws Throwable {
        CasRegisteredService r = new CasRegisteredService();
        r.setId(2001L);
        r.setName(TEST);
        r.setServiceId(TEST);
        DefaultRegisteredServiceExpirationPolicy expirationPolicy = new DefaultRegisteredServiceExpirationPolicy();
        expirationPolicy.setNotifyWhenExpired(true);
        expirationPolicy.setExpirationDate(LocalDateTime.now(ZoneOffset.UTC).minusDays(2L).toString());
        expirationPolicy.setDeleteWhenExpired(true);
        expirationPolicy.setNotifyWhenDeleted(true);
        r.setExpirationPolicy((RegisteredServiceExpirationPolicy)expirationPolicy);
        this.servicesManager.save((RegisteredService)r);
        Assertions.assertNull((Object)this.servicesManager.findServiceBy(this.serviceFactory.createService(r.getServiceId())));
    }

    @Test
    void verifyServiceCanBeFoundDuringLoadWithoutCacheInvalidation() throws Throwable {
        CasRegisteredService service = new CasRegisteredService();
        service.setId(RandomUtils.nextLong());
        service.setName(UUID.randomUUID().toString());
        service.setServiceId("https://test.edu.*");
        Assertions.assertFalse((boolean)this.isServiceInCache(null, service.getId()));
        this.serviceRegistry.save((RegisteredService)service);
        this.servicesManager.load();
        Assertions.assertNotNull((Object)this.servicesManager.findServiceBy(service.getId()));
        Assertions.assertTrue((boolean)this.isServiceInCache(null, service.getId()));
        Thread loadingThread = new Thread(Unchecked.runnable(() -> {
            LOGGER.debug("Loading services manager...");
            Thread.sleep(1000L);
            this.servicesManager.load();
            Thread.sleep(1000L);
            LOGGER.debug("Loaded services manager...");
        }));
        loadingThread.start();
        WebApplicationService testService = (WebApplicationService)this.serviceFactory.createService("https://test.edu/path/");
        IntStream.rangeClosed(1, 5).forEach(i -> {
            LOGGER.debug("Checking for previously-saved service attempt [{}]", (Object)i);
            Assertions.assertNotNull((Object)this.servicesManager.findServiceBy((Service)testService));
        });
        loadingThread.join();
    }

    protected ServicesManager getServicesManagerInstance() {
        return new DefaultServicesManager(this.getConfigurationContext());
    }

    protected ServicesManagerConfigurationContext getConfigurationContext() {
        StaticApplicationContext applicationContext = new StaticApplicationContext();
        applicationContext.refresh();
        return ServicesManagerConfigurationContext.builder().serviceRegistry(this.serviceRegistry).registeredServicesTemplatesManager((RegisteredServicesTemplatesManager)Mockito.mock(RegisteredServicesTemplatesManager.class)).applicationContext((ConfigurableApplicationContext)applicationContext).environments(new HashSet(0)).registeredServiceLocators(List.of(new DefaultServicesManagerRegisteredServiceLocator())).servicesCache(Caffeine.newBuilder().expireAfterWrite(Duration.ofSeconds(2L)).build()).build();
    }

    protected ServiceRegistry getServiceRegistryInstance() {
        StaticApplicationContext appCtx = new StaticApplicationContext();
        appCtx.refresh();
        return new InMemoryServiceRegistry((ConfigurableApplicationContext)appCtx, this.listOfDefaultServices, new ArrayList());
    }

    protected boolean isServiceInCache(String serviceId, long id) {
        return this.servicesManager.getAllServices().stream().anyMatch(r -> Optional.ofNullable(serviceId).map(s -> r.getServiceId().equals(s)).orElseGet(() -> r.getId() == id));
    }
}

