/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.principal.PersistentIdGenerator;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ShibbolethCompatiblePersistentIdGenerator;
import org.apereo.cas.services.AnonymousRegisteredServiceUsernameAttributeProvider;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.RegisteredServiceUsernameProviderContext;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.StaticApplicationContext;

@Tag(value="RegisteredService")
class AnonymousRegisteredServiceUsernameAttributeProviderTests {
    private static final File JSON_FILE = new File(FileUtils.getTempDirectoryPath(), "anonymousRegisteredServiceUsernameAttributeProvider.json");
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();
    private static final String CASROX = "casrox";

    AnonymousRegisteredServiceUsernameAttributeProviderTests() {
    }

    @Test
    void verifyPrincipalResolution() throws Throwable {
        AnonymousRegisteredServiceUsernameAttributeProvider provider = new AnonymousRegisteredServiceUsernameAttributeProvider((PersistentIdGenerator)new ShibbolethCompatiblePersistentIdGenerator(CASROX));
        StaticApplicationContext applicationContext = new StaticApplicationContext();
        applicationContext.refresh();
        Service service = (Service)Mockito.mock(Service.class);
        Mockito.when((Object)service.getId()).thenReturn((Object)"id");
        Principal principal = (Principal)Mockito.mock(Principal.class);
        Mockito.when((Object)principal.getId()).thenReturn((Object)"uid");
        RegisteredServiceUsernameProviderContext usernameContext = RegisteredServiceUsernameProviderContext.builder().registeredService((RegisteredService)RegisteredServiceTestUtils.getRegisteredService("id")).service(service).principal(principal).applicationContext((ApplicationContext)applicationContext).build();
        String id = provider.resolveUsername(usernameContext);
        Assertions.assertNotNull((Object)id);
    }

    @Test
    void verifyEquality() throws Throwable {
        AnonymousRegisteredServiceUsernameAttributeProvider provider = new AnonymousRegisteredServiceUsernameAttributeProvider((PersistentIdGenerator)new ShibbolethCompatiblePersistentIdGenerator(CASROX));
        AnonymousRegisteredServiceUsernameAttributeProvider provider2 = new AnonymousRegisteredServiceUsernameAttributeProvider((PersistentIdGenerator)new ShibbolethCompatiblePersistentIdGenerator(CASROX));
        Assertions.assertEquals((Object)provider, (Object)provider2);
    }

    @Test
    void verifySerializeADefaultRegisteredServiceUsernameProviderToJson() throws IOException {
        AnonymousRegisteredServiceUsernameAttributeProvider providerWritten = new AnonymousRegisteredServiceUsernameAttributeProvider((PersistentIdGenerator)new ShibbolethCompatiblePersistentIdGenerator(CASROX));
        MAPPER.writeValue(JSON_FILE, (Object)providerWritten);
        AnonymousRegisteredServiceUsernameAttributeProvider providerRead = (AnonymousRegisteredServiceUsernameAttributeProvider)MAPPER.readValue(JSON_FILE, AnonymousRegisteredServiceUsernameAttributeProvider.class);
        Assertions.assertEquals((Object)providerWritten, (Object)providerRead);
    }

    @Test
    void verifyGeneratedIdsMatch() throws Throwable {
        String salt = "nJ+G!VgGt=E2xCJp@Kb+qjEjE4R2db7NEW!9ofjMNas2Tq3h5h!nCJxc3Sr#kv=7JwU?#MN=7e+r!wpcMw5RF42G8J8tNkGp4g4rFZ#RnNECL@wZX5=yia+KPEwwq#CA9EM38=ZkjK2mzv6oczCVC!m8k!=6@!MW@xTMYH8eSV@7yc24Bz6NUstzbTWH3pnGojZm7pW8NwjLypvZKqhn7agai295kFBhMmpS\n9Jz9+jhVkJfFjA32GiTkZ5hvYiFG104xWnMbHk7TsGrfw%tvACAs=f3C";
        ShibbolethCompatiblePersistentIdGenerator gen = new ShibbolethCompatiblePersistentIdGenerator("nJ+G!VgGt=E2xCJp@Kb+qjEjE4R2db7NEW!9ofjMNas2Tq3h5h!nCJxc3Sr#kv=7JwU?#MN=7e+r!wpcMw5RF42G8J8tNkGp4g4rFZ#RnNECL@wZX5=yia+KPEwwq#CA9EM38=ZkjK2mzv6oczCVC!m8k!=6@!MW@xTMYH8eSV@7yc24Bz6NUstzbTWH3pnGojZm7pW8NwjLypvZKqhn7agai295kFBhMmpS\n9Jz9+jhVkJfFjA32GiTkZ5hvYiFG104xWnMbHk7TsGrfw%tvACAs=f3C");
        gen.setAttribute("employeeId");
        AnonymousRegisteredServiceUsernameAttributeProvider provider = new AnonymousRegisteredServiceUsernameAttributeProvider((PersistentIdGenerator)gen);
        StaticApplicationContext applicationContext = new StaticApplicationContext();
        applicationContext.refresh();
        RegisteredServiceUsernameProviderContext usernameContext = RegisteredServiceUsernameProviderContext.builder().registeredService((RegisteredService)CoreAuthenticationTestUtils.getRegisteredService()).service(CoreAuthenticationTestUtils.getService((String)"https://cas.example.org/app")).applicationContext((ApplicationContext)applicationContext).principal(CoreAuthenticationTestUtils.getPrincipal((String)"anyuser", (Map)CollectionUtils.wrap((String)"employeeId", List.of("T911327")))).build();
        String result = provider.resolveUsername(usernameContext);
        Assertions.assertEquals((Object)"ujWTRNKPPso8S+4geOvcOZtv778=", (Object)result);
    }

    @Test
    void verifyGeneratedIdsMatchMultiValuedAttribute() throws Throwable {
        String salt = "whydontyoustringmealong";
        ShibbolethCompatiblePersistentIdGenerator gen = new ShibbolethCompatiblePersistentIdGenerator("whydontyoustringmealong");
        gen.setAttribute("uid");
        AnonymousRegisteredServiceUsernameAttributeProvider provider = new AnonymousRegisteredServiceUsernameAttributeProvider((PersistentIdGenerator)gen);
        StaticApplicationContext applicationContext = new StaticApplicationContext();
        applicationContext.refresh();
        RegisteredServiceUsernameProviderContext usernameContext = RegisteredServiceUsernameProviderContext.builder().registeredService((RegisteredService)CoreAuthenticationTestUtils.getRegisteredService()).service(CoreAuthenticationTestUtils.getService((String)"https://sp.testshib.org/shibboleth-sp")).applicationContext((ApplicationContext)applicationContext).principal(CoreAuthenticationTestUtils.getPrincipal((String)"anyuser", (Map)CollectionUtils.wrap((String)"uid", (Object)CollectionUtils.wrap((Object)"obegon")))).build();
        String result = provider.resolveUsername(usernameContext);
        Assertions.assertEquals((Object)"lykoGRE9QbbrsEBlHJVEz0U8AJ0=", (Object)result);
    }
}

