/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.io.File;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.services.AbstractServiceRegistryTests;
import org.apereo.cas.services.BaseRegisteredService;
import org.apereo.cas.services.CasRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ResourceBasedServiceRegistry;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.services.replication.RegisteredServiceReplicationStrategy;
import org.apereo.cas.services.resource.AbstractResourceBasedServiceRegistry;
import org.apereo.cas.services.resource.DefaultRegisteredServiceResourceNamingStrategy;
import org.apereo.cas.services.resource.RegisteredServiceResourceNamingStrategy;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.util.io.WatcherService;
import org.apereo.cas.util.serialization.StringSerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.core.io.ClassPathResource;

public abstract class BaseResourceBasedServiceRegistryTests
extends AbstractServiceRegistryTests {
    public static final ClassPathResource RESOURCE = new ClassPathResource("services");
    protected ResourceBasedServiceRegistry newServiceRegistry;

    @Override
    public void tearDownServiceRegistry() throws Exception {
        FileUtils.cleanDirectory((File)RESOURCE.getFile());
        super.tearDownServiceRegistry();
    }

    @Override
    protected ServiceRegistry getNewServiceRegistry() throws Exception {
        return this.newServiceRegistry;
    }

    @Test
    void verifyServiceWithInvalidFileName() {
        this.getRegisteredServiceTypes().forEach(type -> {
            BaseRegisteredService registeredService = BaseResourceBasedServiceRegistryTests.buildRegisteredServiceInstance(RandomUtils.nextInt(), type);
            registeredService.setName("hell/o@world:*");
            Assertions.assertThrows(IllegalArgumentException.class, () -> this.newServiceRegistry.save((RegisteredService)registeredService));
        });
    }

    @Test
    void verifyInvalidFileLoad() {
        File file = (File)Mockito.mock(File.class);
        Mockito.when((Object)file.canRead()).thenReturn((Object)Boolean.FALSE);
        Assertions.assertTrue((boolean)this.newServiceRegistry.load(file).isEmpty());
        Mockito.when((Object)file.exists()).thenReturn((Object)Boolean.FALSE);
        Assertions.assertTrue((boolean)this.newServiceRegistry.load(file).isEmpty());
        Mockito.when((Object)file.length()).thenReturn((Object)0L);
        Assertions.assertTrue((boolean)this.newServiceRegistry.load(file).isEmpty());
        Mockito.when((Object)file.getName()).thenReturn((Object)".ignore");
        Assertions.assertTrue((boolean)this.newServiceRegistry.load(file).isEmpty());
        Mockito.when((Object)file.getName()).thenReturn((Object)"file.ignore");
        Assertions.assertTrue((boolean)this.newServiceRegistry.load(file).isEmpty());
    }

    @Test
    void verify() {
        StaticApplicationContext applicationContext = new StaticApplicationContext();
        applicationContext.refresh();
        StringSerializer serializer = (StringSerializer)Mockito.mock(StringSerializer.class);
        ((StringSerializer)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)serializer)).to((OutputStream)Mockito.any(OutputStream.class), Mockito.any());
        AbstractResourceBasedServiceRegistry registry = new AbstractResourceBasedServiceRegistry(this, FileUtils.getTempDirectory().toPath(), serializer, (ConfigurableApplicationContext)applicationContext, (RegisteredServiceReplicationStrategy)Mockito.mock(RegisteredServiceReplicationStrategy.class), (RegisteredServiceResourceNamingStrategy)new DefaultRegisteredServiceResourceNamingStrategy(), List.of(), (WatcherService)Mockito.mock(WatcherService.class)){

            protected String[] getExtensions() {
                return new String[]{".json"};
            }
        };
        BaseRegisteredService r = BaseResourceBasedServiceRegistryTests.buildRegisteredServiceInstance(RandomUtils.nextInt(), CasRegisteredService.class);
        Assertions.assertThrows(IllegalArgumentException.class, () -> BaseResourceBasedServiceRegistryTests.lambda$verify$2(registry, r));
        registry.destroy();
    }

    private static /* synthetic */ void lambda$verify$2(1 registry, BaseRegisteredService r) throws Throwable {
        registry.save((RegisteredService)r);
    }
}

