/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.authentication.principal.AbstractWebApplicationService;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.support.TriStateBoolean;
import org.apereo.cas.services.AuthenticationDateRegisteredServiceSingleSignOnParticipationPolicy;
import org.apereo.cas.services.CasRegisteredService;
import org.apereo.cas.services.ChainingRegisteredServiceSingleSignOnParticipationPolicy;
import org.apereo.cas.services.DefaultRegisteredServiceProxyTicketExpirationPolicy;
import org.apereo.cas.services.DefaultRegisteredServiceServiceTicketExpirationPolicy;
import org.apereo.cas.services.LastUsedTimeRegisteredServiceSingleSignOnParticipationPolicy;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceConsentPolicy;
import org.apereo.cas.services.RegisteredServiceLogoutType;
import org.apereo.cas.services.RegisteredServiceProxyTicketExpirationPolicy;
import org.apereo.cas.services.RegisteredServiceServiceTicketExpirationPolicy;
import org.apereo.cas.services.RegisteredServiceSingleSignOnParticipationPolicy;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.ReturnAllowedAttributeReleasePolicy;
import org.apereo.cas.services.consent.DefaultRegisteredServiceConsentPolicy;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;

@Tag(value="RegisteredService")
class CasRegisteredServiceTests {
    private static final File JSON_FILE = new File(FileUtils.getTempDirectoryPath(), "CasRegisteredService.json");
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();

    CasRegisteredServiceTests() {
    }

    public static Stream<Arguments> getParameters() {
        String domainCatchallHttp = "https*://([A-Za-z0-9_-]+\\.)+vt\\.edu/.*";
        String domainCatchallHttpImap = "(https*|imaps*)://([A-Za-z0-9_-]+\\.)+vt\\.edu/.*";
        String globalCatchallHttpImap = "(https*|imaps*)://.*";
        return Stream.of(Arguments.arguments((Object[])new Object[]{CasRegisteredServiceTests.newService("https*://([A-Za-z0-9_-]+\\.)+vt\\.edu/.*"), "https://service.vt.edu/webapp?a=1", true}), Arguments.arguments((Object[])new Object[]{CasRegisteredServiceTests.newService("https*://([A-Za-z0-9_-]+\\.)+vt\\.edu/.*"), "http://test-01.service.vt.edu/webapp?a=1", true}), Arguments.arguments((Object[])new Object[]{CasRegisteredServiceTests.newService("https*://([A-Za-z0-9_-]+\\.)+vt\\.edu/.*"), "https://thepiratebay.se?service.vt.edu/webapp?a=1", false}), Arguments.arguments((Object[])new Object[]{CasRegisteredServiceTests.newService("(https*|imaps*)://([A-Za-z0-9_-]+\\.)+vt\\.edu/.*"), "http://test_service.vt.edu/login", true}), Arguments.arguments((Object[])new Object[]{CasRegisteredServiceTests.newService("(https*|imaps*)://([A-Za-z0-9_-]+\\.)+vt\\.edu/.*"), "imaps://imap-server-01.vt.edu/", true}), Arguments.arguments((Object[])new Object[]{CasRegisteredServiceTests.newService("(https*|imaps*)://.*"), "https://host-01.example.com/", true}), Arguments.arguments((Object[])new Object[]{CasRegisteredServiceTests.newService("(https*|imaps*)://.*"), "imap://host-02.example.edu/", true}), Arguments.arguments((Object[])new Object[]{CasRegisteredServiceTests.newService("(https*|imaps*)://.*"), null, false}));
    }

    private static RegisteredService newService(String id) {
        CasRegisteredService service = new CasRegisteredService();
        service.setServiceId(id);
        service.setLogoutType(RegisteredServiceLogoutType.FRONT_CHANNEL);
        service.setServiceTicketExpirationPolicy((RegisteredServiceServiceTicketExpirationPolicy)new DefaultRegisteredServiceServiceTicketExpirationPolicy(100L, "100"));
        service.setProxyTicketExpirationPolicy((RegisteredServiceProxyTicketExpirationPolicy)new DefaultRegisteredServiceProxyTicketExpirationPolicy(100L, "100"));
        ChainingRegisteredServiceSingleSignOnParticipationPolicy policy = new ChainingRegisteredServiceSingleSignOnParticipationPolicy();
        policy.addPolicies(Arrays.asList(new LastUsedTimeRegisteredServiceSingleSignOnParticipationPolicy(TimeUnit.SECONDS, 100L, 1), new AuthenticationDateRegisteredServiceSingleSignOnParticipationPolicy(TimeUnit.SECONDS, 100L, 1)));
        service.setSingleSignOnParticipationPolicy((RegisteredServiceSingleSignOnParticipationPolicy)policy);
        DefaultRegisteredServiceConsentPolicy consent = new DefaultRegisteredServiceConsentPolicy(CollectionUtils.wrapSet((Object[])new String[]{"attr1", "attr2"}), CollectionUtils.wrapSet((Object[])new String[]{"ex-attr1", "ex-attr2"}));
        consent.setStatus(TriStateBoolean.TRUE);
        ReturnAllowedAttributeReleasePolicy attrPolicy = new ReturnAllowedAttributeReleasePolicy();
        attrPolicy.setConsentPolicy((RegisteredServiceConsentPolicy)consent);
        service.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)attrPolicy);
        return service;
    }

    @ParameterizedTest
    @MethodSource(value={"getParameters"})
    void verifyMatches(CasRegisteredService service, String serviceToMatch, boolean expectedResult) {
        AbstractWebApplicationService testService = Optional.ofNullable(serviceToMatch).map(RegisteredServiceTestUtils::getService).orElse(null);
        Assertions.assertEquals((Object)expectedResult, (Object)service.matches((Service)testService));
    }

    @ParameterizedTest
    @MethodSource(value={"getParameters"})
    void verifySerialization(CasRegisteredService service, String serviceToMatch, boolean expectedResult) throws IOException {
        MAPPER.writeValue(JSON_FILE, (Object)service);
        CasRegisteredService serviceRead = (CasRegisteredService)MAPPER.readValue(JSON_FILE, CasRegisteredService.class);
        Assertions.assertEquals((Object)service, (Object)serviceRead);
        AbstractWebApplicationService testService = Optional.ofNullable(serviceToMatch).map(RegisteredServiceTestUtils::getService).orElse(null);
        Assertions.assertEquals((Object)expectedResult, (Object)serviceRead.matches((Service)testService));
    }

    @Test
    void verifyDefaultMatchingStrategy() throws Throwable {
        CasRegisteredService service = new CasRegisteredService();
        service.setMatchingStrategy(null);
        service.setServiceId("\\d\\d\\d");
        Assertions.assertFalse((boolean)service.matches("https://google123.com"));
    }

    @Test
    void verifyDefaults() throws Throwable {
        RegisteredService service = (RegisteredService)Mockito.mock(RegisteredService.class);
        Mockito.when((Object)service.getDescription()).thenCallRealMethod();
        Mockito.when((Object)service.getFriendlyName()).thenCallRealMethod();
        ((RegisteredService)Mockito.doCallRealMethod().when((Object)service)).initialize();
        Assertions.assertNotNull((Object)service.getDescription());
        Assertions.assertNotNull((Object)service.getFriendlyName());
        Assertions.assertDoesNotThrow(() -> ((RegisteredService)service).initialize());
    }
}

