/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.configuration.support.TriStateBoolean;
import org.apereo.cas.services.AttributeBasedRegisteredServiceSingleSignOnParticipationPolicy;
import org.apereo.cas.services.AuthenticationDateRegisteredServiceSingleSignOnParticipationPolicy;
import org.apereo.cas.services.ChainingRegisteredServiceSingleSignOnParticipationPolicy;
import org.apereo.cas.services.LastUsedTimeRegisteredServiceSingleSignOnParticipationPolicy;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceSingleSignOnParticipationPolicy;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.ticket.AuthenticationAwareTicket;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

@Tag(value="RegisteredService")
class ChainingRegisteredServiceSingleSignOnParticipationPolicyTests {
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();

    ChainingRegisteredServiceSingleSignOnParticipationPolicyTests() {
    }

    @Test
    void verifyOperation() throws Throwable {
        RegisteredServiceSingleSignOnParticipationPolicy input = (RegisteredServiceSingleSignOnParticipationPolicy)Mockito.mock(RegisteredServiceSingleSignOnParticipationPolicy.class);
        Mockito.when((Object)input.getOrder()).thenCallRealMethod();
        Mockito.when((Object)input.getCreateCookieOnRenewedAuthentication()).thenCallRealMethod();
        Assertions.assertEquals((int)0, (int)input.getOrder());
        Assertions.assertEquals((Object)TriStateBoolean.UNDEFINED, (Object)input.getCreateCookieOnRenewedAuthentication());
    }

    @Test
    void verifySsoParticipationByAuthenticationDateFails() throws Throwable {
        Authentication authn = (Authentication)Mockito.mock(Authentication.class);
        Mockito.when((Object)authn.getAuthenticationDate()).thenReturn((Object)ZonedDateTime.now(ZoneOffset.UTC).minusSeconds(10L));
        AuthenticationAwareTicket state = (AuthenticationAwareTicket)Mockito.mock(AuthenticationAwareTicket.class);
        Mockito.when((Object)state.getAuthentication()).thenReturn((Object)authn);
        ChainingRegisteredServiceSingleSignOnParticipationPolicy chain = new ChainingRegisteredServiceSingleSignOnParticipationPolicy();
        chain.addPolicy((RegisteredServiceSingleSignOnParticipationPolicy)new AuthenticationDateRegisteredServiceSingleSignOnParticipationPolicy(TimeUnit.SECONDS, 1L, 0));
        Assertions.assertFalse((boolean)chain.shouldParticipateInSso((RegisteredService)RegisteredServiceTestUtils.getRegisteredService(), state));
    }

    @Test
    void verifySsoParticipationByAuthnAttribute() throws Throwable {
        AuthenticationAwareTicket state = (AuthenticationAwareTicket)Mockito.mock(AuthenticationAwareTicket.class);
        Mockito.when((Object)state.getAuthentication()).thenReturn((Object)CoreAuthenticationTestUtils.getAuthentication(Map.of("tag", List.of("123-abc"))));
        ChainingRegisteredServiceSingleSignOnParticipationPolicy chain = new ChainingRegisteredServiceSingleSignOnParticipationPolicy();
        AttributeBasedRegisteredServiceSingleSignOnParticipationPolicy policy = new AttributeBasedRegisteredServiceSingleSignOnParticipationPolicy();
        policy.setAttributes(Map.of("tag", List.of("123-.*")));
        chain.addPolicy((RegisteredServiceSingleSignOnParticipationPolicy)policy);
        Assertions.assertTrue((boolean)chain.shouldParticipateInSso((RegisteredService)RegisteredServiceTestUtils.getRegisteredService(), state));
    }

    @Test
    void verifySsoParticipationByPrincipalAttribute() throws Throwable {
        AuthenticationAwareTicket state = (AuthenticationAwareTicket)Mockito.mock(AuthenticationAwareTicket.class);
        Mockito.when((Object)state.getAuthentication()).thenReturn((Object)CoreAuthenticationTestUtils.getAuthentication((String)"casuser", Map.of("cn", List.of("1/2/3"))));
        ChainingRegisteredServiceSingleSignOnParticipationPolicy chain = new ChainingRegisteredServiceSingleSignOnParticipationPolicy();
        AttributeBasedRegisteredServiceSingleSignOnParticipationPolicy policy = new AttributeBasedRegisteredServiceSingleSignOnParticipationPolicy();
        policy.setAttributes(Map.of("cn", List.of("\\d/\\d/\\d")));
        chain.addPolicy((RegisteredServiceSingleSignOnParticipationPolicy)policy);
        Assertions.assertTrue((boolean)chain.shouldParticipateInSso((RegisteredService)RegisteredServiceTestUtils.getRegisteredService(), state));
    }

    @Test
    void verifySsoParticipationByAttributeAsJson() throws IOException {
        AttributeBasedRegisteredServiceSingleSignOnParticipationPolicy policy = new AttributeBasedRegisteredServiceSingleSignOnParticipationPolicy();
        policy.setAttributes(Map.of("cn", List.of("\\d/\\d/\\d")));
        policy.setRequireAllAttributes(true);
        File file = Files.createTempFile("attr", ".json", new FileAttribute[0]).toFile();
        MAPPER.writeValue(file, (Object)policy);
        AttributeBasedRegisteredServiceSingleSignOnParticipationPolicy read = (AttributeBasedRegisteredServiceSingleSignOnParticipationPolicy)MAPPER.readValue(file, AttributeBasedRegisteredServiceSingleSignOnParticipationPolicy.class);
        Assertions.assertEquals((Object)policy, (Object)read);
    }

    @Test
    void verifySsoParticipationAllAttributes() throws Throwable {
        AuthenticationAwareTicket state = (AuthenticationAwareTicket)Mockito.mock(AuthenticationAwareTicket.class);
        Mockito.when((Object)state.getAuthentication()).thenReturn((Object)CoreAuthenticationTestUtils.getAuthentication((String)"casuser", Map.of("cn", List.of("1/2/3"))));
        ChainingRegisteredServiceSingleSignOnParticipationPolicy chain = new ChainingRegisteredServiceSingleSignOnParticipationPolicy();
        AttributeBasedRegisteredServiceSingleSignOnParticipationPolicy policy = new AttributeBasedRegisteredServiceSingleSignOnParticipationPolicy();
        policy.setAttributes(Map.of("cn", List.of("\\d/\\d/\\d"), "attr2", List.of("absent")));
        policy.setRequireAllAttributes(true);
        chain.addPolicy((RegisteredServiceSingleSignOnParticipationPolicy)policy);
        Assertions.assertFalse((boolean)chain.shouldParticipateInSso((RegisteredService)RegisteredServiceTestUtils.getRegisteredService(), state));
    }

    @Test
    void verifySsoParticipationByAuthenticationDatePasses() throws Throwable {
        Authentication authn = (Authentication)Mockito.mock(Authentication.class);
        Mockito.when((Object)authn.getAuthenticationDate()).thenReturn((Object)ZonedDateTime.now(ZoneOffset.UTC).plusSeconds(5L));
        AuthenticationAwareTicket state = (AuthenticationAwareTicket)Mockito.mock(AuthenticationAwareTicket.class);
        Mockito.when((Object)state.getAuthentication()).thenReturn((Object)authn);
        ChainingRegisteredServiceSingleSignOnParticipationPolicy chain = new ChainingRegisteredServiceSingleSignOnParticipationPolicy();
        chain.addPolicy((RegisteredServiceSingleSignOnParticipationPolicy)new AuthenticationDateRegisteredServiceSingleSignOnParticipationPolicy(TimeUnit.SECONDS, 10L, 0));
        Assertions.assertTrue((boolean)chain.shouldParticipateInSso((RegisteredService)RegisteredServiceTestUtils.getRegisteredService(), state));
    }

    @Test
    void verifySsoParticipationByLastUsedTimeFails() throws Throwable {
        AuthenticationAwareTicket state = (AuthenticationAwareTicket)Mockito.mock(AuthenticationAwareTicket.class);
        Mockito.when((Object)state.getLastTimeUsed()).thenReturn((Object)ZonedDateTime.now(ZoneOffset.UTC).minusSeconds(10L));
        ChainingRegisteredServiceSingleSignOnParticipationPolicy chain = new ChainingRegisteredServiceSingleSignOnParticipationPolicy();
        chain.addPolicy((RegisteredServiceSingleSignOnParticipationPolicy)new LastUsedTimeRegisteredServiceSingleSignOnParticipationPolicy(TimeUnit.SECONDS, 1L, 0));
        Assertions.assertFalse((boolean)chain.shouldParticipateInSso((RegisteredService)RegisteredServiceTestUtils.getRegisteredService(), state));
    }

    @Test
    void verifySsoParticipationByLastUsedTimePasses() throws Throwable {
        AuthenticationAwareTicket state = (AuthenticationAwareTicket)Mockito.mock(AuthenticationAwareTicket.class);
        Mockito.when((Object)state.getLastTimeUsed()).thenReturn((Object)ZonedDateTime.now(ZoneOffset.UTC).plusSeconds(5L));
        ChainingRegisteredServiceSingleSignOnParticipationPolicy chain = new ChainingRegisteredServiceSingleSignOnParticipationPolicy();
        chain.addPolicy((RegisteredServiceSingleSignOnParticipationPolicy)new LastUsedTimeRegisteredServiceSingleSignOnParticipationPolicy(TimeUnit.SECONDS, 10L, 0));
        Assertions.assertTrue((boolean)chain.shouldParticipateInSso((RegisteredService)RegisteredServiceTestUtils.getRegisteredService(), state));
    }

    @Test
    void verifyPolicies() throws Throwable {
        ChainingRegisteredServiceSingleSignOnParticipationPolicy chain = new ChainingRegisteredServiceSingleSignOnParticipationPolicy();
        chain.addPolicies(new RegisteredServiceSingleSignOnParticipationPolicy[]{new LastUsedTimeRegisteredServiceSingleSignOnParticipationPolicy(TimeUnit.SECONDS, 10L, 0)});
        Assertions.assertFalse((boolean)chain.getPolicies().isEmpty());
        Assertions.assertEquals((Object)TriStateBoolean.TRUE, (Object)chain.getCreateCookieOnRenewedAuthentication());
    }
}

