/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.util.Collection;
import java.util.UUID;
import java.util.stream.Stream;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.AbstractServicesManagerTests;
import org.apereo.cas.services.CasRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.mgmt.DefaultChainingServicesManager;
import org.apereo.cas.util.RandomUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

@Tag(value="RegisteredService")
class DefaultChainingServicesManagerTests
extends AbstractServicesManagerTests<DefaultChainingServicesManager> {
    DefaultChainingServicesManagerTests() {
    }

    @Test
    void verifyOperation() throws Throwable {
        ServicesManager mock = (ServicesManager)Mockito.mock(ServicesManager.class);
        Mockito.when((Object)mock.findServiceBy(Mockito.anyLong(), (Class)Mockito.any())).thenCallRealMethod();
        Mockito.when((Object)mock.findServiceByName(Mockito.anyString(), (Class)Mockito.any())).thenCallRealMethod();
        Mockito.when((Object)mock.count()).thenCallRealMethod();
        Mockito.when((Object)mock.getName()).thenCallRealMethod();
        Mockito.when((Object)mock.getOrder()).thenCallRealMethod();
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)mock.getOrder());
        Assertions.assertEquals((long)0L, (long)mock.count());
        Assertions.assertNotNull((Object)mock.getName());
        Assertions.assertNull((Object)mock.findServiceBy(0L, CasRegisteredService.class));
    }

    @Test
    void verifySupports() throws Throwable {
        CasRegisteredService r = new CasRegisteredService();
        r.setId(10L);
        r.setName("domainService1");
        r.setServiceId("https://www.example.com/one");
        this.servicesManager.save((RegisteredService)r);
        Assertions.assertTrue((boolean)this.servicesManager.supports(CasRegisteredService.class));
        Assertions.assertTrue((boolean)this.servicesManager.supports((RegisteredService)r));
        Assertions.assertTrue((boolean)this.servicesManager.supports((Service)RegisteredServiceTestUtils.getService()));
    }

    @Test
    void verifySaveWithDomains() throws Throwable {
        CasRegisteredService svc = new CasRegisteredService();
        svc.setId(RandomUtils.nextLong());
        svc.setName("domainService2");
        svc.setServiceId("https://www.example.com/" + svc.getId());
        Assertions.assertNotNull((Object)this.servicesManager.save((RegisteredService)svc, false));
        Assertions.assertEquals((long)1L, (long)this.servicesManager.getDomains().count());
        Assertions.assertFalse((boolean)this.servicesManager.getServicesForDomain("example.org").isEmpty());
    }

    @Test
    void verifySaveInBulk() throws Throwable {
        this.servicesManager.deleteAll();
        this.servicesManager.save(() -> {
            CasRegisteredService svc = new CasRegisteredService();
            svc.setId(RandomUtils.nextLong());
            svc.setName("domainService2");
            svc.setServiceId("https://www.example.com/" + svc.getId());
            return svc;
        }, Assertions::assertNotNull, 10L);
        Collection results = this.servicesManager.load();
        Assertions.assertEquals((int)10, (int)results.size());
    }

    @Test
    void verifySaveInStreams() throws Throwable {
        this.servicesManager.deleteAll();
        CasRegisteredService s1 = RegisteredServiceTestUtils.getRegisteredService(UUID.randomUUID().toString(), true);
        CasRegisteredService s2 = RegisteredServiceTestUtils.getRegisteredService(UUID.randomUUID().toString(), true);
        this.servicesManager.save(Stream.of(s1, s2));
        Collection results = this.servicesManager.load();
        Assertions.assertEquals((int)2, (int)results.size());
    }

    @Override
    protected ServicesManager getServicesManagerInstance() {
        DefaultChainingServicesManager chain = new DefaultChainingServicesManager();
        chain.registerServiceManager(super.getServicesManagerInstance());
        return chain;
    }
}

