/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.HashSet;
import java.util.List;
import lombok.Generated;
import org.apereo.cas.services.AbstractServicesManagerTests;
import org.apereo.cas.services.CasRegisteredService;
import org.apereo.cas.services.DefaultServicesManagerRegisteredServiceLocator;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServicesTemplatesManager;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.ServicesManagerConfigurationContext;
import org.apereo.cas.services.domain.DefaultDomainAwareServicesManager;
import org.apereo.cas.services.domain.DefaultRegisteredServiceDomainExtractor;
import org.apereo.cas.services.domain.RegisteredServiceDomainExtractor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.StaticApplicationContext;

@Tag(value="RegisteredService")
class DefaultDomainAwareServicesManagerTests
extends AbstractServicesManagerTests<DefaultDomainAwareServicesManager> {
    private DefaultDomainAwareServicesManager domainServicesManager;

    @Test
    void verifyChangingDomain() throws Throwable {
        this.servicesManager.deleteAll();
        CasRegisteredService r = new CasRegisteredService();
        r.setId(1L);
        r.setName("domainService1");
        r.setServiceId("https://company.com.*");
        this.servicesManager.save((RegisteredService)r);
        Assertions.assertFalse((boolean)this.domainServicesManager.getServicesForDomain("company.com").isEmpty());
        Assertions.assertTrue((boolean)this.domainServicesManager.getServicesForDomain("default").isEmpty());
        r.setServiceId("https://company.com/.*");
        this.servicesManager.save((RegisteredService)r);
        Assertions.assertFalse((boolean)this.domainServicesManager.getServicesForDomain("company.com").isEmpty());
        Assertions.assertTrue((boolean)this.domainServicesManager.getServicesForDomain("default").isEmpty());
        Assertions.assertEquals((long)1L, (long)this.domainServicesManager.getDomains().count());
        r.setServiceId("default-.+.com");
        this.servicesManager.save((RegisteredService)r);
        Assertions.assertTrue((boolean)this.domainServicesManager.getServicesForDomain("company.com").isEmpty());
        Assertions.assertFalse((boolean)this.domainServicesManager.getServicesForDomain("default").isEmpty());
    }

    @Test
    void verifyDeleteEmptyDomains() throws Throwable {
        this.servicesManager.deleteAll();
        CasRegisteredService r = new CasRegisteredService();
        r.setId(10L);
        r.setName("domainService1");
        r.setServiceId("https://www.example.com/one");
        this.servicesManager.save((RegisteredService)r);
        Assertions.assertTrue((boolean)this.domainServicesManager.getServicesForDomain("nothing.com").isEmpty());
        Assertions.assertFalse((boolean)this.domainServicesManager.getServicesForDomain("www.example.com").isEmpty());
        r = new CasRegisteredService();
        r.setId(20L);
        r.setName("domainService2");
        r.setServiceId("https://www.example.com/two");
        this.servicesManager.save((RegisteredService)r);
        Assertions.assertNull((Object)this.domainServicesManager.findServiceBy(this.serviceFactory.createService("https://whatever.com")));
        Assertions.assertNotNull((Object)this.domainServicesManager.findServiceBy(this.serviceFactory.createService("https://www.example.com/one")));
        this.servicesManager.deleteAll();
        Assertions.assertEquals((long)0L, (long)this.domainServicesManager.getDomains().count());
    }

    @Override
    protected ServicesManager getServicesManagerInstance() {
        StaticApplicationContext applicationContext = new StaticApplicationContext();
        applicationContext.refresh();
        ServicesManagerConfigurationContext context = ServicesManagerConfigurationContext.builder().serviceRegistry(this.serviceRegistry).applicationContext((ConfigurableApplicationContext)applicationContext).registeredServicesTemplatesManager((RegisteredServicesTemplatesManager)Mockito.mock(RegisteredServicesTemplatesManager.class)).environments(new HashSet(0)).servicesCache(Caffeine.newBuilder().build()).registeredServiceLocators(List.of(new DefaultServicesManagerRegisteredServiceLocator())).build();
        this.domainServicesManager = new DefaultDomainAwareServicesManager(context, (RegisteredServiceDomainExtractor)new DefaultRegisteredServiceDomainExtractor());
        return this.domainServicesManager;
    }

    @Generated
    public DefaultDomainAwareServicesManagerTests() {
    }
}

