/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.services.DefaultRegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredServiceAccessStrategyActivationCriteria;
import org.apereo.cas.services.RegisteredServiceAccessStrategyRequest;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="RegisteredService")
class DefaultRegisteredServiceAccessStrategyTests {
    private static final File JSON_FILE = new File(FileUtils.getTempDirectoryPath(), "DefaultRegisteredServiceAccessStrategyTests.json");
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();
    private static final String TEST = "test";
    private static final String PHONE = "phone";
    private static final String GIVEN_NAME = "givenName";
    private static final String CAS = "cas";
    private static final String KAZ = "KAZ";
    private static final String CN = "cn";

    DefaultRegisteredServiceAccessStrategyTests() {
    }

    private static Map<String, Set<String>> getRequiredAttributes() {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        map.put(CN, Stream.of(CAS, "SSO").collect(Collectors.toSet()));
        map.put(GIVEN_NAME, Stream.of("CAS", KAZ).collect(Collectors.toSet()));
        map.put(PHONE, Collections.singleton("\\d\\d\\d-\\d\\d\\d-\\d\\d\\d"));
        return map;
    }

    private static Map<String, Set<String>> getRejectedAttributes() {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        map.put("address", Collections.singleton(".+"));
        map.put("role", Collections.singleton("staff"));
        return map;
    }

    private static Map getPrincipalAttributes() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(CN, CAS);
        map.put(GIVEN_NAME, Arrays.asList(CAS, KAZ));
        map.put("sn", "surname");
        map.put(PHONE, "123-456-7890");
        return map;
    }

    @Test
    void checkLoad() {
        DefaultRegisteredServiceAccessStrategy authz = new DefaultRegisteredServiceAccessStrategy(DefaultRegisteredServiceAccessStrategyTests.getRequiredAttributes(), DefaultRegisteredServiceAccessStrategyTests.getRejectedAttributes());
        authz.postLoad();
        Assertions.assertEquals((int)0, (int)authz.getOrder());
    }

    @Test
    void checkDefaultInterfaceImpls() throws Throwable {
        RegisteredServiceAccessStrategy authz = new RegisteredServiceAccessStrategy(){
            private static final long serialVersionUID = -6993120869616143038L;
        };
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)authz.getOrder());
        Assertions.assertTrue((boolean)authz.isServiceAccessAllowed((RegisteredService)RegisteredServiceTestUtils.getRegisteredService(), RegisteredServiceTestUtils.getService2()));
        Assertions.assertTrue((boolean)authz.isServiceAccessAllowedForSso((RegisteredService)RegisteredServiceTestUtils.getRegisteredService()));
        Assertions.assertTrue((boolean)authz.authorizeRequest(RegisteredServiceAccessStrategyRequest.builder().build()));
        Assertions.assertNull((Object)authz.getUnauthorizedRedirectUrl());
    }

    @Test
    void checkDefaultAuthzStrategyConfig() {
        DefaultRegisteredServiceAccessStrategy authz = new DefaultRegisteredServiceAccessStrategy();
        Assertions.assertTrue((boolean)authz.isServiceAccessAllowed((RegisteredService)RegisteredServiceTestUtils.getRegisteredService(), RegisteredServiceTestUtils.getService2()));
        Assertions.assertTrue((boolean)authz.isServiceAccessAllowedForSso((RegisteredService)RegisteredServiceTestUtils.getRegisteredService()));
    }

    @Test
    void checkDisabledAuthzStrategyConfig() {
        DefaultRegisteredServiceAccessStrategy authz = new DefaultRegisteredServiceAccessStrategy(false, true);
        Assertions.assertFalse((boolean)authz.isServiceAccessAllowed((RegisteredService)RegisteredServiceTestUtils.getRegisteredService(), RegisteredServiceTestUtils.getService2()));
        Assertions.assertTrue((boolean)authz.isServiceAccessAllowedForSso((RegisteredService)RegisteredServiceTestUtils.getRegisteredService()));
    }

    @Test
    void checkDisabledSsoAuthzStrategyConfig() {
        DefaultRegisteredServiceAccessStrategy authz = new DefaultRegisteredServiceAccessStrategy(true, false);
        Assertions.assertTrue((boolean)authz.isServiceAccessAllowed((RegisteredService)RegisteredServiceTestUtils.getRegisteredService(), RegisteredServiceTestUtils.getService2()));
        Assertions.assertFalse((boolean)authz.isServiceAccessAllowedForSso((RegisteredService)RegisteredServiceTestUtils.getRegisteredService()));
    }

    @Test
    void setAuthzStrategyConfig() {
        DefaultRegisteredServiceAccessStrategy authz = new DefaultRegisteredServiceAccessStrategy(false, false);
        authz.setEnabled(true);
        authz.setSsoEnabled(true);
        Assertions.assertTrue((boolean)authz.isServiceAccessAllowed((RegisteredService)RegisteredServiceTestUtils.getRegisteredService(), RegisteredServiceTestUtils.getService2()));
        Assertions.assertTrue((boolean)authz.isServiceAccessAllowedForSso((RegisteredService)RegisteredServiceTestUtils.getRegisteredService()));
        Assertions.assertTrue((boolean)authz.isRequireAllAttributes());
    }

    @Test
    void checkAuthzPrincipalInactive() throws Throwable {
        DefaultRegisteredServiceAccessStrategy authz = new DefaultRegisteredServiceAccessStrategy().setActivationCriteria((RegisteredServiceAccessStrategyActivationCriteria & Serializable)request -> false);
        Assertions.assertTrue((boolean)authz.authorizeRequest(RegisteredServiceAccessStrategyRequest.builder().principalId(TEST).build()));
    }

    @Test
    void checkAuthzPrincipalNoAttrRequirements() throws Throwable {
        DefaultRegisteredServiceAccessStrategy authz = new DefaultRegisteredServiceAccessStrategy();
        Assertions.assertTrue((boolean)authz.authorizeRequest(RegisteredServiceAccessStrategyRequest.builder().principalId(TEST).build()));
    }

    @Test
    void checkAuthzPrincipalWithAttrRequirementsEmptyPrincipal() throws Throwable {
        DefaultRegisteredServiceAccessStrategy authz = new DefaultRegisteredServiceAccessStrategy();
        authz.setRequiredAttributes(DefaultRegisteredServiceAccessStrategyTests.getRequiredAttributes());
        Assertions.assertFalse((boolean)authz.authorizeRequest(RegisteredServiceAccessStrategyRequest.builder().principalId(TEST).build()));
    }

    @Test
    void checkAuthzPrincipalWithAttrRequirementsAll() throws Throwable {
        DefaultRegisteredServiceAccessStrategy authz = new DefaultRegisteredServiceAccessStrategy();
        authz.setRequiredAttributes(DefaultRegisteredServiceAccessStrategyTests.getRequiredAttributes());
        Assertions.assertTrue((boolean)authz.authorizeRequest(RegisteredServiceAccessStrategyRequest.builder().principalId(TEST).attributes(DefaultRegisteredServiceAccessStrategyTests.getPrincipalAttributes()).build()));
    }

    @Test
    void checkAuthzWithAttributeRequirementAsGroovy() throws Throwable {
        DefaultRegisteredServiceAccessStrategy authz = new DefaultRegisteredServiceAccessStrategy();
        HashMap<String, Set<String>> required = new HashMap<String, Set<String>>();
        required.put(CN, Set.of("groovy { return attributes.containsKey('name') && currentValues.contains('admin') }"));
        authz.setRequiredAttributes(required);
        RegisteredServiceAccessStrategyRequest request = RegisteredServiceAccessStrategyRequest.builder().attributes(Map.of(PHONE, List.of("1234567890"))).principalId(TEST).build();
        Assertions.assertFalse((boolean)authz.authorizeRequest(request));
        request = request.withAttributes(Map.of(CN, List.of("admin"), "name", List.of("casuser")));
        Assertions.assertTrue((boolean)authz.authorizeRequest(request));
    }

    @Test
    void checkAuthzPrincipalWithAttrRequirementsMissingOne() throws Throwable {
        DefaultRegisteredServiceAccessStrategy authz = new DefaultRegisteredServiceAccessStrategy();
        authz.setRequiredAttributes(DefaultRegisteredServiceAccessStrategyTests.getRequiredAttributes());
        Map pAttrs = DefaultRegisteredServiceAccessStrategyTests.getPrincipalAttributes();
        pAttrs.remove(CN);
        Assertions.assertFalse((boolean)authz.authorizeRequest(RegisteredServiceAccessStrategyRequest.builder().principalId(TEST).attributes(pAttrs).build()));
    }

    @Test
    void checkAuthzPrincipalWithAttrRequirementsMissingOneButNotAllNeeded() throws Throwable {
        DefaultRegisteredServiceAccessStrategy authz = new DefaultRegisteredServiceAccessStrategy();
        authz.setRequiredAttributes(DefaultRegisteredServiceAccessStrategyTests.getRequiredAttributes());
        authz.setRequireAllAttributes(false);
        Map pAttrs = DefaultRegisteredServiceAccessStrategyTests.getPrincipalAttributes();
        pAttrs.remove(CN);
        Assertions.assertTrue((boolean)authz.authorizeRequest(RegisteredServiceAccessStrategyRequest.builder().principalId(TEST).attributes(pAttrs).build()));
    }

    @Test
    void checkAuthzPrincipalWithAttrRequirementsNoValueMatch() throws Throwable {
        DefaultRegisteredServiceAccessStrategy authz = new DefaultRegisteredServiceAccessStrategy();
        Map<String, Set<String>> reqs = DefaultRegisteredServiceAccessStrategyTests.getRequiredAttributes();
        reqs.remove(PHONE);
        authz.setRequiredAttributes(reqs);
        authz.setRequireAllAttributes(false);
        Map pAttrs = DefaultRegisteredServiceAccessStrategyTests.getPrincipalAttributes();
        pAttrs.remove(CN);
        pAttrs.put(GIVEN_NAME, "theName");
        Assertions.assertFalse((boolean)authz.authorizeRequest(RegisteredServiceAccessStrategyRequest.builder().principalId(TEST).attributes(pAttrs).build()));
    }

    @Test
    void checkAuthzPrincipalWithAttrRequirementsWrongValue() throws Throwable {
        Map<String, Set<String>> reqAttrs = DefaultRegisteredServiceAccessStrategyTests.getRequiredAttributes();
        reqAttrs.put(GIVEN_NAME, Collections.singleton("not present"));
        DefaultRegisteredServiceAccessStrategy authz = new DefaultRegisteredServiceAccessStrategy();
        authz.setRequireAllAttributes(true);
        authz.setRequiredAttributes(reqAttrs);
        Assertions.assertFalse((boolean)authz.authorizeRequest(RegisteredServiceAccessStrategyRequest.builder().principalId(TEST).attributes(DefaultRegisteredServiceAccessStrategyTests.getPrincipalAttributes()).build()));
    }

    @Test
    void checkAuthzPrincipalWithAttrValueCaseSensitiveComparison() throws Throwable {
        DefaultRegisteredServiceAccessStrategy authz = new DefaultRegisteredServiceAccessStrategy();
        Map<String, Set<String>> reqs = DefaultRegisteredServiceAccessStrategyTests.getRequiredAttributes();
        reqs.remove(PHONE);
        authz.setRequiredAttributes(reqs);
        Map pAttrs = DefaultRegisteredServiceAccessStrategyTests.getPrincipalAttributes();
        pAttrs.put(CN, "CAS");
        pAttrs.put(GIVEN_NAME, "kaz");
        Assertions.assertFalse((boolean)authz.authorizeRequest(RegisteredServiceAccessStrategyRequest.builder().principalId(TEST).attributes(pAttrs).build()));
    }

    @Test
    void checkRejectedAttributesNotAvailable() throws Throwable {
        DefaultRegisteredServiceAccessStrategy authz = new DefaultRegisteredServiceAccessStrategy();
        Map<String, Set<String>> reqs = DefaultRegisteredServiceAccessStrategyTests.getRequiredAttributes();
        authz.setRequiredAttributes(reqs);
        Map<String, Set<String>> rejectedAttributes = DefaultRegisteredServiceAccessStrategyTests.getRejectedAttributes();
        authz.setRejectedAttributes(rejectedAttributes);
        Map pAttrs = DefaultRegisteredServiceAccessStrategyTests.getPrincipalAttributes();
        Assertions.assertTrue((boolean)authz.authorizeRequest(RegisteredServiceAccessStrategyRequest.builder().principalId(TEST).attributes(pAttrs).build()));
    }

    @Test
    void checkRejectedAttributesAvailable() throws Throwable {
        DefaultRegisteredServiceAccessStrategy authz = new DefaultRegisteredServiceAccessStrategy();
        Map<String, Set<String>> rejectedAttributes = DefaultRegisteredServiceAccessStrategyTests.getRejectedAttributes();
        authz.setRejectedAttributes(rejectedAttributes);
        Map pAttrs = DefaultRegisteredServiceAccessStrategyTests.getPrincipalAttributes();
        pAttrs.put("address", "1234 Main Street");
        Assertions.assertTrue((boolean)authz.authorizeRequest(RegisteredServiceAccessStrategyRequest.builder().principalId(TEST).attributes(pAttrs).build()));
    }

    @Test
    void checkRejectedAttributesAvailableRequireAll() throws Throwable {
        DefaultRegisteredServiceAccessStrategy authz = new DefaultRegisteredServiceAccessStrategy();
        authz.setRequireAllAttributes(true);
        Map<String, Set<String>> rejectedAttributes = DefaultRegisteredServiceAccessStrategyTests.getRejectedAttributes();
        authz.setRejectedAttributes(rejectedAttributes);
        Map pAttrs = DefaultRegisteredServiceAccessStrategyTests.getPrincipalAttributes();
        pAttrs.put("address", "1234 Main Street");
        Assertions.assertTrue((boolean)authz.authorizeRequest(RegisteredServiceAccessStrategyRequest.builder().principalId(TEST).attributes(pAttrs).build()));
    }

    @Test
    void checkRejectedAttributesAvailableRequireAll3() throws Throwable {
        DefaultRegisteredServiceAccessStrategy authz = new DefaultRegisteredServiceAccessStrategy();
        authz.setRequireAllAttributes(false);
        Map<String, Set<String>> rejectedAttributes = DefaultRegisteredServiceAccessStrategyTests.getRejectedAttributes();
        authz.setRejectedAttributes(rejectedAttributes);
        Map pAttrs = DefaultRegisteredServiceAccessStrategyTests.getPrincipalAttributes();
        pAttrs.put("role", "nomatch");
        Assertions.assertTrue((boolean)authz.authorizeRequest(RegisteredServiceAccessStrategyRequest.builder().principalId(TEST).attributes(pAttrs).build()));
    }

    @Test
    void checkRejectedAttributesAvailableRequireAll2() throws Throwable {
        DefaultRegisteredServiceAccessStrategy authz = new DefaultRegisteredServiceAccessStrategy();
        authz.setRequireAllAttributes(false);
        Map<String, Set<String>> rejectedAttributes = DefaultRegisteredServiceAccessStrategyTests.getRejectedAttributes();
        authz.setRejectedAttributes(rejectedAttributes);
        Map pAttrs = DefaultRegisteredServiceAccessStrategyTests.getPrincipalAttributes();
        pAttrs.put("role", "staff");
        Assertions.assertFalse((boolean)authz.authorizeRequest(RegisteredServiceAccessStrategyRequest.builder().principalId(TEST).attributes(pAttrs).build()));
    }

    @Test
    void checkAuthzPrincipalWithAttrValueCaseInsensitiveComparison() throws Throwable {
        DefaultRegisteredServiceAccessStrategy authz = new DefaultRegisteredServiceAccessStrategy();
        Map<String, Set<String>> reqs = DefaultRegisteredServiceAccessStrategyTests.getRequiredAttributes();
        authz.setRequiredAttributes(reqs);
        Map pAttrs = DefaultRegisteredServiceAccessStrategyTests.getPrincipalAttributes();
        authz.setCaseInsensitive(true);
        pAttrs.put(CN, CAS);
        pAttrs.put(GIVEN_NAME, "kaz");
        Assertions.assertTrue((boolean)authz.authorizeRequest(RegisteredServiceAccessStrategyRequest.builder().principalId(TEST).attributes(pAttrs).build()));
    }

    @Test
    void checkAuthzPrincipalWithAttrValuePatternComparison() throws Throwable {
        DefaultRegisteredServiceAccessStrategy authz = new DefaultRegisteredServiceAccessStrategy();
        Map<String, Set<String>> reqs = DefaultRegisteredServiceAccessStrategyTests.getRequiredAttributes();
        reqs.remove(CN);
        reqs.remove(GIVEN_NAME);
        authz.setRequiredAttributes(reqs);
        Map pAttrs = DefaultRegisteredServiceAccessStrategyTests.getPrincipalAttributes();
        Assertions.assertTrue((boolean)authz.authorizeRequest(RegisteredServiceAccessStrategyRequest.builder().principalId(TEST).attributes(pAttrs).build()));
    }

    @Test
    void verifySerializeADefaultRegisteredServiceAccessStrategyToJson() throws IOException {
        DefaultRegisteredServiceAccessStrategy strategyWritten = new DefaultRegisteredServiceAccessStrategy();
        Map<String, Set<String>> reqs = DefaultRegisteredServiceAccessStrategyTests.getRequiredAttributes();
        reqs.remove(CN);
        reqs.remove(GIVEN_NAME);
        strategyWritten.setRequiredAttributes(reqs);
        strategyWritten.setRejectedAttributes(DefaultRegisteredServiceAccessStrategyTests.getRejectedAttributes());
        MAPPER.writeValue(JSON_FILE, (Object)strategyWritten);
        DefaultRegisteredServiceAccessStrategy strategyRead = (DefaultRegisteredServiceAccessStrategy)MAPPER.readValue(JSON_FILE, DefaultRegisteredServiceAccessStrategy.class);
        Assertions.assertEquals((Object)strategyWritten, (Object)strategyRead);
    }

    @Test
    void verifyRejectedAttributesMoreThanPrincipal() throws Throwable {
        DefaultRegisteredServiceAccessStrategy authz = new DefaultRegisteredServiceAccessStrategy();
        authz.setRejectedAttributes(DefaultRegisteredServiceAccessStrategyTests.getRejectedAttributes());
        authz.setRequiredAttributes(Map.of(CN, Set.of(CAS)));
        RegisteredServiceAccessStrategyRequest request = RegisteredServiceAccessStrategyRequest.builder().principalId(TEST).attributes(Map.of(CN, List.of(CAS))).build();
        Assertions.assertFalse((boolean)authz.authorizeRequest(request));
    }
}

