/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.services.AllAuthenticationHandlersRegisteredServiceAuthenticationPolicyCriteria;
import org.apereo.cas.services.AnyAuthenticationHandlerRegisteredServiceAuthenticationPolicyCriteria;
import org.apereo.cas.services.BaseRegisteredService;
import org.apereo.cas.services.CasRegisteredService;
import org.apereo.cas.services.DefaultRegisteredServiceAuthenticationPolicy;
import org.apereo.cas.services.GroovyRegisteredServiceAuthenticationPolicyCriteria;
import org.apereo.cas.services.RegisteredServiceAuthenticationPolicy;
import org.apereo.cas.services.RegisteredServiceAuthenticationPolicyCriteria;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.RestfulRegisteredServiceAuthenticationPolicyCriteria;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="RegisteredService")
class DefaultRegisteredServiceAuthenticationPolicyTests {
    private static final File JSON_FILE = new File(FileUtils.getTempDirectoryPath(), "ServiceAuthenticationPolicy.json");
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();

    DefaultRegisteredServiceAuthenticationPolicyTests() {
    }

    private static void verify(RegisteredServiceAuthenticationPolicyCriteria criteria) throws Exception {
        CasRegisteredService svc = RegisteredServiceTestUtils.getRegisteredService("serviceidauth");
        DefaultRegisteredServiceAuthenticationPolicy policy = new DefaultRegisteredServiceAuthenticationPolicy();
        policy.setRequiredAuthenticationHandlers(Set.of("handler1", "handler2"));
        policy.setCriteria(criteria);
        svc.setAuthenticationPolicy((RegisteredServiceAuthenticationPolicy)policy);
        MAPPER.writerWithDefaultPrettyPrinter().writeValue(JSON_FILE, (Object)svc);
        BaseRegisteredService svc2 = (BaseRegisteredService)MAPPER.readValue(JSON_FILE, BaseRegisteredService.class);
        Assertions.assertEquals((Object)svc, (Object)svc2);
    }

    @Test
    void verifyAnySerializeToJson() throws Throwable {
        AnyAuthenticationHandlerRegisteredServiceAuthenticationPolicyCriteria criteria = new AnyAuthenticationHandlerRegisteredServiceAuthenticationPolicyCriteria();
        criteria.setTryAll(true);
        DefaultRegisteredServiceAuthenticationPolicyTests.verify((RegisteredServiceAuthenticationPolicyCriteria)criteria);
    }

    @Test
    void verifyAllSerializeToJson() throws Throwable {
        AllAuthenticationHandlersRegisteredServiceAuthenticationPolicyCriteria criteria = new AllAuthenticationHandlersRegisteredServiceAuthenticationPolicyCriteria();
        DefaultRegisteredServiceAuthenticationPolicyTests.verify((RegisteredServiceAuthenticationPolicyCriteria)criteria);
    }

    @Test
    void verifyGroovySerializeToJson() throws Throwable {
        GroovyRegisteredServiceAuthenticationPolicyCriteria criteria = new GroovyRegisteredServiceAuthenticationPolicyCriteria();
        criteria.setScript("groovy { return Optional.empty() }");
        DefaultRegisteredServiceAuthenticationPolicyTests.verify((RegisteredServiceAuthenticationPolicyCriteria)criteria);
    }

    @Test
    void verifyRestfulerializeToJson() throws Throwable {
        RestfulRegisteredServiceAuthenticationPolicyCriteria criteria = new RestfulRegisteredServiceAuthenticationPolicyCriteria();
        criteria.setUrl("https://example.org");
        DefaultRegisteredServiceAuthenticationPolicyTests.verify((RegisteredServiceAuthenticationPolicyCriteria)criteria);
    }
}

