/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.services.DefaultRegisteredServiceMultifactorPolicy;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="MFA")
class DefaultRegisteredServiceMultifactorPolicyTests {
    private static final File JSON_FILE = new File(FileUtils.getTempDirectoryPath(), "defaultRegisteredServiceMultifactorPolicy.json");
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();

    DefaultRegisteredServiceMultifactorPolicyTests() {
    }

    @Test
    void verifySerializeADefaultRegisteredServiceMultifactorPolicyToJson() throws IOException {
        DefaultRegisteredServiceMultifactorPolicy policyWritten = new DefaultRegisteredServiceMultifactorPolicy();
        policyWritten.setPrincipalAttributeNameTrigger("trigger");
        policyWritten.setPrincipalAttributeValueToMatch("attribute");
        HashSet<String> providers = new HashSet<String>();
        providers.add("providerOne");
        policyWritten.setMultifactorAuthenticationProviders(providers);
        MAPPER.writeValue(JSON_FILE, (Object)policyWritten);
        DefaultRegisteredServiceMultifactorPolicy policyRead = (DefaultRegisteredServiceMultifactorPolicy)MAPPER.readValue(JSON_FILE, DefaultRegisteredServiceMultifactorPolicy.class);
        Assertions.assertEquals((Object)policyWritten, (Object)policyRead);
    }
}

