/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.services.DefaultRegisteredServiceServiceTicketExpirationPolicy;
import org.apereo.cas.services.RegisteredServiceServiceTicketExpirationPolicy;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="RegisteredService")
class DefaultRegisteredServiceServiceTicketExpirationPolicyTests {
    private static final File JSON_FILE = new File(FileUtils.getTempDirectoryPath(), "DefaultRegisteredServiceServiceTicketExpirationPolicyTests.json");
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();

    DefaultRegisteredServiceServiceTicketExpirationPolicyTests() {
    }

    @Test
    void verifySerializationToJson() throws IOException {
        DefaultRegisteredServiceServiceTicketExpirationPolicy p = new DefaultRegisteredServiceServiceTicketExpirationPolicy();
        p.setNumberOfUses(12L);
        p.setTimeToLive("60");
        MAPPER.writeValue(JSON_FILE, (Object)p);
        DefaultRegisteredServiceServiceTicketExpirationPolicy repositoryRead = (DefaultRegisteredServiceServiceTicketExpirationPolicy)MAPPER.readValue(JSON_FILE, DefaultRegisteredServiceServiceTicketExpirationPolicy.class);
        Assertions.assertEquals((Object)p, (Object)repositoryRead);
    }

    @Test
    void verifyUndefined() throws Throwable {
        RegisteredServiceServiceTicketExpirationPolicy p = RegisteredServiceServiceTicketExpirationPolicy.undefined();
        Assertions.assertNull((Object)p.getTimeToLive());
        Assertions.assertEquals((long)Long.MIN_VALUE, (long)p.getNumberOfUses());
    }
}

