/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.CasRegisteredService;
import org.apereo.cas.services.DefaultRegisteredServiceUsernameProvider;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceCipherExecutor;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.RegisteredServiceUsernameProviderContext;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.cas.util.spring.ApplicationContextProvider;
import org.apereo.services.persondir.util.CaseCanonicalizationMode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.StaticApplicationContext;

@Tag(value="RegisteredService")
class DefaultRegisteredServiceUsernameProviderTests {
    private static final File JSON_FILE = new File(FileUtils.getTempDirectoryPath(), "defaultRegisteredServiceUsernameProvider.json");
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();

    DefaultRegisteredServiceUsernameProviderTests() {
    }

    @Test
    void verifyNoCanonAndEncrypt() throws Throwable {
        StaticApplicationContext applicationContext = new StaticApplicationContext();
        ConfigurableListableBeanFactory beanFactory = applicationContext.getBeanFactory();
        RegisteredServiceCipherExecutor cipher = RegisteredServiceCipherExecutor.noOp();
        beanFactory.initializeBean((Object)cipher, "registeredServiceCipherExecutor");
        beanFactory.autowireBean((Object)cipher);
        beanFactory.registerSingleton("registeredServiceCipherExecutor", (Object)cipher);
        applicationContext.refresh();
        ApplicationContextProvider.holdApplicationContext((ApplicationContext)applicationContext);
        DefaultRegisteredServiceUsernameProvider provider = new DefaultRegisteredServiceUsernameProvider();
        provider.setCanonicalizationMode(null);
        provider.setEncryptUsername(true);
        Principal principal = RegisteredServiceTestUtils.getPrincipal("ID");
        CasRegisteredService service = RegisteredServiceTestUtils.getRegisteredService("usernameAttributeProviderService");
        RegisteredServiceUsernameProviderContext usernameContext = RegisteredServiceUsernameProviderContext.builder().registeredService((RegisteredService)service).service((Service)RegisteredServiceTestUtils.getService()).applicationContext((ApplicationContext)applicationContext).principal(principal).build();
        String id = provider.resolveUsername(usernameContext);
        provider.initialize();
        Assertions.assertEquals((Object)id, (Object)principal.getId().toUpperCase(Locale.ENGLISH));
    }

    @Test
    void verifyRegServiceUsernameUpper() throws Throwable {
        DefaultRegisteredServiceUsernameProvider provider = new DefaultRegisteredServiceUsernameProvider();
        provider.setCanonicalizationMode(CaseCanonicalizationMode.UPPER.name());
        Principal principal = RegisteredServiceTestUtils.getPrincipal("id");
        StaticApplicationContext applicationContext = new StaticApplicationContext();
        applicationContext.refresh();
        RegisteredServiceUsernameProviderContext usernameContext = RegisteredServiceUsernameProviderContext.builder().registeredService((RegisteredService)RegisteredServiceTestUtils.getRegisteredService("usernameAttributeProviderService")).service((Service)RegisteredServiceTestUtils.getService()).applicationContext((ApplicationContext)applicationContext).principal(principal).build();
        String id = provider.resolveUsername(usernameContext);
        Assertions.assertEquals((Object)id, (Object)principal.getId().toUpperCase(Locale.ENGLISH));
    }

    @Test
    void verifyPatternRemoval() throws Throwable {
        DefaultRegisteredServiceUsernameProvider provider = new DefaultRegisteredServiceUsernameProvider();
        provider.setCanonicalizationMode(CaseCanonicalizationMode.UPPER.name());
        provider.setRemovePattern("@.+");
        Principal principal = RegisteredServiceTestUtils.getPrincipal("casuser@example.org");
        StaticApplicationContext applicationContext = new StaticApplicationContext();
        applicationContext.refresh();
        RegisteredServiceUsernameProviderContext usernameContext = RegisteredServiceUsernameProviderContext.builder().registeredService((RegisteredService)RegisteredServiceTestUtils.getRegisteredService("usernameAttributeProviderService")).service((Service)RegisteredServiceTestUtils.getService()).applicationContext((ApplicationContext)applicationContext).principal(principal).build();
        String id = provider.resolveUsername(usernameContext);
        Assertions.assertEquals((Object)id, (Object)"CASUSER");
    }

    @Test
    void verifyScopedUsername() throws Throwable {
        DefaultRegisteredServiceUsernameProvider provider = new DefaultRegisteredServiceUsernameProvider();
        provider.setCanonicalizationMode(CaseCanonicalizationMode.UPPER.name());
        provider.setScope("example.org");
        Principal principal = RegisteredServiceTestUtils.getPrincipal("id");
        StaticApplicationContext applicationContext = new StaticApplicationContext();
        applicationContext.refresh();
        RegisteredServiceUsernameProviderContext usernameContext = RegisteredServiceUsernameProviderContext.builder().registeredService((RegisteredService)RegisteredServiceTestUtils.getRegisteredService("usernameAttributeProviderService")).service((Service)RegisteredServiceTestUtils.getService()).applicationContext((ApplicationContext)applicationContext).principal(principal).build();
        String id = provider.resolveUsername(usernameContext);
        Assertions.assertEquals((Object)id, (Object)principal.getId().toUpperCase(Locale.ENGLISH).concat("@EXAMPLE.ORG"));
    }

    @Test
    void verifyRegServiceUsername() throws Throwable {
        DefaultRegisteredServiceUsernameProvider provider = new DefaultRegisteredServiceUsernameProvider();
        Principal principal = RegisteredServiceTestUtils.getPrincipal("id");
        StaticApplicationContext applicationContext = new StaticApplicationContext();
        applicationContext.refresh();
        RegisteredServiceUsernameProviderContext usernameContext = RegisteredServiceUsernameProviderContext.builder().registeredService((RegisteredService)RegisteredServiceTestUtils.getRegisteredService("id")).service((Service)RegisteredServiceTestUtils.getService()).applicationContext((ApplicationContext)applicationContext).principal(principal).build();
        String id = provider.resolveUsername(usernameContext);
        Assertions.assertEquals((Object)id, (Object)principal.getId());
    }

    @Test
    void verifyEquality() throws Throwable {
        DefaultRegisteredServiceUsernameProvider provider = new DefaultRegisteredServiceUsernameProvider();
        DefaultRegisteredServiceUsernameProvider provider2 = new DefaultRegisteredServiceUsernameProvider();
        Assertions.assertEquals((Object)provider, (Object)provider2);
    }

    @Test
    void verifySerializeADefaultRegisteredServiceUsernameProviderToJson() throws Throwable {
        DefaultRegisteredServiceUsernameProvider providerWritten = new DefaultRegisteredServiceUsernameProvider();
        MAPPER.writeValue(JSON_FILE, (Object)providerWritten);
        DefaultRegisteredServiceUsernameProvider providerRead = (DefaultRegisteredServiceUsernameProvider)MAPPER.readValue(JSON_FILE, DefaultRegisteredServiceUsernameProvider.class);
        Assertions.assertEquals((Object)providerWritten, (Object)providerRead);
    }
}

