/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.util.List;
import java.util.Set;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.CasRegisteredService;
import org.apereo.cas.services.DefaultRegisteredServiceProperty;
import org.apereo.cas.services.DefaultRegisteredServicesTemplatesManager;
import org.apereo.cas.services.PrincipalAttributeRegisteredServiceUsernameProvider;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceUsernameAttributeProvider;
import org.apereo.cas.services.RegisteredServicesTemplatesManager;
import org.apereo.cas.services.ReturnAllowedAttributeReleasePolicy;
import org.apereo.cas.services.util.RegisteredServiceJsonSerializer;
import org.apereo.cas.util.serialization.StringSerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

@Tag(value="RegisteredService")
@SpringBootTest(classes={RefreshAutoConfiguration.class, WebMvcAutoConfiguration.class}, properties={"cas.service-registry.templates.directory.location=classpath:/service-templates"})
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
class DefaultRegisteredServicesTemplatesManagerTests {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    private ConfigurableApplicationContext applicationContext;

    DefaultRegisteredServicesTemplatesManagerTests() {
    }

    private RegisteredServicesTemplatesManager getTemplatesManagerInstanceFrom(CasConfigurationProperties casProperties) {
        return new DefaultRegisteredServicesTemplatesManager(casProperties.getServiceRegistry(), (StringSerializer)new RegisteredServiceJsonSerializer(this.applicationContext));
    }

    @Test
    void verifyNoTemplateLocation() throws Throwable {
        CasRegisteredService registeredService = new CasRegisteredService();
        registeredService.setId(1000L);
        registeredService.setName("Unknown");
        registeredService.setTemplateName("Unknown");
        registeredService.setServiceId("https://app.example.org");
        CasConfigurationProperties properties = new CasConfigurationProperties();
        properties.getServiceRegistry().getTemplates().getDirectory().setLocation((Resource)new ClassPathResource("unknown"));
        RegisteredServicesTemplatesManager manager = this.getTemplatesManagerInstanceFrom(properties);
        RegisteredService result = manager.apply((RegisteredService)registeredService);
        Assertions.assertEquals((long)result.getId(), (long)registeredService.getId());
        Assertions.assertNull((Object)result.getDescription());
        ReturnAllowedAttributeReleasePolicy releasePolicy = (ReturnAllowedAttributeReleasePolicy)result.getAttributeReleasePolicy();
        Assertions.assertTrue((boolean)releasePolicy.getAllowedAttributes().isEmpty());
    }

    @Test
    void verifyNoTemplateName() throws Throwable {
        CasRegisteredService registeredService = new CasRegisteredService();
        registeredService.setId(1000L);
        registeredService.setName("Unknown");
        registeredService.setServiceId("https://app.example.org");
        RegisteredServicesTemplatesManager manager = this.getTemplatesManagerInstanceFrom(this.casProperties);
        RegisteredService result = manager.apply((RegisteredService)registeredService);
        Assertions.assertEquals((long)result.getId(), (long)registeredService.getId());
        ReturnAllowedAttributeReleasePolicy releasePolicy = (ReturnAllowedAttributeReleasePolicy)result.getAttributeReleasePolicy();
        Assertions.assertTrue((boolean)releasePolicy.getAllowedAttributes().isEmpty());
    }

    @Test
    void verifyOperation() throws Throwable {
        CasRegisteredService registeredService = new CasRegisteredService();
        registeredService.setName("CAS");
        registeredService.setTemplateName("ExampleTemplate");
        registeredService.setId(1000L);
        registeredService.setDescription("CAS service definition for example application");
        registeredService.setServiceId("https://app.example.org");
        registeredService.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)new PrincipalAttributeRegisteredServiceUsernameProvider("uid"));
        RegisteredServicesTemplatesManager manager = this.getTemplatesManagerInstanceFrom(this.casProperties);
        RegisteredService result = manager.apply((RegisteredService)registeredService);
        Assertions.assertEquals((Object)result.getName(), (Object)registeredService.getName());
        Assertions.assertEquals((long)result.getId(), (long)registeredService.getId());
        Assertions.assertEquals((Object)result.getDescription(), (Object)registeredService.getDescription());
        Assertions.assertEquals((Object)result.getServiceId(), (Object)registeredService.getServiceId());
        Assertions.assertEquals((Object)result.getUsernameAttributeProvider(), (Object)registeredService.getUsernameAttributeProvider());
        ReturnAllowedAttributeReleasePolicy releasePolicy = (ReturnAllowedAttributeReleasePolicy)result.getAttributeReleasePolicy();
        Assertions.assertEquals(List.of("email", "username"), (Object)releasePolicy.getAllowedAttributes());
        Assertions.assertEquals(Set.of("email", "username"), (Object)releasePolicy.getConsentPolicy().getIncludeOnlyAttributes());
    }

    @Test
    void verifyTemplateInheritance() throws Throwable {
        CasRegisteredService registeredService = new CasRegisteredService();
        registeredService.setName("CAS");
        registeredService.setTemplateName("Unknown,UsernameProviderTemplate,AttributeReleaseTemplate");
        registeredService.setId(1000L);
        RegisteredServicesTemplatesManager manager = this.getTemplatesManagerInstanceFrom(this.casProperties);
        RegisteredService result = manager.apply((RegisteredService)registeredService);
        Assertions.assertEquals((Object)result.getName(), (Object)registeredService.getName());
        Assertions.assertEquals((long)result.getId(), (long)registeredService.getId());
        PrincipalAttributeRegisteredServiceUsernameProvider uidProvider = (PrincipalAttributeRegisteredServiceUsernameProvider)result.getUsernameAttributeProvider();
        Assertions.assertEquals((Object)"email", (Object)uidProvider.getUsernameAttribute());
        ReturnAllowedAttributeReleasePolicy releasePolicy = (ReturnAllowedAttributeReleasePolicy)result.getAttributeReleasePolicy();
        Assertions.assertEquals(List.of("email", "username"), (Object)releasePolicy.getAllowedAttributes());
    }

    @Test
    void verifyGroovyTemplates() throws Throwable {
        CasRegisteredService registeredService = new CasRegisteredService();
        registeredService.setName("CAS");
        registeredService.setTemplateName("GroovyTemplate");
        registeredService.setId(1000L);
        registeredService.getProperties().put("GivenDescription", new DefaultRegisteredServiceProperty(new String[]{"This is my description"}));
        registeredService.getProperties().put("GivenUsernameAttribute", new DefaultRegisteredServiceProperty(new String[]{"email"}));
        registeredService.getProperties().put("AllowedAttributes", new DefaultRegisteredServiceProperty(new String[]{"email", "username"}));
        RegisteredServicesTemplatesManager manager = this.getTemplatesManagerInstanceFrom(this.casProperties);
        RegisteredService result = manager.apply((RegisteredService)registeredService);
        Assertions.assertEquals((Object)result.getName(), (Object)registeredService.getName());
        Assertions.assertEquals((long)result.getId(), (long)registeredService.getId());
        PrincipalAttributeRegisteredServiceUsernameProvider uidProvider = (PrincipalAttributeRegisteredServiceUsernameProvider)result.getUsernameAttributeProvider();
        Assertions.assertEquals((Object)"email", (Object)uidProvider.getUsernameAttribute());
        ReturnAllowedAttributeReleasePolicy releasePolicy = (ReturnAllowedAttributeReleasePolicy)result.getAttributeReleasePolicy();
        Assertions.assertEquals(List.of("email", "username"), (Object)releasePolicy.getAllowedAttributes());
    }
}

