/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.List;
import org.apereo.cas.services.AbstractServicesManagerTests;
import org.apereo.cas.services.CasRegisteredService;
import org.apereo.cas.services.DefaultServicesManagerRegisteredServiceLocator;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServicesTemplatesManager;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.ServicesManagerConfigurationContext;
import org.apereo.cas.services.mgmt.DefaultServicesManager;
import org.apereo.cas.util.CollectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.StaticApplicationContext;

@Tag(value="RegisteredService")
class DefaultServicesManagerByEnvironmentTests
extends AbstractServicesManagerTests<DefaultServicesManager> {
    DefaultServicesManagerByEnvironmentTests() {
    }

    @Test
    void verifyServiceByEnvironment() throws Throwable {
        CasRegisteredService r = new CasRegisteredService();
        r.setId(2000L);
        r.setName(this.getClass().getSimpleName());
        r.setServiceId(this.getClass().getSimpleName());
        r.setEnvironments(CollectionUtils.wrapHashSet((Object[])new String[]{"dev1"}));
        this.servicesManager.save((RegisteredService)r);
        Assertions.assertNull((Object)this.servicesManager.findServiceBy(this.serviceFactory.createService(this.getClass().getSimpleName())));
        Assertions.assertNull((Object)this.servicesManager.findServiceBy(2000L));
        r.setEnvironments(CollectionUtils.wrapHashSet((Object[])new String[]{"prod1"}));
        this.servicesManager.save((RegisteredService)r);
        Assertions.assertNotNull((Object)this.servicesManager.findServiceBy(2000L));
    }

    @Override
    protected ServicesManager getServicesManagerInstance() {
        StaticApplicationContext applicationContext = new StaticApplicationContext();
        applicationContext.refresh();
        ServicesManagerConfigurationContext context = ServicesManagerConfigurationContext.builder().serviceRegistry(this.serviceRegistry).applicationContext((ConfigurableApplicationContext)applicationContext).registeredServicesTemplatesManager((RegisteredServicesTemplatesManager)Mockito.mock(RegisteredServicesTemplatesManager.class)).environments(CollectionUtils.wrapSet((Object[])new String[]{"prod1", "qa1"})).servicesCache(Caffeine.newBuilder().build()).registeredServiceLocators(List.of(new DefaultServicesManagerRegisteredServiceLocator())).build();
        return new DefaultServicesManager(context);
    }
}

