/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apereo.cas.services.CasRegisteredService;
import org.apereo.cas.services.DefaultServicesManagerRegisteredServiceLocator;
import org.apereo.cas.services.InMemoryServiceRegistry;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.RegisteredServicesTemplatesManager;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.services.ServicesManagerConfigurationContext;
import org.apereo.cas.services.mgmt.DefaultServicesManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.StaticApplicationContext;

@Tag(value="RegisteredService")
class DefaultServicesManagerCachingTests {
    DefaultServicesManagerCachingTests() {
    }

    @Test
    void verifyServicesCache() throws Throwable {
        CasRegisteredService service1 = RegisteredServiceTestUtils.getRegisteredService(UUID.randomUUID().toString());
        StaticApplicationContext applicationContext = new StaticApplicationContext();
        applicationContext.refresh();
        Cache cache = Caffeine.newBuilder().initialCapacity(10).maximumSize(100L).expireAfterWrite(1L, TimeUnit.SECONDS).recordStats().build();
        ServicesManagerConfigurationContext context = ServicesManagerConfigurationContext.builder().applicationContext((ConfigurableApplicationContext)applicationContext).registeredServicesTemplatesManager((RegisteredServicesTemplatesManager)Mockito.mock(RegisteredServicesTemplatesManager.class)).serviceRegistry((ServiceRegistry)new InMemoryServiceRegistry((ConfigurableApplicationContext)applicationContext, List.of(service1), List.of())).registeredServiceLocators(List.of(new DefaultServicesManagerRegisteredServiceLocator())).servicesCache(cache).build();
        DefaultServicesManager mgr = new DefaultServicesManager(context);
        Assertions.assertFalse((boolean)mgr.getAllServices().isEmpty());
        Assertions.assertEquals((int)1, (int)mgr.load().size());
        Assertions.assertEquals((int)1, (int)mgr.getAllServices().size());
        Thread.sleep(1500L);
        Assertions.assertFalse((boolean)mgr.getAllServices().isEmpty());
        Assertions.assertEquals((int)1, (int)mgr.load().size());
        Assertions.assertEquals((int)1, (int)mgr.getAllServices().size());
    }
}

