/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.util.List;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.config.CasCoreNotificationsConfiguration;
import org.apereo.cas.config.CasCoreServicesConfiguration;
import org.apereo.cas.config.CasCoreUtilConfiguration;
import org.apereo.cas.config.CasCoreWebConfiguration;
import org.apereo.cas.config.CasWebApplicationServiceFactoryConfiguration;
import org.apereo.cas.services.CasRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.ServicesManagerRegisteredServiceLocator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;

@Tag(value="RegisteredService")
@SpringBootTest(classes={RefreshAutoConfiguration.class, WebMvcAutoConfiguration.class, CasCoreNotificationsConfiguration.class, CasCoreWebConfiguration.class, CasWebApplicationServiceFactoryConfiguration.class, CasCoreUtilConfiguration.class, CasCoreServicesConfiguration.class})
class DefaultServicesManagerRegisteredServiceLocatorTests {
    @Autowired
    @Qualifier(value="defaultServicesManagerRegisteredServiceLocator")
    private ServicesManagerRegisteredServiceLocator defaultServicesManagerRegisteredServiceLocator;
    @Autowired
    @Qualifier(value="webApplicationServiceFactory")
    private ServiceFactory<WebApplicationService> webApplicationServiceFactory;

    DefaultServicesManagerRegisteredServiceLocatorTests() {
    }

    @Test
    void verifyDefaultOperation() throws Throwable {
        ServicesManagerRegisteredServiceLocator input = (ServicesManagerRegisteredServiceLocator)Mockito.mock(ServicesManagerRegisteredServiceLocator.class);
        Mockito.when((Object)input.getOrder()).thenCallRealMethod();
        Mockito.when((Object)input.getRegisteredServiceIndexes()).thenCallRealMethod();
        Mockito.when((Object)input.getName()).thenCallRealMethod();
        Assertions.assertEquals((int)-1000, (int)input.getOrder());
        Assertions.assertNotNull((Object)input.getName());
        Assertions.assertTrue((boolean)input.getRegisteredServiceIndexes().isEmpty());
    }

    @Test
    void verifyOperation() throws Throwable {
        Assertions.assertNotNull((Object)this.defaultServicesManagerRegisteredServiceLocator);
        Assertions.assertEquals((int)-1000, (int)this.defaultServicesManagerRegisteredServiceLocator.getOrder());
        CasRegisteredService service = RegisteredServiceTestUtils.getRegisteredService("https://example.org.+");
        RegisteredService result = this.defaultServicesManagerRegisteredServiceLocator.locate(List.of(service), this.webApplicationServiceFactory.createService("https://example.org/test"));
        Assertions.assertNotNull((Object)result);
        Assertions.assertFalse((boolean)this.defaultServicesManagerRegisteredServiceLocator.getRegisteredServiceIndexes().isEmpty());
    }

    @Test
    void verifyExtendedServices() throws Throwable {
        ExtendedRegisteredService service = new ExtendedRegisteredService();
        service.setServiceId("https://\\w+.org.+");
        service.setId(100L);
        RegisteredService result = this.defaultServicesManagerRegisteredServiceLocator.locate(List.of(service), this.webApplicationServiceFactory.createService("https://example.org/test"));
        Assertions.assertNotNull((Object)result);
    }

    @Test
    void verifyUnmatchedExtendedServices() throws Throwable {
        ExtendedRegisteredService service = new ExtendedRegisteredService(){
            private static final long serialVersionUID = 3435937253967470900L;

            public String getFriendlyName() {
                return "OtherService";
            }
        };
        service.setServiceId("https://\\w+.org.+");
        service.setId(100L);
        RegisteredService result = this.defaultServicesManagerRegisteredServiceLocator.locate(List.of(service), this.webApplicationServiceFactory.createService("https://example.org/test"));
        Assertions.assertNull((Object)result);
    }

    private static class ExtendedRegisteredService
    extends CasRegisteredService {
        private static final long serialVersionUID = 1820837947166559349L;

        private ExtendedRegisteredService() {
        }
    }
}

