/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.util.UUID;
import org.apereo.cas.services.AbstractServicesManagerTests;
import org.apereo.cas.services.CasRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.mgmt.DefaultServicesManager;
import org.apereo.cas.services.query.RegisteredServiceQuery;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="RegisteredService")
class DefaultServicesManagerTests
extends AbstractServicesManagerTests<DefaultServicesManager> {
    private static final String TEST = "test";

    DefaultServicesManagerTests() {
    }

    @Test
    void verifyFindByQuery() throws Throwable {
        CasRegisteredService service = new CasRegisteredService();
        service.setId(1984L);
        service.setName("test1984");
        service.setServiceId(service.getName());
        this.servicesManager.save((RegisteredService)service);
        Assertions.assertEquals((long)0L, (long)this.servicesManager.findServicesBy(new RegisteredServiceQuery[0]).count());
        Assertions.assertEquals((long)1L, (long)this.servicesManager.findServicesBy(new RegisteredServiceQuery[]{RegisteredServiceQuery.of(CasRegisteredService.class, (String)"id", (Object)service.getId())}).count());
        Assertions.assertEquals((long)1L, (long)this.servicesManager.findServicesBy(new RegisteredServiceQuery[]{RegisteredServiceQuery.of(CasRegisteredService.class, (String)"id", (Object)service.getId()), RegisteredServiceQuery.of(CasRegisteredService.class, (String)"name", (Object)service.getName())}).count());
    }

    @Test
    void verifyFindByName() throws Throwable {
        CasRegisteredService service = new CasRegisteredService();
        service.setId(6100L);
        service.setName(TEST);
        service.setServiceId(TEST);
        Assertions.assertNull((Object)this.servicesManager.findServiceByName(null));
        this.serviceRegistry.save((RegisteredService)service);
        Assertions.assertNotNull((Object)this.servicesManager.findServiceByName(service.getName()));
        Assertions.assertNotEquals((long)0L, (long)this.servicesManager.stream().count());
        Assertions.assertEquals((long)1L, (long)this.servicesManager.getDomains().count());
        Assertions.assertFalse((boolean)this.servicesManager.getServicesForDomain(UUID.randomUUID().toString()).isEmpty());
    }

    @Test
    void verifyFindByNameAndType() throws Throwable {
        CasRegisteredService service = new CasRegisteredService();
        service.setId(6200L);
        service.setName(TEST);
        service.setServiceId(TEST);
        this.serviceRegistry.save((RegisteredService)service);
        Assertions.assertNotNull((Object)this.servicesManager.findServiceByName(service.getName(), CasRegisteredService.class));
        Assertions.assertNotEquals((long)0L, (long)this.servicesManager.stream().count());
    }

    @Test
    void verifySaveAndRemoveFromCache() throws InterruptedException {
        CasRegisteredService service = new CasRegisteredService();
        service.setId(4000L);
        service.setName(TEST);
        service.setServiceId(TEST);
        Assertions.assertFalse((boolean)this.isServiceInCache(null, service.getId()));
        this.servicesManager.save((RegisteredService)service);
        Assertions.assertTrue((boolean)this.isServiceInCache(null, service.getId()));
        Thread.sleep(1000L);
        Assertions.assertTrue((boolean)this.isServiceInCache(null, service.getId()));
        Thread.sleep(5000L);
        Assertions.assertTrue((boolean)this.isServiceInCache(null, service.getId()));
    }

    @Test
    void verifyEmptyCacheFirst() throws Throwable {
        CasRegisteredService service = new CasRegisteredService();
        service.setId(5000L);
        service.setName(TEST);
        service.setServiceId(TEST);
        Assertions.assertFalse((boolean)this.isServiceInCache(null, service.getId()));
        this.servicesManager.save((RegisteredService)service);
        Assertions.assertTrue((boolean)this.isServiceInCache(null, service.getId()));
        this.servicesManager.load();
        Assertions.assertTrue((boolean)this.isServiceInCache(null, service.getId()));
    }
}

