/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.util.Optional;
import java.util.Set;
import org.apereo.cas.authentication.AcceptUsersAuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationTransaction;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.handler.GroovyAuthenticationHandlerResolver;
import org.apereo.cas.services.ServicesManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

@Tag(value="GroovyAuthentication")
class GroovyAuthenticationHandlerResolverTests {
    GroovyAuthenticationHandlerResolverTests() {
    }

    @Test
    void verifyAction() throws Throwable {
        GroovyAuthenticationHandlerResolver resolver = new GroovyAuthenticationHandlerResolver((Resource)new ClassPathResource("GroovyAuthenticationHandlerResolver.groovy"), (ServicesManager)Mockito.mock(ServicesManager.class));
        AuthenticationTransaction transaction = (AuthenticationTransaction)Mockito.mock(AuthenticationTransaction.class);
        UsernamePasswordCredential creds = CoreAuthenticationTestUtils.getCredentialsWithSameUsernameAndPassword();
        Mockito.when((Object)transaction.getPrimaryCredential()).thenReturn(Optional.of(creds));
        Assertions.assertTrue((boolean)resolver.supports(Set.of(new AcceptUsersAuthenticationHandler("casuser")), transaction));
        Set results = resolver.resolve(Set.of(new AcceptUsersAuthenticationHandler("casuser")), transaction);
        Assertions.assertFalse((boolean)results.isEmpty());
        resolver.destroy();
    }
}

