/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.services.GroovyRegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyRequest;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="GroovyServices")
class GroovyRegisteredServiceAccessStrategyTests {
    private static final File JSON_FILE = new File(FileUtils.getTempDirectoryPath(), "GroovyRegisteredServiceAccessStrategyTests.json");
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();

    GroovyRegisteredServiceAccessStrategyTests() {
    }

    @Test
    void checkDefaultAuthzStrategyConfig() throws Throwable {
        GroovyRegisteredServiceAccessStrategy accessStrategy = new GroovyRegisteredServiceAccessStrategy();
        accessStrategy.setGroovyScript("classpath:GroovyServiceAccessStrategy.groovy");
        Assertions.assertTrue((boolean)accessStrategy.isServiceAccessAllowed((RegisteredService)RegisteredServiceTestUtils.getRegisteredService(), CoreAuthenticationTestUtils.getService()));
        Assertions.assertTrue((boolean)accessStrategy.isServiceAccessAllowedForSso((RegisteredService)RegisteredServiceTestUtils.getRegisteredService()));
        RegisteredServiceAccessStrategyRequest request = RegisteredServiceAccessStrategyRequest.builder().service(RegisteredServiceTestUtils.getService2()).principalId(UUID.randomUUID().toString()).build();
        Assertions.assertTrue((boolean)accessStrategy.authorizeRequest(request));
        Assertions.assertNull((Object)accessStrategy.getUnauthorizedRedirectUrl());
        Assertions.assertNotNull((Object)accessStrategy.getDelegatedAuthenticationPolicy());
        Assertions.assertNotNull((Object)accessStrategy.getRequiredAttributes());
    }

    @Test
    void verifyFailingOps() throws Throwable {
        GroovyRegisteredServiceAccessStrategy accessStrategy = new GroovyRegisteredServiceAccessStrategy();
        accessStrategy.setGroovyScript("classpath:Unknown.groovy");
        Assertions.assertThrows(UnauthorizedServiceException.class, () -> accessStrategy.isServiceAccessAllowed(null, null));
        Assertions.assertThrows(UnauthorizedServiceException.class, () -> accessStrategy.isServiceAccessAllowedForSso(null));
        Assertions.assertThrows(UnauthorizedServiceException.class, () -> accessStrategy.authorizeRequest(null));
    }

    @Test
    void verifySerializationToJson() throws IOException {
        GroovyRegisteredServiceAccessStrategy accessStrategy = new GroovyRegisteredServiceAccessStrategy();
        accessStrategy.setGroovyScript("classpath:GroovyServiceAccessStrategy.groovy");
        MAPPER.writeValue(JSON_FILE, (Object)accessStrategy);
        GroovyRegisteredServiceAccessStrategy strategyRead = (GroovyRegisteredServiceAccessStrategy)MAPPER.readValue(JSON_FILE, GroovyRegisteredServiceAccessStrategy.class);
        Assertions.assertEquals((Object)accessStrategy, (Object)strategyRead);
    }
}

