/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.config.CasCoreUtilConfiguration;
import org.apereo.cas.services.GroovyRegisteredServiceUsernameProvider;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.RegisteredServiceUsernameProviderContext;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

@Tag(value="GroovyServices")
@SpringBootTest(classes={RefreshAutoConfiguration.class, WebMvcAutoConfiguration.class, CasCoreUtilConfiguration.class})
class GroovyRegisteredServiceUsernameProviderTests {
    private static final File JSON_FILE = new File(FileUtils.getTempDirectoryPath(), "GroovyRegisteredServiceUsernameProviderTests.json");
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();
    @Autowired
    private ConfigurableApplicationContext applicationContext;

    GroovyRegisteredServiceUsernameProviderTests() {
    }

    @Test
    void verifyUsernameProvider() throws Throwable {
        GroovyRegisteredServiceUsernameProvider provider = new GroovyRegisteredServiceUsernameProvider();
        provider.setGroovyScript("classpath:uid.groovy");
        RegisteredServiceUsernameProviderContext usernameContext = RegisteredServiceUsernameProviderContext.builder().registeredService((RegisteredService)RegisteredServiceTestUtils.getRegisteredService()).service((Service)RegisteredServiceTestUtils.getService()).principal(RegisteredServiceTestUtils.getPrincipal()).applicationContext((ApplicationContext)this.applicationContext).build();
        String id = provider.resolveUsername(usernameContext);
        Assertions.assertEquals((Object)"fromscript", (Object)id);
    }

    @Test
    void verifyUsernameProviderInline() throws Throwable {
        GroovyRegisteredServiceUsernameProvider provider = new GroovyRegisteredServiceUsernameProvider();
        provider.setGroovyScript("groovy { return attributes['uid'] + '123456789' }");
        RegisteredServiceUsernameProviderContext usernameContext = RegisteredServiceUsernameProviderContext.builder().registeredService((RegisteredService)RegisteredServiceTestUtils.getRegisteredService()).service((Service)RegisteredServiceTestUtils.getService()).applicationContext((ApplicationContext)this.applicationContext).principal(RegisteredServiceTestUtils.getPrincipal("casuser", CollectionUtils.wrap((String)"uid", (Object)"CAS-System"))).build();
        String id = provider.resolveUsername(usernameContext);
        Assertions.assertEquals((Object)"CAS-System123456789", (Object)id);
    }

    @Test
    void verifyUsernameProviderInlineAsList() throws Throwable {
        GroovyRegisteredServiceUsernameProvider provider = new GroovyRegisteredServiceUsernameProvider();
        provider.setGroovyScript("groovy { return attributes['uid'][0] + '123456789' }");
        RegisteredServiceUsernameProviderContext usernameContext = RegisteredServiceUsernameProviderContext.builder().registeredService((RegisteredService)RegisteredServiceTestUtils.getRegisteredService()).service((Service)RegisteredServiceTestUtils.getService()).applicationContext((ApplicationContext)this.applicationContext).principal(RegisteredServiceTestUtils.getPrincipal("casuser", CollectionUtils.wrap((String)"uid", List.of("CAS-System")))).build();
        String id = provider.resolveUsername(usernameContext);
        Assertions.assertEquals((Object)"CAS-System123456789", (Object)id);
    }

    @Test
    void verifySerializationToJson() throws IOException {
        GroovyRegisteredServiceUsernameProvider provider = new GroovyRegisteredServiceUsernameProvider();
        provider.setGroovyScript("groovy { return 'something' }");
        provider.setEncryptUsername(true);
        provider.setCanonicalizationMode("NONE");
        MAPPER.writeValue(JSON_FILE, (Object)provider);
        GroovyRegisteredServiceUsernameProvider repositoryRead = (GroovyRegisteredServiceUsernameProvider)MAPPER.readValue(JSON_FILE, GroovyRegisteredServiceUsernameProvider.class);
        Assertions.assertEquals((Object)provider, (Object)repositoryRead);
    }

    @Test
    void verifyUsernameProviderInlineWithoutAttribute() throws Throwable {
        GroovyRegisteredServiceUsernameProvider provider = new GroovyRegisteredServiceUsernameProvider();
        provider.setGroovyScript("groovy { return attributes['unknown-attribute'][0] + '123456789' }");
        RegisteredServiceUsernameProviderContext usernameContext = RegisteredServiceUsernameProviderContext.builder().registeredService((RegisteredService)RegisteredServiceTestUtils.getRegisteredService()).service((Service)RegisteredServiceTestUtils.getService()).applicationContext((ApplicationContext)this.applicationContext).principal(RegisteredServiceTestUtils.getPrincipal("casuser")).build();
        String id = provider.resolveUsername(usernameContext);
        Assertions.assertEquals((Object)"casuser", (Object)id);
    }
}

