/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.services.HttpRequestRegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.mock.web.MockHttpServletRequest;

@Tag(value="RegisteredService")
class HttpRequestRegisteredServiceAccessStrategyTests {
    private static final File JSON_FILE = new File(FileUtils.getTempDirectoryPath(), "HttpRequestRegisteredServiceAccessStrategy.json");
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();

    HttpRequestRegisteredServiceAccessStrategyTests() {
    }

    @BeforeEach
    public void setup() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRemoteAddr("192.861.151.163");
        request.addHeader("user-agent", (Object)"Chrome/Mozilla");
        request.addHeader("CustomHeader", (Object)"abcd-12-xyz#");
        ClientInfoHolder.setClientInfo((ClientInfo)ClientInfo.from((HttpServletRequest)request));
    }

    @Test
    void verifySerialization() throws IOException {
        HttpRequestRegisteredServiceAccessStrategy strategyWritten = new HttpRequestRegisteredServiceAccessStrategy();
        strategyWritten.setIpAddress("129.+.123.\\d\\d");
        strategyWritten.setUserAgent("Google Chrome (Firefox)");
        strategyWritten.setHeaders(CollectionUtils.wrap((String)"Header1", (Object)"Value.+Pattern"));
        MAPPER.writeValue(JSON_FILE, (Object)strategyWritten);
        RegisteredServiceAccessStrategy read = (RegisteredServiceAccessStrategy)MAPPER.readValue(JSON_FILE, RegisteredServiceAccessStrategy.class);
        Assertions.assertEquals((Object)strategyWritten, (Object)read);
        Assertions.assertNotNull((Object)read.toString());
    }

    @Test
    void verifyAccessByIp() throws Throwable {
        HttpRequestRegisteredServiceAccessStrategy policy = new HttpRequestRegisteredServiceAccessStrategy();
        policy.setIpAddress("192.\\d\\d\\d.\\d\\d\\d.163");
        Assertions.assertTrue((boolean)policy.isServiceAccessAllowed((RegisteredService)RegisteredServiceTestUtils.getRegisteredService(), CoreAuthenticationTestUtils.getService()));
    }

    @Test
    void verifyAccessByIpAndHeader() throws Throwable {
        HttpRequestRegisteredServiceAccessStrategy policy = new HttpRequestRegisteredServiceAccessStrategy();
        policy.setIpAddress("192.\\d\\d\\d.\\d\\d\\d.163");
        policy.setHeaders(Map.of("CustomHeader", "^abcd-\\d\\d-.+#"));
        Assertions.assertTrue((boolean)policy.isServiceAccessAllowed((RegisteredService)RegisteredServiceTestUtils.getRegisteredService(), CoreAuthenticationTestUtils.getService()));
    }

    @Test
    void verifyUserAgentAccess() throws Throwable {
        HttpRequestRegisteredServiceAccessStrategy policy = new HttpRequestRegisteredServiceAccessStrategy();
        policy.setUserAgent(".*moz.*");
        Assertions.assertTrue((boolean)policy.isServiceAccessAllowed((RegisteredService)RegisteredServiceTestUtils.getRegisteredService(), CoreAuthenticationTestUtils.getService()));
    }

    @Test
    void verifyMatchFailsByIp() throws Throwable {
        HttpRequestRegisteredServiceAccessStrategy policy = new HttpRequestRegisteredServiceAccessStrategy();
        policy.setIpAddress("123.456.789.111");
        Assertions.assertFalse((boolean)policy.isServiceAccessAllowed((RegisteredService)RegisteredServiceTestUtils.getRegisteredService(), CoreAuthenticationTestUtils.getService()));
    }

    @Test
    void verifyUndefinedValues() throws Throwable {
        HttpRequestRegisteredServiceAccessStrategy policy = new HttpRequestRegisteredServiceAccessStrategy();
        Assertions.assertTrue((boolean)policy.isServiceAccessAllowed((RegisteredService)RegisteredServiceTestUtils.getRegisteredService(), CoreAuthenticationTestUtils.getService()));
    }

    @Test
    void verifyAllFieldsPresent() throws Throwable {
        HttpRequestRegisteredServiceAccessStrategy policy = new HttpRequestRegisteredServiceAccessStrategy();
        policy.setUserAgent(".*moz.*");
        policy.setIpAddress(".*861.*");
        Assertions.assertTrue((boolean)policy.isServiceAccessAllowed((RegisteredService)RegisteredServiceTestUtils.getRegisteredService(), CoreAuthenticationTestUtils.getService()));
    }
}

