/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.util.UUID;
import org.apereo.cas.services.AbstractServiceRegistryTests;
import org.apereo.cas.services.CasRegisteredService;
import org.apereo.cas.services.InMemoryServiceRegistry;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.ServiceRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.StaticApplicationContext;

@Tag(value="RegisteredService")
@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
class InMemoryServiceRegistryTests
extends AbstractServiceRegistryTests {
    InMemoryServiceRegistryTests() {
    }

    @Override
    public ServiceRegistry getNewServiceRegistry() {
        StaticApplicationContext appCtx = new StaticApplicationContext();
        appCtx.refresh();
        return new InMemoryServiceRegistry((ConfigurableApplicationContext)appCtx);
    }

    @Test
    void removeNonExistingService() {
        CasRegisteredService registeredService = RegisteredServiceTestUtils.getRegisteredService(UUID.randomUUID().toString());
        Assertions.assertTrue((boolean)this.getNewServiceRegistry().delete((RegisteredService)registeredService));
    }
}

