/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.OpenFGARegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredServiceAccessStrategyRequest;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.MockWebServer;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

@Tag(value="RegisteredService")
class OpenFGARegisteredServiceAccessStrategyTests {
    private static final File JSON_FILE = new File(FileUtils.getTempDirectoryPath(), "OpenFGARegisteredServiceAccessStrategy.json");
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();

    OpenFGARegisteredServiceAccessStrategyTests() {
    }

    @Test
    void verifySerializeToJson() throws IOException {
        OpenFGARegisteredServiceAccessStrategy strategyWritten = new OpenFGARegisteredServiceAccessStrategy();
        strategyWritten.setApiUrl("https://localhost:8080");
        strategyWritten.setRelation("owner");
        strategyWritten.setObject("my-document");
        strategyWritten.setToken(UUID.randomUUID().toString());
        MAPPER.writeValue(JSON_FILE, (Object)strategyWritten);
        OpenFGARegisteredServiceAccessStrategy read = (OpenFGARegisteredServiceAccessStrategy)MAPPER.readValue(JSON_FILE, OpenFGARegisteredServiceAccessStrategy.class);
        Assertions.assertEquals((Object)strategyWritten, (Object)read);
    }

    @Test
    void verifyOperation() throws Throwable {
        ObjectMapper mapper = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();
        OpenFGARegisteredServiceAccessStrategy strategy = new OpenFGARegisteredServiceAccessStrategy();
        strategy.setApiUrl("http://localhost:8755");
        strategy.setRelation("reader");
        strategy.setStoreId("01GFTZWEZZMAM0NHQQZWE6AN3H");
        strategy.setToken(UUID.randomUUID().toString());
        strategy.setObject("document:Z");
        RegisteredServiceAccessStrategyRequest request = RegisteredServiceAccessStrategyRequest.builder().service((Service)RegisteredServiceTestUtils.getService()).principalId("casuser").build();
        Assertions.assertFalse((boolean)strategy.authorizeRequest(request));
        String data = mapper.writeValueAsString((Object)CollectionUtils.wrap((String)"allowed", (Object)true));
        try (MockWebServer webServer = new MockWebServer(8755, (Resource)new ByteArrayResource(data.getBytes(StandardCharsets.UTF_8), "REST Output"), "application/json");){
            webServer.start();
            Assertions.assertTrue((boolean)strategy.authorizeRequest(request));
        }
    }
}

