/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.OpenPolicyAgentRegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredServiceAccessStrategyRequest;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.MockWebServer;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

@Tag(value="RegisteredService")
class OpenPolicyAgentRegisteredServiceAccessStrategyTests {
    private static final File JSON_FILE = new File(FileUtils.getTempDirectoryPath(), "OpenPolicyAgentRegisteredServiceAccessStrategy.json");
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();

    OpenPolicyAgentRegisteredServiceAccessStrategyTests() {
    }

    @Test
    void verifySerializeToJson() throws IOException {
        OpenPolicyAgentRegisteredServiceAccessStrategy strategyWritten = new OpenPolicyAgentRegisteredServiceAccessStrategy();
        strategyWritten.setApiUrl("https://localhost:8080");
        strategyWritten.setDecision("example/authz/allow");
        strategyWritten.setToken(UUID.randomUUID().toString());
        MAPPER.writeValue(JSON_FILE, (Object)strategyWritten);
        OpenPolicyAgentRegisteredServiceAccessStrategy read = (OpenPolicyAgentRegisteredServiceAccessStrategy)MAPPER.readValue(JSON_FILE, OpenPolicyAgentRegisteredServiceAccessStrategy.class);
        Assertions.assertEquals((Object)strategyWritten, (Object)read);
    }

    @Test
    void verifyOperation() throws Throwable {
        OpenPolicyAgentRegisteredServiceAccessStrategy strategy = new OpenPolicyAgentRegisteredServiceAccessStrategy();
        strategy.setApiUrl("http://localhost:8755");
        strategy.setDecision("example/authz/allow");
        strategy.setToken(UUID.randomUUID().toString());
        strategy.setContext(Map.of("Param1", List.of("Value1")));
        HashMap<String, List<Object>> principalAttributes = new HashMap<String, List<Object>>();
        principalAttributes.put("email", List.of("user@example.org"));
        Principal principal = RegisteredServiceTestUtils.getPrincipal("person", principalAttributes);
        RegisteredServiceAccessStrategyRequest request = RegisteredServiceAccessStrategyRequest.builder().service((Service)RegisteredServiceTestUtils.getService()).principalId(principal.getId()).attributes(principal.getAttributes()).build();
        Assertions.assertFalse((boolean)strategy.authorizeRequest(request));
        ObjectMapper mapper = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();
        String data = mapper.writeValueAsString((Object)CollectionUtils.wrap((String)"result", (Object)true));
        try (MockWebServer webServer = new MockWebServer(8755, (Resource)new ByteArrayResource(data.getBytes(StandardCharsets.UTF_8), "REST Output"), "application/json");){
            webServer.start();
            Assertions.assertTrue((boolean)strategy.authorizeRequest(request));
        }
    }
}

