/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.services.CasRegisteredService;
import org.apereo.cas.services.PartialRegexRegisteredServiceMatchingStrategy;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceMatchingStrategy;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="RegisteredService")
class PartialRegexRegisteredServiceMatchingStrategyTests {
    private static final File JSON_FILE = new File(FileUtils.getTempDirectoryPath(), "PartialRegexRegisteredServiceMatchingStrategyTests.json");
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();

    PartialRegexRegisteredServiceMatchingStrategyTests() {
    }

    @Test
    void verifySerialization() throws Throwable {
        CasRegisteredService service = RegisteredServiceTestUtils.getRegisteredService(UUID.randomUUID().toString());
        PartialRegexRegisteredServiceMatchingStrategy strategy = new PartialRegexRegisteredServiceMatchingStrategy();
        service.setMatchingStrategy((RegisteredServiceMatchingStrategy)strategy);
        MAPPER.writeValue(JSON_FILE, (Object)service);
        RegisteredService read = (RegisteredService)MAPPER.readValue(JSON_FILE, RegisteredService.class);
        Assertions.assertEquals((Object)read, (Object)service);
    }

    @Test
    void verifyPattern1() throws Throwable {
        CasRegisteredService service = RegisteredServiceTestUtils.getRegisteredService("https://.*");
        PartialRegexRegisteredServiceMatchingStrategy strategy = new PartialRegexRegisteredServiceMatchingStrategy();
        Assertions.assertTrue((boolean)strategy.matches((RegisteredService)service, "https://google.com"));
        Assertions.assertTrue((boolean)strategy.matches((RegisteredService)service, "^https://"));
    }

    @Test
    void verifyPattern2() throws Throwable {
        CasRegisteredService service = RegisteredServiceTestUtils.getRegisteredService("\\d\\d\\d");
        PartialRegexRegisteredServiceMatchingStrategy strategy = new PartialRegexRegisteredServiceMatchingStrategy();
        Assertions.assertTrue((boolean)strategy.matches((RegisteredService)service, "https://google123.com"));
        Assertions.assertTrue((boolean)strategy.matches((RegisteredService)service, "https://google.com?param1=value123here"));
    }
}

