/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.config.CasCoreUtilConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.BaseMappedAttributeReleasePolicy;
import org.apereo.cas.services.BaseWebBasedRegisteredService;
import org.apereo.cas.services.CasRegisteredService;
import org.apereo.cas.services.DefaultRegisteredServiceAccessStrategy;
import org.apereo.cas.services.PrincipalAttributeRegisteredServiceUsernameProvider;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.RegisteredServiceUsernameProviderContext;
import org.apereo.cas.services.ReturnMappedAttributeReleasePolicy;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

@Tag(value="RegisteredService")
@SpringBootTest(classes={CasCoreUtilConfiguration.class, RefreshAutoConfiguration.class})
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
class PrincipalAttributeRegisteredServiceUsernameProviderTests {
    private static final File JSON_FILE = new File(FileUtils.getTempDirectoryPath(), "principalAttributeRegisteredServiceUsernameProvider.json");
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();
    @Autowired
    private ConfigurableApplicationContext applicationContext;

    PrincipalAttributeRegisteredServiceUsernameProviderTests() {
    }

    @Test
    void verifyUsernameByPrincipalAttributeWithMapping() throws Throwable {
        PrincipalAttributeRegisteredServiceUsernameProvider provider = new PrincipalAttributeRegisteredServiceUsernameProvider("email");
        ArrayListMultimap allowedAttributes = ArrayListMultimap.create();
        String mappedAttribute = "urn:oid:0.9.2342.19200300.100.1.3";
        allowedAttributes.put((Object)"email", List.of("urn:oid:0.9.2342.19200300.100.1.3"));
        BaseMappedAttributeReleasePolicy policy = new ReturnMappedAttributeReleasePolicy().setAllowedAttributes(CollectionUtils.wrap((Multimap)allowedAttributes));
        BaseWebBasedRegisteredService registeredService = RegisteredServiceTestUtils.getRegisteredService();
        registeredService.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)policy);
        HashMap<String, List<Object>> principalAttributes = new HashMap<String, List<Object>>();
        principalAttributes.put("email", List.of("user@example.org"));
        Principal p = RegisteredServiceTestUtils.getPrincipal("person", principalAttributes);
        RegisteredServiceUsernameProviderContext usernameContext = RegisteredServiceUsernameProviderContext.builder().registeredService((RegisteredService)registeredService).service((Service)RegisteredServiceTestUtils.getService("verifyUsernameByPrincipalAttributeWithMapping")).principal(p).applicationContext((ApplicationContext)this.applicationContext).build();
        String id = provider.resolveUsername(usernameContext);
        Assertions.assertEquals((Object)"user@example.org", (Object)id);
    }

    @Test
    void verifyUsernameByPrincipalAttributeAsCollection() throws Throwable {
        PrincipalAttributeRegisteredServiceUsernameProvider provider = new PrincipalAttributeRegisteredServiceUsernameProvider("cn");
        HashMap<String, List<Object>> attrs = new HashMap<String, List<Object>>();
        attrs.put("userid", CollectionUtils.wrap((Object)"u1"));
        attrs.put("cn", CollectionUtils.wrap((Object)"TheName"));
        Principal p = RegisteredServiceTestUtils.getPrincipal("person", attrs);
        RegisteredServiceUsernameProviderContext usernameContext = RegisteredServiceUsernameProviderContext.builder().registeredService((RegisteredService)RegisteredServiceTestUtils.getRegisteredService("usernameAttributeProviderService")).service((Service)RegisteredServiceTestUtils.getService("usernameAttributeProviderService")).principal(p).applicationContext((ApplicationContext)this.applicationContext).build();
        String id = provider.resolveUsername(usernameContext);
        Assertions.assertEquals((Object)"TheName", (Object)id);
    }

    @Test
    void verifyUsernameByPrincipalAttribute() throws Throwable {
        PrincipalAttributeRegisteredServiceUsernameProvider provider = new PrincipalAttributeRegisteredServiceUsernameProvider("cn");
        HashMap<String, List<Object>> attrs = new HashMap<String, List<Object>>();
        attrs.put("userid", List.of("u1"));
        attrs.put("cn", List.of("TheName"));
        Principal principal = RegisteredServiceTestUtils.getPrincipal("person", attrs);
        RegisteredServiceUsernameProviderContext usernameContext = RegisteredServiceUsernameProviderContext.builder().registeredService((RegisteredService)RegisteredServiceTestUtils.getRegisteredService("usernameAttributeProviderService")).service((Service)RegisteredServiceTestUtils.getService("usernameAttributeProviderService")).principal(principal).applicationContext((ApplicationContext)this.applicationContext).build();
        String id = provider.resolveUsername(usernameContext);
        Assertions.assertEquals((Object)"TheName", (Object)id);
    }

    @Test
    void verifyNoAttrRelPolicy() throws Throwable {
        PrincipalAttributeRegisteredServiceUsernameProvider provider = new PrincipalAttributeRegisteredServiceUsernameProvider("cn");
        HashMap<String, List<Object>> attrs = new HashMap<String, List<Object>>();
        attrs.put("userid", List.of("u1"));
        attrs.put("cn", List.of("TheName"));
        Principal p = RegisteredServiceTestUtils.getPrincipal("person", attrs);
        CasRegisteredService service = RegisteredServiceTestUtils.getRegisteredService("usernameAttributeProviderService");
        service.setAttributeReleasePolicy(null);
        RegisteredServiceUsernameProviderContext usernameContext = RegisteredServiceUsernameProviderContext.builder().registeredService((RegisteredService)RegisteredServiceTestUtils.getRegisteredService("usernameAttributeProviderService")).service((Service)RegisteredServiceTestUtils.getService("usernameAttributeProviderService")).principal(p).applicationContext((ApplicationContext)this.applicationContext).build();
        String id = provider.resolveUsername(usernameContext);
        Assertions.assertEquals((Object)"TheName", (Object)id);
    }

    @Test
    void verifyDisabledService() throws Throwable {
        PrincipalAttributeRegisteredServiceUsernameProvider provider = new PrincipalAttributeRegisteredServiceUsernameProvider("cn");
        HashMap<String, List<Object>> attrs = new HashMap<String, List<Object>>();
        attrs.put("userid", List.of("u1"));
        attrs.put("cn", List.of("TheName"));
        Principal principal = RegisteredServiceTestUtils.getPrincipal("person", attrs);
        CasRegisteredService registeredService = RegisteredServiceTestUtils.getRegisteredService("usernameAttributeProviderService");
        registeredService.setAccessStrategy((RegisteredServiceAccessStrategy)new DefaultRegisteredServiceAccessStrategy(false, false));
        registeredService.setAttributeReleasePolicy(null);
        RegisteredServiceUsernameProviderContext usernameContext = RegisteredServiceUsernameProviderContext.builder().registeredService((RegisteredService)registeredService).service((Service)RegisteredServiceTestUtils.getService("usernameAttributeProviderService")).principal(principal).applicationContext((ApplicationContext)this.applicationContext).build();
        Assertions.assertThrows(UnauthorizedServiceException.class, () -> provider.resolveUsername(usernameContext));
    }

    @Test
    void verifyUsernameByPrincipalAttributeNotFound() throws Throwable {
        PrincipalAttributeRegisteredServiceUsernameProvider provider = new PrincipalAttributeRegisteredServiceUsernameProvider("cn");
        HashMap<String, List<Object>> attrs = new HashMap<String, List<Object>>();
        attrs.put("userid", List.of("u1"));
        Principal p = RegisteredServiceTestUtils.getPrincipal("person", attrs);
        RegisteredServiceUsernameProviderContext usernameContext = RegisteredServiceUsernameProviderContext.builder().registeredService((RegisteredService)RegisteredServiceTestUtils.getRegisteredService("usernameAttributeProviderService")).service((Service)RegisteredServiceTestUtils.getService("usernameAttributeProviderService")).principal(p).applicationContext((ApplicationContext)this.applicationContext).build();
        String id = provider.resolveUsername(usernameContext);
        Assertions.assertEquals((Object)id, (Object)p.getId());
    }

    @Test
    void verifyUsernameUndefined() throws Throwable {
        PrincipalAttributeRegisteredServiceUsernameProvider provider = new PrincipalAttributeRegisteredServiceUsernameProvider();
        Principal p = RegisteredServiceTestUtils.getPrincipal("person");
        RegisteredServiceUsernameProviderContext usernameContext = RegisteredServiceUsernameProviderContext.builder().registeredService((RegisteredService)RegisteredServiceTestUtils.getRegisteredService("usernameAttributeProviderService")).service((Service)RegisteredServiceTestUtils.getService("usernameAttributeProviderService")).principal(p).applicationContext((ApplicationContext)this.applicationContext).build();
        String id = provider.resolveUsername(usernameContext);
        Assertions.assertEquals((Object)id, (Object)p.getId());
    }

    @Test
    void verifyEquality() throws Throwable {
        PrincipalAttributeRegisteredServiceUsernameProvider provider = new PrincipalAttributeRegisteredServiceUsernameProvider("cn");
        PrincipalAttributeRegisteredServiceUsernameProvider provider2 = new PrincipalAttributeRegisteredServiceUsernameProvider("cn");
        Assertions.assertEquals((Object)provider, (Object)provider2);
    }

    @Test
    void verifySerializeAPrincipalAttributeRegisteredServiceUsernameProviderToJson() throws Throwable {
        PrincipalAttributeRegisteredServiceUsernameProvider providerWritten = new PrincipalAttributeRegisteredServiceUsernameProvider("cn");
        MAPPER.writeValue(JSON_FILE, (Object)providerWritten);
        PrincipalAttributeRegisteredServiceUsernameProvider providerRead = (PrincipalAttributeRegisteredServiceUsernameProvider)MAPPER.readValue(JSON_FILE, PrincipalAttributeRegisteredServiceUsernameProvider.class);
        Assertions.assertEquals((Object)providerWritten, (Object)providerRead);
    }
}

