/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.net.URI;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.services.CasRegisteredService;
import org.apereo.cas.services.RegexMatchingRegisteredServiceProxyPolicy;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="RegisteredService")
class RegexMatchingRegisteredServiceProxyPolicyTests {
    private static final File JSON_FILE = new File(FileUtils.getTempDirectoryPath(), "regexMatchingRegisteredServiceProxyPolicy.json");
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();

    RegexMatchingRegisteredServiceProxyPolicyTests() {
    }

    @Test
    void verifySerializeARegexMatchingRegisteredServiceProxyPolicyToJson() throws Throwable {
        RegexMatchingRegisteredServiceProxyPolicy policy = new RegexMatchingRegisteredServiceProxyPolicy();
        policy.setPattern("pattern");
        policy.setExactMatch(true);
        policy.setUseServiceId(true);
        MAPPER.writeValue(JSON_FILE, (Object)policy);
        RegexMatchingRegisteredServiceProxyPolicy policyRead = (RegexMatchingRegisteredServiceProxyPolicy)MAPPER.readValue(JSON_FILE, RegexMatchingRegisteredServiceProxyPolicy.class);
        Assertions.assertEquals((Object)policy, (Object)policyRead);
    }

    @Test
    void verifyBadPattern() throws Throwable {
        RegexMatchingRegisteredServiceProxyPolicy policy = new RegexMatchingRegisteredServiceProxyPolicy();
        policy.setPattern("***");
        Assertions.assertFalse((boolean)policy.isAllowedProxyCallbackUrl((RegisteredService)RegisteredServiceTestUtils.getRegisteredService(), new URI("https://github.com/apereo/cas").toURL()));
    }

    @Test
    void verifyExactMatch() throws Throwable {
        RegexMatchingRegisteredServiceProxyPolicy policy = new RegexMatchingRegisteredServiceProxyPolicy();
        policy.setPattern("https://github.com/apereo/cas");
        policy.setExactMatch(true);
        Assertions.assertTrue((boolean)policy.isAllowedProxyCallbackUrl((RegisteredService)RegisteredServiceTestUtils.getRegisteredService(), new URI("https://github.com/apereo/cas").toURL()));
    }

    @Test
    void verifyServiceIdPattern() throws Throwable {
        RegexMatchingRegisteredServiceProxyPolicy policy = new RegexMatchingRegisteredServiceProxyPolicy();
        policy.setUseServiceId(true);
        CasRegisteredService registeredService = RegisteredServiceTestUtils.getRegisteredService("^https:.+/apereo/cas");
        Assertions.assertTrue((boolean)policy.isAllowedProxyCallbackUrl((RegisteredService)registeredService, new URI("https://github.com/apereo/cas").toURL()));
    }
}

