/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.Map;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.PrincipalException;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.BaseWebBasedRegisteredService;
import org.apereo.cas.services.DefaultRegisteredServiceAccessStrategy;
import org.apereo.cas.services.DefaultRegisteredServiceExpirationPolicy;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.RegisteredServiceExpirationPolicy;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.services.UnauthorizedSsoServiceException;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.util.CollectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

@Tag(value="Utility")
class RegisteredServiceAccessStrategyUtilsTests {
    RegisteredServiceAccessStrategyUtilsTests() {
    }

    @Test
    void verifyExpired() throws Throwable {
        BaseWebBasedRegisteredService service = RegisteredServiceTestUtils.getRegisteredService();
        service.setExpirationPolicy((RegisteredServiceExpirationPolicy)new DefaultRegisteredServiceExpirationPolicy(false, LocalDate.now(ZoneOffset.UTC).minusDays(1L)));
        Assertions.assertThrows(UnauthorizedServiceException.class, () -> RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((Service)RegisteredServiceTestUtils.getService(), (RegisteredService)service));
    }

    @Test
    void verifySsoAccess() throws Throwable {
        BaseWebBasedRegisteredService service = RegisteredServiceTestUtils.getRegisteredService();
        service.setAccessStrategy((RegisteredServiceAccessStrategy)new DefaultRegisteredServiceAccessStrategy(true, false));
        TicketGrantingTicket tgt = (TicketGrantingTicket)Mockito.mock(TicketGrantingTicket.class);
        Mockito.when((Object)tgt.getAuthentication()).thenReturn((Object)RegisteredServiceTestUtils.getAuthentication());
        Mockito.when((Object)tgt.getProxiedBy()).thenReturn((Object)RegisteredServiceTestUtils.getService());
        Assertions.assertThrows(UnauthorizedSsoServiceException.class, () -> RegisteredServiceAccessStrategyUtils.ensureServiceSsoAccessIsAllowed((RegisteredService)service, (Service)RegisteredServiceTestUtils.getService(), (TicketGrantingTicket)tgt, (boolean)false));
    }

    @Test
    void verifyPrincipalAccess() throws Throwable {
        BaseWebBasedRegisteredService service = RegisteredServiceTestUtils.getRegisteredService();
        Authentication authentication = RegisteredServiceTestUtils.getAuthentication();
        Assertions.assertThrows(PrincipalException.class, () -> RegisteredServiceAccessStrategyUtils.ensurePrincipalAccessIsAllowedForService((Service)RegisteredServiceTestUtils.getService(), (RegisteredService)service, (String)authentication.getPrincipal().getId(), (Map)CollectionUtils.merge((Map[])new Map[]{authentication.getAttributes(), authentication.getPrincipal().getAttributes()})));
    }
}

