/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apereo.cas.authentication.AcceptUsersAuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategy;
import org.apereo.cas.authentication.AuthenticationTransaction;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.DefaultAuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.DefaultAuthenticationServiceSelectionStrategy;
import org.apereo.cas.authentication.handler.DefaultAuthenticationHandlerResolver;
import org.apereo.cas.authentication.handler.RegisteredServiceAuthenticationHandlerResolver;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.CasRegisteredService;
import org.apereo.cas.services.DefaultServicesManagerRegisteredServiceLocator;
import org.apereo.cas.services.InMemoryServiceRegistry;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.RegisteredServicesTemplatesManager;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.ServicesManagerConfigurationContext;
import org.apereo.cas.services.mgmt.DefaultServicesManager;
import org.apereo.cas.util.CollectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.StaticApplicationContext;

@Tag(value="RegisteredService")
class RegisteredServiceAuthenticationHandlerResolverTests {
    private ServicesManager defaultServicesManager;
    private Set<AuthenticationHandler> authenticationHandlers;

    RegisteredServiceAuthenticationHandlerResolverTests() {
    }

    @BeforeEach
    public void initialize() {
        ArrayList<CasRegisteredService> list = new ArrayList<CasRegisteredService>();
        CasRegisteredService svc = RegisteredServiceTestUtils.getRegisteredService("serviceid1");
        svc.getAuthenticationPolicy().getRequiredAuthenticationHandlers().addAll(CollectionUtils.wrapHashSet((Object[])new String[]{"handler1", "handler2"}));
        list.add(svc);
        CasRegisteredService svc2 = RegisteredServiceTestUtils.getRegisteredService("serviceid2");
        svc2.getAuthenticationPolicy().getRequiredAuthenticationHandlers().addAll(new HashSet(0));
        list.add(svc2);
        CasRegisteredService svc3 = RegisteredServiceTestUtils.getRegisteredService("serviceid3");
        svc3.getAuthenticationPolicy().getExcludedAuthenticationHandlers().addAll(Set.of("handler3", "handler1"));
        list.add(svc3);
        StaticApplicationContext appCtx = new StaticApplicationContext();
        appCtx.refresh();
        InMemoryServiceRegistry dao = new InMemoryServiceRegistry((ConfigurableApplicationContext)appCtx, list, new ArrayList());
        StaticApplicationContext applicationContext = new StaticApplicationContext();
        applicationContext.refresh();
        ServicesManagerConfigurationContext context = ServicesManagerConfigurationContext.builder().registeredServicesTemplatesManager((RegisteredServicesTemplatesManager)Mockito.mock(RegisteredServicesTemplatesManager.class)).serviceRegistry((ServiceRegistry)dao).applicationContext((ConfigurableApplicationContext)applicationContext).environments(new HashSet(0)).servicesCache(Caffeine.newBuilder().build()).registeredServiceLocators(List.of(new DefaultServicesManagerRegisteredServiceLocator())).build();
        this.defaultServicesManager = new DefaultServicesManager(context);
        this.defaultServicesManager.load();
        AcceptUsersAuthenticationHandler handler1 = new AcceptUsersAuthenticationHandler("handler1");
        AcceptUsersAuthenticationHandler handler2 = new AcceptUsersAuthenticationHandler("handler2");
        AcceptUsersAuthenticationHandler handler3 = new AcceptUsersAuthenticationHandler("handler3");
        this.authenticationHandlers = Stream.of(handler1, handler2, handler3).collect(Collectors.toSet());
    }

    @Test
    void checkAuthenticationHandlerResolutionDefault() throws Throwable {
        RegisteredServiceAuthenticationHandlerResolver resolver = new RegisteredServiceAuthenticationHandlerResolver(this.defaultServicesManager, (AuthenticationServiceSelectionPlan)new DefaultAuthenticationServiceSelectionPlan(new AuthenticationServiceSelectionStrategy[]{new DefaultAuthenticationServiceSelectionStrategy()}));
        AuthenticationTransaction transaction = CoreAuthenticationTestUtils.getAuthenticationTransactionFactory().newTransaction((Service)RegisteredServiceTestUtils.getService("serviceid1"), new Credential[]{RegisteredServiceTestUtils.getCredentialsWithSameUsernameAndPassword("casuser")});
        Set handlers = resolver.resolve(this.authenticationHandlers, transaction);
        Assertions.assertEquals((int)2, (int)handlers.size());
    }

    @Test
    void checkAuthenticationHandlerResolution() throws Throwable {
        DefaultAuthenticationHandlerResolver resolver = new DefaultAuthenticationHandlerResolver();
        AuthenticationTransaction transaction = CoreAuthenticationTestUtils.getAuthenticationTransactionFactory().newTransaction((Service)RegisteredServiceTestUtils.getService("serviceid2"), new Credential[]{RegisteredServiceTestUtils.getCredentialsWithSameUsernameAndPassword("casuser")});
        Set handlers = resolver.resolve(this.authenticationHandlers, transaction);
        Assertions.assertEquals((int)handlers.size(), (int)this.authenticationHandlers.size());
    }

    @Test
    void checkAuthenticationHandlerExcluded() throws Throwable {
        RegisteredServiceAuthenticationHandlerResolver resolver = new RegisteredServiceAuthenticationHandlerResolver(this.defaultServicesManager, (AuthenticationServiceSelectionPlan)new DefaultAuthenticationServiceSelectionPlan(new AuthenticationServiceSelectionStrategy[]{new DefaultAuthenticationServiceSelectionStrategy()}));
        AuthenticationTransaction transaction = CoreAuthenticationTestUtils.getAuthenticationTransactionFactory().newTransaction((Service)RegisteredServiceTestUtils.getService("serviceid3"), new Credential[]{RegisteredServiceTestUtils.getCredentialsWithSameUsernameAndPassword("casuser")});
        Set handlers = resolver.resolve(this.authenticationHandlers, transaction);
        Assertions.assertEquals((int)1, (int)handlers.size());
        Assertions.assertEquals((Object)"handler2", (Object)((AuthenticationHandler)handlers.iterator().next()).getName());
    }
}

