/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategy;
import org.apereo.cas.authentication.AuthenticationTransaction;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.DefaultAuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.DefaultAuthenticationServiceSelectionStrategy;
import org.apereo.cas.authentication.policy.AllAuthenticationHandlersSucceededAuthenticationPolicy;
import org.apereo.cas.authentication.policy.AtLeastOneCredentialValidatedAuthenticationPolicy;
import org.apereo.cas.authentication.policy.GroovyScriptAuthenticationPolicy;
import org.apereo.cas.authentication.policy.NotPreventedAuthenticationPolicy;
import org.apereo.cas.authentication.policy.RegisteredServiceAuthenticationPolicyResolver;
import org.apereo.cas.authentication.policy.RestfulAuthenticationPolicy;
import org.apereo.cas.authentication.principal.AbstractWebApplicationService;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.AllAuthenticationHandlersRegisteredServiceAuthenticationPolicyCriteria;
import org.apereo.cas.services.AnyAuthenticationHandlerRegisteredServiceAuthenticationPolicyCriteria;
import org.apereo.cas.services.CasRegisteredService;
import org.apereo.cas.services.DefaultRegisteredServiceAuthenticationPolicy;
import org.apereo.cas.services.DefaultServicesManagerRegisteredServiceLocator;
import org.apereo.cas.services.GroovyRegisteredServiceAuthenticationPolicyCriteria;
import org.apereo.cas.services.InMemoryServiceRegistry;
import org.apereo.cas.services.NotPreventedRegisteredServiceAuthenticationPolicyCriteria;
import org.apereo.cas.services.RegisteredServiceAuthenticationPolicy;
import org.apereo.cas.services.RegisteredServiceAuthenticationPolicyCriteria;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.RegisteredServicesTemplatesManager;
import org.apereo.cas.services.RestfulRegisteredServiceAuthenticationPolicyCriteria;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.ServicesManagerConfigurationContext;
import org.apereo.cas.services.UnauthorizedSsoServiceException;
import org.apereo.cas.services.mgmt.DefaultServicesManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.StaticApplicationContext;

@Tag(value="RegisteredService")
class RegisteredServiceAuthenticationPolicyResolverTests {
    private ServicesManager servicesManager;

    RegisteredServiceAuthenticationPolicyResolverTests() {
    }

    @BeforeEach
    public void initialize() {
        ArrayList<CasRegisteredService> list = new ArrayList<CasRegisteredService>();
        CasRegisteredService svc1 = RegisteredServiceTestUtils.getRegisteredService("serviceid1");
        DefaultRegisteredServiceAuthenticationPolicy p1 = new DefaultRegisteredServiceAuthenticationPolicy();
        AnyAuthenticationHandlerRegisteredServiceAuthenticationPolicyCriteria cr1 = new AnyAuthenticationHandlerRegisteredServiceAuthenticationPolicyCriteria();
        cr1.setTryAll(true);
        p1.setCriteria((RegisteredServiceAuthenticationPolicyCriteria)cr1);
        svc1.setAuthenticationPolicy((RegisteredServiceAuthenticationPolicy)p1);
        list.add(svc1);
        CasRegisteredService svc2 = RegisteredServiceTestUtils.getRegisteredService("serviceid2");
        svc2.setAuthenticationPolicy((RegisteredServiceAuthenticationPolicy)new DefaultRegisteredServiceAuthenticationPolicy());
        list.add(svc2);
        CasRegisteredService svc3 = RegisteredServiceTestUtils.getRegisteredService("serviceid3");
        DefaultRegisteredServiceAuthenticationPolicy p3 = new DefaultRegisteredServiceAuthenticationPolicy();
        AllAuthenticationHandlersRegisteredServiceAuthenticationPolicyCriteria cr3 = new AllAuthenticationHandlersRegisteredServiceAuthenticationPolicyCriteria();
        p3.setCriteria((RegisteredServiceAuthenticationPolicyCriteria)cr3);
        svc3.setAuthenticationPolicy((RegisteredServiceAuthenticationPolicy)p3);
        list.add(svc3);
        CasRegisteredService svc4 = RegisteredServiceTestUtils.getRegisteredService("serviceid4");
        DefaultRegisteredServiceAuthenticationPolicy p4 = new DefaultRegisteredServiceAuthenticationPolicy();
        NotPreventedRegisteredServiceAuthenticationPolicyCriteria cr4 = new NotPreventedRegisteredServiceAuthenticationPolicyCriteria();
        p4.setCriteria((RegisteredServiceAuthenticationPolicyCriteria)cr4);
        svc4.setAuthenticationPolicy((RegisteredServiceAuthenticationPolicy)p4);
        list.add(svc4);
        CasRegisteredService svc5 = RegisteredServiceTestUtils.getRegisteredService("serviceid5");
        DefaultRegisteredServiceAuthenticationPolicy p5 = new DefaultRegisteredServiceAuthenticationPolicy();
        GroovyRegisteredServiceAuthenticationPolicyCriteria cr5 = new GroovyRegisteredServiceAuthenticationPolicyCriteria();
        cr5.setScript("groovy { return Optional.empty() }");
        p5.setCriteria((RegisteredServiceAuthenticationPolicyCriteria)cr5);
        svc5.setAuthenticationPolicy((RegisteredServiceAuthenticationPolicy)p5);
        list.add(svc5);
        CasRegisteredService svc6 = RegisteredServiceTestUtils.getRegisteredService("serviceid6");
        DefaultRegisteredServiceAuthenticationPolicy p6 = new DefaultRegisteredServiceAuthenticationPolicy();
        RestfulRegisteredServiceAuthenticationPolicyCriteria cr6 = new RestfulRegisteredServiceAuthenticationPolicyCriteria();
        cr6.setUrl("https://example.org");
        cr6.setBasicAuthPassword("uid");
        cr6.setBasicAuthUsername("password");
        p6.setCriteria((RegisteredServiceAuthenticationPolicyCriteria)cr6);
        svc6.setAuthenticationPolicy((RegisteredServiceAuthenticationPolicy)p6);
        list.add(svc6);
        StaticApplicationContext appCtx = new StaticApplicationContext();
        appCtx.refresh();
        InMemoryServiceRegistry dao = new InMemoryServiceRegistry((ConfigurableApplicationContext)appCtx, list, new ArrayList());
        ServicesManagerConfigurationContext context = ServicesManagerConfigurationContext.builder().serviceRegistry((ServiceRegistry)dao).applicationContext((ConfigurableApplicationContext)appCtx).registeredServicesTemplatesManager((RegisteredServicesTemplatesManager)Mockito.mock(RegisteredServicesTemplatesManager.class)).environments(new HashSet(0)).servicesCache(Caffeine.newBuilder().build()).registeredServiceLocators(List.of(new DefaultServicesManagerRegisteredServiceLocator())).build();
        this.servicesManager = new DefaultServicesManager(context);
        this.servicesManager.load();
    }

    @Test
    void checkAnyPolicy() throws Throwable {
        RegisteredServiceAuthenticationPolicyResolver resolver = new RegisteredServiceAuthenticationPolicyResolver(this.servicesManager, (AuthenticationServiceSelectionPlan)new DefaultAuthenticationServiceSelectionPlan(new AuthenticationServiceSelectionStrategy[]{new DefaultAuthenticationServiceSelectionStrategy()}));
        AuthenticationTransaction transaction = CoreAuthenticationTestUtils.getAuthenticationTransactionFactory().newTransaction((Service)RegisteredServiceTestUtils.getService("serviceid1"), new Credential[]{RegisteredServiceTestUtils.getCredentialsWithSameUsernameAndPassword("casuser")});
        Set policies = resolver.resolve(transaction);
        Assertions.assertEquals((int)1, (int)policies.size());
        Assertions.assertInstanceOf(AtLeastOneCredentialValidatedAuthenticationPolicy.class, policies.iterator().next());
    }

    @Test
    void checkAllPolicy() throws Throwable {
        RegisteredServiceAuthenticationPolicyResolver resolver = new RegisteredServiceAuthenticationPolicyResolver(this.servicesManager, (AuthenticationServiceSelectionPlan)new DefaultAuthenticationServiceSelectionPlan(new AuthenticationServiceSelectionStrategy[]{new DefaultAuthenticationServiceSelectionStrategy()}));
        AuthenticationTransaction transaction = CoreAuthenticationTestUtils.getAuthenticationTransactionFactory().newTransaction((Service)RegisteredServiceTestUtils.getService("serviceid3"), new Credential[]{RegisteredServiceTestUtils.getCredentialsWithSameUsernameAndPassword("casuser")});
        Set policies = resolver.resolve(transaction);
        Assertions.assertEquals((int)1, (int)policies.size());
        Assertions.assertInstanceOf(AllAuthenticationHandlersSucceededAuthenticationPolicy.class, policies.iterator().next());
    }

    @Test
    void checkDefaultPolicy() throws Throwable {
        RegisteredServiceAuthenticationPolicyResolver resolver = new RegisteredServiceAuthenticationPolicyResolver(this.servicesManager, (AuthenticationServiceSelectionPlan)new DefaultAuthenticationServiceSelectionPlan(new AuthenticationServiceSelectionStrategy[]{new DefaultAuthenticationServiceSelectionStrategy()}));
        AbstractWebApplicationService service = RegisteredServiceTestUtils.getService("serviceid2");
        AuthenticationTransaction transaction = CoreAuthenticationTestUtils.getAuthenticationTransactionFactory().newTransaction((Service)service, new Credential[]{RegisteredServiceTestUtils.getCredentialsWithSameUsernameAndPassword("casuser")});
        Assertions.assertFalse((boolean)resolver.supports(transaction));
        Set policies = resolver.resolve(transaction);
        Assertions.assertTrue((boolean)policies.isEmpty());
        RegisteredServiceAuthenticationPolicy authPolicy = this.servicesManager.findServiceBy((Service)service).getAuthenticationPolicy();
        Assertions.assertNotNull((Object)authPolicy);
        Assertions.assertNull((Object)authPolicy.getCriteria());
    }

    @Test
    void checkNotPreventedPolicy() throws Throwable {
        RegisteredServiceAuthenticationPolicyResolver resolver = new RegisteredServiceAuthenticationPolicyResolver(this.servicesManager, (AuthenticationServiceSelectionPlan)new DefaultAuthenticationServiceSelectionPlan(new AuthenticationServiceSelectionStrategy[]{new DefaultAuthenticationServiceSelectionStrategy()}));
        AuthenticationTransaction transaction = CoreAuthenticationTestUtils.getAuthenticationTransactionFactory().newTransaction((Service)RegisteredServiceTestUtils.getService("serviceid4"), new Credential[]{RegisteredServiceTestUtils.getCredentialsWithSameUsernameAndPassword("casuser")});
        Set policies = resolver.resolve(transaction);
        Assertions.assertEquals((int)1, (int)policies.size());
        Assertions.assertInstanceOf(NotPreventedAuthenticationPolicy.class, policies.iterator().next());
    }

    @Test
    void checkGroovyPolicy() throws Throwable {
        RegisteredServiceAuthenticationPolicyResolver resolver = new RegisteredServiceAuthenticationPolicyResolver(this.servicesManager, (AuthenticationServiceSelectionPlan)new DefaultAuthenticationServiceSelectionPlan(new AuthenticationServiceSelectionStrategy[]{new DefaultAuthenticationServiceSelectionStrategy()}));
        AuthenticationTransaction transaction = CoreAuthenticationTestUtils.getAuthenticationTransactionFactory().newTransaction((Service)RegisteredServiceTestUtils.getService("serviceid5"), new Credential[]{RegisteredServiceTestUtils.getCredentialsWithSameUsernameAndPassword("casuser")});
        Set policies = resolver.resolve(transaction);
        Assertions.assertEquals((int)1, (int)policies.size());
        Assertions.assertInstanceOf(GroovyScriptAuthenticationPolicy.class, policies.iterator().next());
    }

    @Test
    void checkDisabledPolicy() throws Throwable {
        RegisteredServiceAuthenticationPolicyResolver resolver = new RegisteredServiceAuthenticationPolicyResolver(this.servicesManager, (AuthenticationServiceSelectionPlan)new DefaultAuthenticationServiceSelectionPlan(new AuthenticationServiceSelectionStrategy[]{new DefaultAuthenticationServiceSelectionStrategy()}));
        AuthenticationTransaction transaction = CoreAuthenticationTestUtils.getAuthenticationTransactionFactory().newTransaction((Service)RegisteredServiceTestUtils.getService("not-found-service"), new Credential[]{RegisteredServiceTestUtils.getCredentialsWithSameUsernameAndPassword("casuser")});
        Assertions.assertThrows(UnauthorizedSsoServiceException.class, () -> resolver.supports(transaction));
    }

    @Test
    void checkRestPolicy() throws Throwable {
        RegisteredServiceAuthenticationPolicyResolver resolver = new RegisteredServiceAuthenticationPolicyResolver(this.servicesManager, (AuthenticationServiceSelectionPlan)new DefaultAuthenticationServiceSelectionPlan(new AuthenticationServiceSelectionStrategy[]{new DefaultAuthenticationServiceSelectionStrategy()}));
        AuthenticationTransaction transaction = CoreAuthenticationTestUtils.getAuthenticationTransactionFactory().newTransaction((Service)RegisteredServiceTestUtils.getService("serviceid6"), new Credential[]{RegisteredServiceTestUtils.getCredentialsWithSameUsernameAndPassword("casuser")});
        Set policies = resolver.resolve(transaction);
        Assertions.assertEquals((int)1, (int)policies.size());
        Assertions.assertInstanceOf(RestfulAuthenticationPolicy.class, policies.iterator().next());
    }
}

