/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.services.RegisteredServicePublicKeyImpl;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="RegisteredService")
class RegisteredServicePublicKeyImplTests {
    private static final File JSON_FILE = new File(FileUtils.getTempDirectoryPath(), "registeredServicePublicKeyImpl.json");
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();

    RegisteredServicePublicKeyImplTests() {
    }

    @Test
    void verifySerializeAX509CertificateCredentialToJson() throws Throwable {
        RegisteredServicePublicKeyImpl publicKeyWritten = new RegisteredServicePublicKeyImpl("location", "algorithm");
        MAPPER.writeValue(JSON_FILE, (Object)publicKeyWritten);
        RegisteredServicePublicKeyImpl credentialRead = (RegisteredServicePublicKeyImpl)MAPPER.readValue(JSON_FILE, RegisteredServicePublicKeyImpl.class);
        Assertions.assertEquals((Object)publicKeyWritten, (Object)credentialRead);
    }

    @Test
    void verifyInstance() throws Throwable {
        RegisteredServicePublicKeyImpl key1 = new RegisteredServicePublicKeyImpl("classpath:keys/RSA1024Public.key", "RSA");
        Assertions.assertNotNull((Object)key1.createInstance());
        RegisteredServicePublicKeyImpl key2 = new RegisteredServicePublicKeyImpl(null, "RSA");
        Assertions.assertNull((Object)key2.createInstance());
    }
}

