/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apereo.cas.authentication.AcceptUsersAuthenticationHandler;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.DefaultAuthenticationBuilder;
import org.apereo.cas.authentication.DefaultAuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.credential.HttpBasedServiceCredential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.handler.support.SimpleTestUsernamePasswordAuthenticationHandler;
import org.apereo.cas.authentication.principal.AbstractWebApplicationService;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.RegisteredServicePrincipalAttributesRepository;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationServiceFactory;
import org.apereo.cas.authentication.principal.cache.CachingPrincipalAttributesRepository;
import org.apereo.cas.configuration.model.core.authentication.PrincipalAttributesCoreProperties;
import org.apereo.cas.services.AnonymousRegisteredServiceUsernameAttributeProvider;
import org.apereo.cas.services.AnyAuthenticationHandlerRegisteredServiceAuthenticationPolicyCriteria;
import org.apereo.cas.services.BaseRegisteredService;
import org.apereo.cas.services.BaseWebBasedRegisteredService;
import org.apereo.cas.services.CasModelRegisteredService;
import org.apereo.cas.services.CasRegisteredService;
import org.apereo.cas.services.DefaultRegisteredServiceAccessStrategy;
import org.apereo.cas.services.DefaultRegisteredServiceAuthenticationPolicy;
import org.apereo.cas.services.DefaultRegisteredServiceDelegatedAuthenticationPolicy;
import org.apereo.cas.services.DefaultRegisteredServiceProperty;
import org.apereo.cas.services.DefaultRegisteredServiceUsernameProvider;
import org.apereo.cas.services.PrincipalAttributeRegisteredServiceUsernameProvider;
import org.apereo.cas.services.RefuseRegisteredServiceProxyPolicy;
import org.apereo.cas.services.RegexMatchingRegisteredServiceProxyPolicy;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredServiceAttributeFilter;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceAuthenticationPolicy;
import org.apereo.cas.services.RegisteredServiceAuthenticationPolicyCriteria;
import org.apereo.cas.services.RegisteredServiceConsentPolicy;
import org.apereo.cas.services.RegisteredServiceDelegatedAuthenticationPolicy;
import org.apereo.cas.services.RegisteredServiceLogoutType;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.apereo.cas.services.RegisteredServiceProxyPolicy;
import org.apereo.cas.services.RegisteredServicePublicKey;
import org.apereo.cas.services.RegisteredServicePublicKeyImpl;
import org.apereo.cas.services.RegisteredServiceUsernameAttributeProvider;
import org.apereo.cas.services.ReturnAllAttributeReleasePolicy;
import org.apereo.cas.services.ReturnAllowedAttributeReleasePolicy;
import org.apereo.cas.services.ReturnMappedAttributeReleasePolicy;
import org.apereo.cas.services.consent.DefaultRegisteredServiceConsentPolicy;
import org.apereo.cas.services.support.RegisteredServiceRegexAttributeFilter;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.jooq.lambda.Unchecked;
import org.springframework.mock.web.MockHttpServletRequest;

public final class RegisteredServiceTestUtils {
    public static final String CONST_USERNAME = "test";
    public static final String CONST_TEST_URL = "https://google.com";
    public static final String CONST_TEST_URL2 = "https://example.com";
    public static final String CONST_TEST_URL3 = "https://another.example.com";

    public static HttpBasedServiceCredential getHttpBasedServiceCredentials() {
        return RegisteredServiceTestUtils.getHttpBasedServiceCredentials(CONST_TEST_URL);
    }

    public static HttpBasedServiceCredential getHttpBasedServiceCredentials(String url) {
        try {
            CasRegisteredService service = RegisteredServiceTestUtils.getRegisteredService(url);
            return new HttpBasedServiceCredential(new URI(url).toURL(), (CasModelRegisteredService)service);
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
    }

    public static UsernamePasswordCredential getCredentialsWithSameUsernameAndPassword(String username) {
        UsernamePasswordCredential usernamePasswordCredentials = new UsernamePasswordCredential();
        usernamePasswordCredentials.setUsername(username);
        usernamePasswordCredentials.assignPassword(username);
        return usernamePasswordCredentials;
    }

    public static UsernamePasswordCredential getCredentialsWithDifferentUsernameAndPassword(String username, String password) {
        UsernamePasswordCredential usernamePasswordCredentials = new UsernamePasswordCredential();
        usernamePasswordCredentials.setUsername(username);
        usernamePasswordCredentials.assignPassword(password);
        return usernamePasswordCredentials;
    }

    public static AbstractWebApplicationService getService() {
        return RegisteredServiceTestUtils.getService(CONST_TEST_URL);
    }

    public static AbstractWebApplicationService getService(String name) {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("service", name);
        return (AbstractWebApplicationService)new WebApplicationServiceFactory().createService((HttpServletRequest)request);
    }

    public static Service getService2() {
        return RegisteredServiceTestUtils.getService(CONST_TEST_URL2);
    }

    public static Map<String, Set<String>> getTestAttributes() {
        return RegisteredServiceTestUtils.getTestAttributes("CASUser");
    }

    public static Map<String, Set<String>> getTestAttributes(String username) {
        HashMap<String, Set<String>> attributes = new HashMap<String, Set<String>>();
        HashSet<String> attributeValues = new HashSet<String>();
        attributeValues.add("uid");
        attributes.put("uid", attributeValues);
        attributeValues = new HashSet();
        attributeValues.add(username);
        attributes.put("givenName", attributeValues);
        attributeValues = new HashSet();
        attributeValues.add("admin");
        attributeValues.add("system");
        attributeValues.add("cas");
        attributes.put("memberOf", attributeValues);
        return attributes;
    }

    public static BaseWebBasedRegisteredService getRegisteredService() {
        return RegisteredServiceTestUtils.getRegisteredService(CONST_TEST_URL);
    }

    public static BaseWebBasedRegisteredService getRegisteredService(Map requiredAttributes) {
        return RegisteredServiceTestUtils.getRegisteredService(CONST_TEST_URL, requiredAttributes);
    }

    public static <T extends BaseWebBasedRegisteredService> T getRegisteredService(String id, Class<T> clazz, boolean uniq) {
        return (T)((BaseWebBasedRegisteredService)Unchecked.supplier(() -> (BaseWebBasedRegisteredService)RegisteredServiceTestUtils.getRegisteredService(id, clazz, uniq, RegisteredServiceTestUtils.getTestAttributes())).get());
    }

    public static <T extends BaseRegisteredService> T getRegisteredService(String id, Class<T> clazz, boolean uniq, Map requiredAttributes) throws Exception {
        RegexMatchingRegisteredServiceProxyPolicy policy;
        BaseRegisteredService baseRegisteredService = (BaseRegisteredService)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        baseRegisteredService.setServiceId(id);
        baseRegisteredService.setEvaluationOrder(1);
        if (uniq) {
            String uuid = (String)Iterables.get((Iterable)Splitter.on((char)'-').split((CharSequence)UUID.randomUUID().toString()), (int)0);
            baseRegisteredService.setName("TestService" + uuid);
        } else {
            baseRegisteredService.setName(id);
        }
        baseRegisteredService.setDescription("Registered service description");
        baseRegisteredService.setId((long)RandomUtils.nextInt());
        baseRegisteredService.setTheme("exampleTheme");
        baseRegisteredService.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)new PrincipalAttributeRegisteredServiceUsernameProvider("uid"));
        DefaultRegisteredServiceAccessStrategy accessStrategy = new DefaultRegisteredServiceAccessStrategy(true, true);
        accessStrategy.setRequireAllAttributes(true);
        accessStrategy.setRequiredAttributes(requiredAttributes);
        accessStrategy.setUnauthorizedRedirectUrl(new URI("https://www.github.com"));
        baseRegisteredService.setAccessStrategy((RegisteredServiceAccessStrategy)accessStrategy);
        baseRegisteredService.setLogo("https://logo.example.org/logo.png");
        baseRegisteredService.setLogoutType(RegisteredServiceLogoutType.BACK_CHANNEL);
        baseRegisteredService.setLogoutUrl("https://sys.example.org/logout.png");
        if (baseRegisteredService instanceof CasRegisteredService) {
            policy = new RegexMatchingRegisteredServiceProxyPolicy();
            policy.setPattern("^http.+");
            ((CasRegisteredService)baseRegisteredService).setProxyPolicy((RegisteredServiceProxyPolicy)policy);
        }
        baseRegisteredService.setPublicKey((RegisteredServicePublicKey)new RegisteredServicePublicKeyImpl("classpath:RSA1024Public.key", "RSA"));
        policy = new ReturnAllowedAttributeReleasePolicy();
        policy.setAuthorizedToReleaseCredentialPassword(true);
        policy.setAuthorizedToReleaseProxyGrantingTicket(true);
        CachingPrincipalAttributesRepository repo = new CachingPrincipalAttributesRepository(TimeUnit.SECONDS.name(), 10L);
        repo.setMergingStrategy(PrincipalAttributesCoreProperties.MergingStrategyTypes.ADD);
        policy.setPrincipalAttributesRepository((RegisteredServicePrincipalAttributesRepository)repo);
        policy.setAttributeFilter((RegisteredServiceAttributeFilter)new RegisteredServiceRegexAttributeFilter("https://.+"));
        policy.setAllowedAttributes(new ArrayList<String>(RegisteredServiceTestUtils.getTestAttributes().keySet()));
        baseRegisteredService.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)policy);
        return (T)baseRegisteredService;
    }

    public static <T extends BaseWebBasedRegisteredService> T getRegisteredService(String id, Class<T> clazz) {
        return RegisteredServiceTestUtils.getRegisteredService(id, clazz, true);
    }

    public static CasRegisteredService getRegisteredService(String id) {
        return RegisteredServiceTestUtils.getRegisteredService(id, CasRegisteredService.class, true);
    }

    public static CasRegisteredService getRegisteredService(String id, boolean uniq) {
        return RegisteredServiceTestUtils.getRegisteredService(id, CasRegisteredService.class, uniq);
    }

    public static CasRegisteredService getRegisteredService(String id, Map requiredAttributes) {
        return (CasRegisteredService)Unchecked.supplier(() -> RegisteredServiceTestUtils.getRegisteredService(id, CasRegisteredService.class, true, requiredAttributes)).get();
    }

    public static Principal getPrincipal(Map<String, List<Object>> attributes) throws Throwable {
        return RegisteredServiceTestUtils.getPrincipal(CONST_USERNAME, attributes);
    }

    public static Principal getPrincipal() throws Throwable {
        return RegisteredServiceTestUtils.getPrincipal(CONST_USERNAME);
    }

    public static Principal getPrincipal(String name) {
        return RegisteredServiceTestUtils.getPrincipal(name, new HashMap<String, List<Object>>(0));
    }

    public static Principal getPrincipal(String name, Map<String, List<Object>> attributes) {
        return (Principal)FunctionUtils.doUnchecked(() -> PrincipalFactoryUtils.newPrincipalFactory().createPrincipal(name, attributes));
    }

    public static Authentication getAuthentication() {
        return RegisteredServiceTestUtils.getAuthentication(CONST_USERNAME);
    }

    public static Authentication getAuthentication(String name) {
        return RegisteredServiceTestUtils.getAuthentication(RegisteredServiceTestUtils.getPrincipal(name));
    }

    public static Authentication getAuthentication(String name, Map<String, List<Object>> attributes) {
        return RegisteredServiceTestUtils.getAuthentication(RegisteredServiceTestUtils.getPrincipal(name), attributes);
    }

    public static Authentication getAuthentication(Principal principal) {
        return RegisteredServiceTestUtils.getAuthentication(principal, new HashMap<String, List<Object>>(0));
    }

    public static Authentication getAuthentication(Principal principal, Map<String, List<Object>> attributes) {
        SimpleTestUsernamePasswordAuthenticationHandler handler = new SimpleTestUsernamePasswordAuthenticationHandler();
        UsernamePasswordCredential credential = new UsernamePasswordCredential();
        return new DefaultAuthenticationBuilder(principal).addCredential((Credential)credential).addSuccess("testHandler", (AuthenticationHandlerExecutionResult)new DefaultAuthenticationHandlerExecutionResult((AuthenticationHandler)handler, (Credential)credential)).setAttributes(attributes).build();
    }

    public static List<RegisteredService> getRegisteredServicesForTests() throws Exception {
        ArrayList<RegisteredService> list = new ArrayList<RegisteredService>();
        CasRegisteredService svc = RegisteredServiceTestUtils.getRegisteredService("testencryption$");
        ReturnAllowedAttributeReleasePolicy policy = new ReturnAllowedAttributeReleasePolicy();
        policy.setAuthorizedToReleaseCredentialPassword(true);
        policy.setAuthorizedToReleaseProxyGrantingTicket(true);
        RegisteredServicePublicKeyImpl publicKey = new RegisteredServicePublicKeyImpl();
        publicKey.setLocation("classpath:keys/RSA1024Public.key");
        svc.setPublicKey((RegisteredServicePublicKey)publicKey);
        svc.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)policy);
        list.add((RegisteredService)svc);
        CasRegisteredService svc2 = RegisteredServiceTestUtils.getRegisteredService("testDefault");
        svc2.setAccessStrategy((RegisteredServiceAccessStrategy)new DefaultRegisteredServiceAccessStrategy(new HashMap()));
        svc2.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)new DefaultRegisteredServiceUsernameProvider());
        list.add((RegisteredService)svc2);
        CasRegisteredService svc3 = RegisteredServiceTestUtils.getRegisteredService("https://example\\.com/normal/.*");
        svc3.setEvaluationOrder(10);
        svc3.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)new ReturnAllAttributeReleasePolicy());
        svc3.setAccessStrategy((RegisteredServiceAccessStrategy)new DefaultRegisteredServiceAccessStrategy(new HashMap()));
        svc3.setAuthenticationPolicy((RegisteredServiceAuthenticationPolicy)new DefaultRegisteredServiceAuthenticationPolicy().setCriteria((RegisteredServiceAuthenticationPolicyCriteria)new AnyAuthenticationHandlerRegisteredServiceAuthenticationPolicyCriteria()));
        list.add((RegisteredService)svc3);
        CasRegisteredService svc4 = RegisteredServiceTestUtils.getRegisteredService("https://example\\.com/high/.*");
        svc4.setEvaluationOrder(20);
        svc4.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)new ReturnAllAttributeReleasePolicy());
        Set handlers = CollectionUtils.wrapHashSet((Object[])new String[]{AcceptUsersAuthenticationHandler.class.getSimpleName(), "TestOneTimePasswordAuthenticationHandler"});
        svc4.setAuthenticationPolicy((RegisteredServiceAuthenticationPolicy)new DefaultRegisteredServiceAuthenticationPolicy().setRequiredAuthenticationHandlers(handlers).setCriteria((RegisteredServiceAuthenticationPolicyCriteria)new AnyAuthenticationHandlerRegisteredServiceAuthenticationPolicyCriteria()));
        svc4.setAccessStrategy((RegisteredServiceAccessStrategy)new DefaultRegisteredServiceAccessStrategy(new HashMap()));
        list.add((RegisteredService)svc4);
        CasRegisteredService svc5 = RegisteredServiceTestUtils.getRegisteredService("(https://)*google.com$");
        svc5.setEvaluationOrder(1);
        svc5.setProxyPolicy((RegisteredServiceProxyPolicy)new RegexMatchingRegisteredServiceProxyPolicy().setPattern(".+"));
        svc5.setPublicKey((RegisteredServicePublicKey)new RegisteredServicePublicKeyImpl("classpath:keys/RSA4096Public.key", "RSA"));
        ReturnAllowedAttributeReleasePolicy policy1 = new ReturnAllowedAttributeReleasePolicy();
        policy1.setAuthorizedToReleaseCredentialPassword(true);
        policy1.setAuthorizedToReleaseProxyGrantingTicket(true);
        policy1.setAllowedAttributes(CollectionUtils.wrap((Object)"binaryAttribute"));
        svc5.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)policy1);
        svc5.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)new DefaultRegisteredServiceUsernameProvider());
        svc5.setAccessStrategy((RegisteredServiceAccessStrategy)new DefaultRegisteredServiceAccessStrategy(new HashMap()));
        list.add((RegisteredService)svc5);
        CasRegisteredService svc6 = RegisteredServiceTestUtils.getRegisteredService("eduPersonTest");
        svc6.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)new PrincipalAttributeRegisteredServiceUsernameProvider("eduPersonAffiliation"));
        svc6.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)new ReturnAllAttributeReleasePolicy());
        svc6.setAccessStrategy((RegisteredServiceAccessStrategy)new DefaultRegisteredServiceAccessStrategy(new HashMap()));
        svc6.setProxyPolicy((RegisteredServiceProxyPolicy)new RefuseRegisteredServiceProxyPolicy());
        list.add((RegisteredService)svc6);
        CasRegisteredService svc7 = RegisteredServiceTestUtils.getRegisteredService("testencryption$");
        ReturnAllowedAttributeReleasePolicy policy2 = new ReturnAllowedAttributeReleasePolicy();
        policy2.setAuthorizedToReleaseCredentialPassword(true);
        policy2.setAuthorizedToReleaseProxyGrantingTicket(true);
        svc7.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)policy2);
        svc7.setPublicKey((RegisteredServicePublicKey)new RegisteredServicePublicKeyImpl("classpath:keys/RSA1024Public.key", "RSA"));
        svc7.setAccessStrategy((RegisteredServiceAccessStrategy)new DefaultRegisteredServiceAccessStrategy(new HashMap()));
        svc7.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)new DefaultRegisteredServiceUsernameProvider());
        list.add((RegisteredService)svc7);
        CasRegisteredService svc8 = RegisteredServiceTestUtils.getRegisteredService("^TestServiceAttributeForAuthzFails");
        svc8.setAccessStrategy((RegisteredServiceAccessStrategy)new DefaultRegisteredServiceAccessStrategy(CollectionUtils.wrap((String)"cn", (Object)CollectionUtils.wrapSet((Object)"cnValue"), (String)"givenName", (Object)CollectionUtils.wrapSet((Object)"gnameValue"))));
        svc8.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)new DefaultRegisteredServiceUsernameProvider());
        list.add((RegisteredService)svc8);
        CasRegisteredService svc9 = RegisteredServiceTestUtils.getRegisteredService("^TestSsoFalse");
        svc9.setAccessStrategy((RegisteredServiceAccessStrategy)new DefaultRegisteredServiceAccessStrategy(true, false));
        svc9.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)new DefaultRegisteredServiceUsernameProvider());
        list.add((RegisteredService)svc9);
        CasRegisteredService svc10 = RegisteredServiceTestUtils.getRegisteredService("TestServiceAttributeForAuthzPasses");
        svc10.setAccessStrategy((RegisteredServiceAccessStrategy)new DefaultRegisteredServiceAccessStrategy(CollectionUtils.wrap((String)"groupMembership", (Object)CollectionUtils.wrapSet((Object)"adopters"))));
        svc10.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)new ReturnAllAttributeReleasePolicy());
        svc10.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)new DefaultRegisteredServiceUsernameProvider());
        list.add((RegisteredService)svc10);
        CasRegisteredService svc11 = RegisteredServiceTestUtils.getRegisteredService("eduPersonTestInvalid");
        svc11.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)new PrincipalAttributeRegisteredServiceUsernameProvider("nonExistentAttributeName"));
        svc11.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)new ReturnAllowedAttributeReleasePolicy(CollectionUtils.wrap((Object)"groupMembership")));
        svc11.setAccessStrategy((RegisteredServiceAccessStrategy)new DefaultRegisteredServiceAccessStrategy(new HashMap()));
        list.add((RegisteredService)svc11);
        CasRegisteredService svc12 = RegisteredServiceTestUtils.getRegisteredService("testAnonymous");
        svc12.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)new AnonymousRegisteredServiceUsernameAttributeProvider());
        svc12.setAccessStrategy((RegisteredServiceAccessStrategy)new DefaultRegisteredServiceAccessStrategy(new HashMap()));
        list.add((RegisteredService)svc12);
        CasRegisteredService svc13 = RegisteredServiceTestUtils.getRegisteredService("^http://www.jasig.org.+");
        svc13.setProxyPolicy((RegisteredServiceProxyPolicy)new RegexMatchingRegisteredServiceProxyPolicy().setPattern(".+"));
        svc13.setAccessStrategy((RegisteredServiceAccessStrategy)new DefaultRegisteredServiceAccessStrategy(new HashMap()));
        svc13.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)new DefaultRegisteredServiceUsernameProvider());
        list.add((RegisteredService)svc13);
        CasRegisteredService svc14 = RegisteredServiceTestUtils.getRegisteredService("usernameAttributeProviderService");
        svc14.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)new PrincipalAttributeRegisteredServiceUsernameProvider("cn"));
        svc14.setAccessStrategy((RegisteredServiceAccessStrategy)new DefaultRegisteredServiceAccessStrategy(new HashMap()));
        list.add((RegisteredService)svc14);
        CasRegisteredService svc15 = RegisteredServiceTestUtils.getRegisteredService("proxyService");
        svc15.setProxyPolicy((RegisteredServiceProxyPolicy)new RegexMatchingRegisteredServiceProxyPolicy().setPattern("^https://.+"));
        svc15.setAccessStrategy((RegisteredServiceAccessStrategy)new DefaultRegisteredServiceAccessStrategy(new HashMap()));
        svc15.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)new DefaultRegisteredServiceUsernameProvider());
        list.add((RegisteredService)svc15);
        CasRegisteredService svc16 = RegisteredServiceTestUtils.getRegisteredService("^test.*");
        svc16.setAccessStrategy((RegisteredServiceAccessStrategy)new DefaultRegisteredServiceAccessStrategy(new HashMap()));
        svc16.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)new DefaultRegisteredServiceUsernameProvider());
        svc16.setEvaluationOrder(1000);
        list.add((RegisteredService)svc16);
        CasRegisteredService svc17 = RegisteredServiceTestUtils.getRegisteredService("https://localhost.*");
        svc17.setAccessStrategy((RegisteredServiceAccessStrategy)new DefaultRegisteredServiceAccessStrategy(new HashMap()));
        svc17.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)new DefaultRegisteredServiceUsernameProvider());
        svc17.setEvaluationOrder(100);
        list.add((RegisteredService)svc17);
        CasRegisteredService svc18 = RegisteredServiceTestUtils.getRegisteredService("https://github.com/apereo/cas");
        DefaultRegisteredServiceAccessStrategy accessStrategy = new DefaultRegisteredServiceAccessStrategy();
        accessStrategy.setUnauthorizedRedirectUrl(new URI("https://www.github.com"));
        svc18.setAccessStrategy((RegisteredServiceAccessStrategy)accessStrategy);
        svc18.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)new DefaultRegisteredServiceUsernameProvider());
        svc18.setEvaluationOrder(98);
        list.add((RegisteredService)svc18);
        CasRegisteredService svc19 = RegisteredServiceTestUtils.getRegisteredService("https://carmenwiki.osu.edu.*");
        svc19.setAccessStrategy((RegisteredServiceAccessStrategy)new DefaultRegisteredServiceAccessStrategy(new HashMap()));
        svc19.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)new DefaultRegisteredServiceUsernameProvider());
        svc19.setEvaluationOrder(99);
        list.add((RegisteredService)svc19);
        CasRegisteredService svc20 = RegisteredServiceTestUtils.getRegisteredService("consentService");
        svc20.setAccessStrategy((RegisteredServiceAccessStrategy)new DefaultRegisteredServiceAccessStrategy(new HashMap()));
        svc20.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)new DefaultRegisteredServiceUsernameProvider());
        ReturnAllAttributeReleasePolicy attrPolicy = new ReturnAllAttributeReleasePolicy();
        attrPolicy.setConsentPolicy((RegisteredServiceConsentPolicy)new DefaultRegisteredServiceConsentPolicy());
        svc20.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)attrPolicy);
        svc20.setEvaluationOrder(88);
        list.add((RegisteredService)svc20);
        CasRegisteredService svc21 = RegisteredServiceTestUtils.getRegisteredService("jwtservice");
        svc21.setAccessStrategy((RegisteredServiceAccessStrategy)new DefaultRegisteredServiceAccessStrategy(new HashMap()));
        svc21.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)new DefaultRegisteredServiceUsernameProvider());
        DefaultRegisteredServiceProperty prop = new DefaultRegisteredServiceProperty();
        prop.setValues(CollectionUtils.wrapSet((Object)Boolean.TRUE.toString()));
        svc21.getProperties().put(RegisteredServiceProperty.RegisteredServiceProperties.TOKEN_AS_SERVICE_TICKET.getPropertyName(), prop);
        svc21.setEvaluationOrder(2000);
        list.add((RegisteredService)svc21);
        CasRegisteredService svc22 = RegisteredServiceTestUtils.getRegisteredService("cas-access-disabled");
        DefaultRegisteredServiceAccessStrategy strategy = new DefaultRegisteredServiceAccessStrategy();
        strategy.setEnabled(false);
        strategy.setUnauthorizedRedirectUrl(new URI("https://www.github.com"));
        svc22.setAccessStrategy((RegisteredServiceAccessStrategy)strategy);
        list.add((RegisteredService)svc22);
        CasRegisteredService svc23 = RegisteredServiceTestUtils.getRegisteredService("cas-access-delegation");
        DefaultRegisteredServiceAccessStrategy strategy23 = new DefaultRegisteredServiceAccessStrategy();
        strategy23.setEnabled(true);
        DefaultRegisteredServiceDelegatedAuthenticationPolicy delegate = new DefaultRegisteredServiceDelegatedAuthenticationPolicy();
        delegate.setExclusive(true);
        strategy23.setDelegatedAuthenticationPolicy((RegisteredServiceDelegatedAuthenticationPolicy)delegate);
        svc23.setAccessStrategy((RegisteredServiceAccessStrategy)strategy23);
        list.add((RegisteredService)svc23);
        CasRegisteredService svc24 = RegisteredServiceTestUtils.getRegisteredService("https://www.casinthecloud.com");
        svc24.setProxyPolicy((RegisteredServiceProxyPolicy)new RegexMatchingRegisteredServiceProxyPolicy().setPattern(".+"));
        svc24.setPublicKey((RegisteredServicePublicKey)new RegisteredServicePublicKeyImpl("classpath:keys/RSA4096Public.key", "RSA"));
        ReturnAllowedAttributeReleasePolicy policy24 = new ReturnAllowedAttributeReleasePolicy();
        policy24.setAuthorizedToReleaseCredentialPassword(true);
        policy24.setAuthorizedToReleaseProxyGrantingTicket(false);
        policy24.setAllowedAttributes(CollectionUtils.wrap((Object)"binaryAttribute"));
        svc24.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)policy24);
        svc24.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)new DefaultRegisteredServiceUsernameProvider());
        svc24.setAccessStrategy((RegisteredServiceAccessStrategy)new DefaultRegisteredServiceAccessStrategy(new HashMap()));
        list.add((RegisteredService)svc24);
        CasRegisteredService svc25 = RegisteredServiceTestUtils.getRegisteredService("accessStrategyMapped");
        svc25.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)new ReturnMappedAttributeReleasePolicy().setAllowedAttributes(Map.of("sAMAccountName", "uid", "mail", "groovy { return attributes['sAMAccountName'][0] + '@example.org'}")));
        svc25.setAccessStrategy((RegisteredServiceAccessStrategy)new DefaultRegisteredServiceAccessStrategy(Map.of("mail", Set.of(".*"))));
        list.add((RegisteredService)svc25);
        return list;
    }

    @Generated
    private RegisteredServiceTestUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

