/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.principal.PersistentIdGenerator;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ShibbolethCompatiblePersistentIdGenerator;
import org.apereo.cas.config.CasCoreHttpConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.AnonymousRegisteredServiceUsernameAttributeProvider;
import org.apereo.cas.services.BaseRegisteredService;
import org.apereo.cas.services.CasRegisteredService;
import org.apereo.cas.services.DefaultRegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.RegisteredServiceUsernameAttributeProvider;
import org.apereo.cas.services.ReturnAllAttributeReleasePolicy;
import org.apereo.cas.services.ReturnAllowedAttributeReleasePolicy;
import org.apereo.cas.services.ReturnMappedAttributeReleasePolicy;
import org.apereo.cas.util.CollectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

@Tag(value="RegisteredService")
@SpringBootTest(classes={CasCoreHttpConfiguration.class})
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
class RegisteredServiceTests {
    private static final long ID = 1000L;
    private static final String SERVICE_ID = "test";
    private static final String DESCRIPTION = "test";
    private static final String SERVICEID = "serviceId";
    private static final String THEME = "theme";
    private static final String NAME = "name";
    private static final boolean ENABLED = false;
    private static final boolean SSO_ENABLED = false;
    private static final String ATTR_1 = "attr1";
    private static final String ATTR_2 = "attr2";
    private static final String ATTR_3 = "attr3";
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    private final BaseRegisteredService baseService = new BaseRegisteredService(){
        private static final long serialVersionUID = 1L;

        public void setServiceId(String id) {
            this.serviceId = id;
        }

        public boolean matches(Service service) {
            return true;
        }

        public boolean matches(String serviceId) {
            return true;
        }
    };

    RegisteredServiceTests() {
    }

    @Test
    void verifyAllowToProxyIsFalseByDefault() throws Throwable {
        CasRegisteredService service = new CasRegisteredService();
        Assertions.assertFalse((boolean)service.getProxyPolicy().isAllowedToProxy());
    }

    @Test
    void verifySettersAndGetters() throws Throwable {
        this.prepareService();
        Assertions.assertEquals((Object)"test", (Object)this.baseService.getDescription());
        Assertions.assertEquals((Object)false, (Object)this.baseService.getAccessStrategy().isServiceAccessAllowed((RegisteredService)this.baseService, CoreAuthenticationTestUtils.getService()));
        Assertions.assertEquals((long)1000L, (long)this.baseService.getId());
        Assertions.assertEquals((Object)NAME, (Object)this.baseService.getName());
        Assertions.assertEquals((Object)SERVICEID, (Object)this.baseService.getServiceId());
        Assertions.assertEquals((Object)false, (Object)this.baseService.getAccessStrategy().isServiceAccessAllowedForSso((RegisteredService)this.baseService));
        Assertions.assertEquals((Object)THEME, (Object)this.baseService.getTheme());
        Assertions.assertNotNull((Object)this.baseService);
        Assertions.assertEquals((Object)this.baseService, (Object)this.baseService);
    }

    @Test
    void verifyServiceAttributeFilterAllAttributes() throws Throwable {
        this.prepareService();
        this.baseService.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)new ReturnAllAttributeReleasePolicy());
        Principal p = (Principal)Mockito.mock(Principal.class);
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
        map.put(ATTR_1, List.of("value1"));
        map.put(ATTR_2, List.of("value2"));
        map.put(ATTR_3, Arrays.asList("v3", "v4"));
        Mockito.when((Object)p.getAttributes()).thenReturn(map);
        Mockito.when((Object)p.getId()).thenReturn((Object)"principalId");
        RegisteredServiceAttributeReleasePolicyContext context = RegisteredServiceAttributeReleasePolicyContext.builder().registeredService((RegisteredService)RegisteredServiceTestUtils.getRegisteredService("test")).service((Service)RegisteredServiceTestUtils.getService()).applicationContext((ApplicationContext)this.applicationContext).principal(p).build();
        Map attr = this.baseService.getAttributeReleasePolicy().getAttributes(context);
        Assertions.assertEquals((int)attr.size(), (int)map.size());
    }

    @Test
    void verifyServiceAttributeFilterAllowedAttributes() throws Throwable {
        this.prepareService();
        ReturnAllowedAttributeReleasePolicy policy = new ReturnAllowedAttributeReleasePolicy();
        policy.setAllowedAttributes(Arrays.asList(ATTR_1, ATTR_3));
        this.baseService.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)policy);
        Principal p = (Principal)Mockito.mock(Principal.class);
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
        map.put(ATTR_1, List.of("value1"));
        map.put(ATTR_2, List.of("value2"));
        map.put(ATTR_3, Arrays.asList("v3", "v4"));
        Mockito.when((Object)p.getAttributes()).thenReturn(map);
        Mockito.when((Object)p.getId()).thenReturn((Object)"principalId");
        RegisteredServiceAttributeReleasePolicyContext context = RegisteredServiceAttributeReleasePolicyContext.builder().registeredService((RegisteredService)RegisteredServiceTestUtils.getRegisteredService("test")).service((Service)RegisteredServiceTestUtils.getService()).applicationContext((ApplicationContext)this.applicationContext).principal(p).build();
        Map attr = this.baseService.getAttributeReleasePolicy().getAttributes(context);
        Assertions.assertEquals((int)2, (int)attr.size());
        Assertions.assertTrue((boolean)attr.containsKey(ATTR_1));
        Assertions.assertTrue((boolean)attr.containsKey(ATTR_3));
    }

    @Test
    void verifyServiceAttributeFilterMappedAttributes() throws Throwable {
        this.prepareService();
        ReturnMappedAttributeReleasePolicy policy = new ReturnMappedAttributeReleasePolicy();
        ArrayListMultimap mappedAttr = ArrayListMultimap.create();
        mappedAttr.put((Object)ATTR_1, (Object)"newAttr1");
        policy.setAllowedAttributes(CollectionUtils.wrap((Multimap)mappedAttr));
        this.baseService.setAttributeReleasePolicy((RegisteredServiceAttributeReleasePolicy)policy);
        Principal p = (Principal)Mockito.mock(Principal.class);
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
        map.put(ATTR_1, List.of("value1"));
        map.put(ATTR_2, List.of("value2"));
        map.put(ATTR_3, Arrays.asList("v3", "v4"));
        Mockito.when((Object)p.getAttributes()).thenReturn(map);
        Mockito.when((Object)p.getId()).thenReturn((Object)"principalId");
        RegisteredServiceAttributeReleasePolicyContext context = RegisteredServiceAttributeReleasePolicyContext.builder().registeredService((RegisteredService)RegisteredServiceTestUtils.getRegisteredService("test")).service((Service)RegisteredServiceTestUtils.getService()).principal(p).applicationContext((ApplicationContext)this.applicationContext).build();
        Map attr = this.baseService.getAttributeReleasePolicy().getAttributes(context);
        Assertions.assertEquals((int)1, (int)attr.size());
        Assertions.assertTrue((boolean)attr.containsKey("newAttr1"));
    }

    @Test
    void verifyServiceEquality() throws Throwable {
        CasRegisteredService svc1 = RegisteredServiceTestUtils.getRegisteredService(SERVICEID, false);
        CasRegisteredService svc2 = RegisteredServiceTestUtils.getRegisteredService(SERVICEID, false);
        Assertions.assertEquals((Object)svc1, (Object)svc2);
    }

    @Test
    void verifyServiceWithInvalidIdStillHasTheSameIdAfterCallingMatches() throws Throwable {
        String invalidId = "***";
        CasRegisteredService service = RegisteredServiceTestUtils.getRegisteredService("***");
        service.matches("notRelevant");
        Assertions.assertEquals((Object)"***", (Object)service.getServiceId());
    }

    private void prepareService() {
        this.baseService.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)new AnonymousRegisteredServiceUsernameAttributeProvider((PersistentIdGenerator)new ShibbolethCompatiblePersistentIdGenerator("casrox")));
        this.baseService.setDescription("test");
        this.baseService.setId(1000L);
        this.baseService.setName(NAME);
        this.baseService.setServiceId(SERVICEID);
        this.baseService.setTheme(THEME);
        this.baseService.setAccessStrategy((RegisteredServiceAccessStrategy)new DefaultRegisteredServiceAccessStrategy(false, false));
    }
}

