/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.util.Set;
import org.apereo.cas.config.CasCoreNotificationsConfiguration;
import org.apereo.cas.config.CasCoreServicesConfiguration;
import org.apereo.cas.config.CasCoreUtilConfiguration;
import org.apereo.cas.config.CasCoreWebConfiguration;
import org.apereo.cas.config.CasWebApplicationServiceFactoryConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.notifications.CommunicationsManager;
import org.apereo.cas.notifications.sms.MockSmsSender;
import org.apereo.cas.notifications.sms.SmsSender;
import org.apereo.cas.services.BaseWebBasedRegisteredService;
import org.apereo.cas.services.DefaultRegisteredServiceContact;
import org.apereo.cas.services.DefaultRegisteredServicesEventListener;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.events.service.CasRegisteredServiceExpiredEvent;
import org.apereo.cas.support.events.service.CasRegisteredServicesRefreshEvent;
import org.apereo.cas.util.junit.EnabledIfListeningOnPort;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.mail.MailSenderAutoConfiguration;
import org.springframework.boot.autoconfigure.mail.MailSenderValidatorAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.annotation.Bean;

@SpringBootTest(classes={RefreshAutoConfiguration.class, WebMvcAutoConfiguration.class, RegisteredServicesEventListenerTestConfiguration.class, CasCoreServicesConfiguration.class, CasCoreNotificationsConfiguration.class, CasCoreUtilConfiguration.class, CasCoreWebConfiguration.class, CasWebApplicationServiceFactoryConfiguration.class, MailSenderAutoConfiguration.class, MailSenderValidatorAutoConfiguration.class}, properties={"spring.mail.host=localhost", "spring.mail.port=25000", "cas.service-registry.sms.text=Service ${service} has expired in CAS service registry", "cas.service-registry.sms.from=3477563421", "cas.service-registry.mail.from=admin@example.org", "cas.service-registry.mail.subject=Sample Subject", "cas.service-registry.mail.text=Service ${service} has expired in CAS service registry"})
@Tag(value="Mail")
@EnabledIfListeningOnPort(port={25000})
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
class RegisteredServicesEventListenerTests {
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    @Qualifier(value="communicationsManager")
    private CommunicationsManager communicationsManager;
    @Autowired
    private CasConfigurationProperties casProperties;
    private ClientInfo clientInfo;

    RegisteredServicesEventListenerTests() {
    }

    @BeforeEach
    public void setup() {
        this.clientInfo = ClientInfoHolder.getClientInfo();
    }

    @Test
    void verifyServiceExpirationEventNoContact() throws Throwable {
        final BaseWebBasedRegisteredService registeredService = RegisteredServiceTestUtils.getRegisteredService();
        Assertions.assertDoesNotThrow((Executable)new Executable(){

            public void execute() throws Throwable {
                DefaultRegisteredServicesEventListener listener = new DefaultRegisteredServicesEventListener(RegisteredServicesEventListenerTests.this.servicesManager, RegisteredServicesEventListenerTests.this.casProperties, RegisteredServicesEventListenerTests.this.communicationsManager);
                CasRegisteredServiceExpiredEvent event = new CasRegisteredServiceExpiredEvent((Object)this, (RegisteredService)registeredService, false, RegisteredServicesEventListenerTests.this.clientInfo);
                listener.handleRegisteredServiceExpiredEvent(event);
            }
        });
    }

    @Test
    void verifyServiceExpirationEventWithContact() throws Throwable {
        BaseWebBasedRegisteredService registeredService = RegisteredServiceTestUtils.getRegisteredService();
        DefaultRegisteredServiceContact contact = new DefaultRegisteredServiceContact();
        contact.setName("Test");
        contact.setEmail("casuser@example.org");
        contact.setPhone("13477465421");
        registeredService.getContacts().add(contact);
        DefaultRegisteredServicesEventListener listener = new DefaultRegisteredServicesEventListener(this.servicesManager, this.casProperties, this.communicationsManager);
        CasRegisteredServiceExpiredEvent event = new CasRegisteredServiceExpiredEvent((Object)this, (RegisteredService)registeredService, false, this.clientInfo);
        Assertions.assertDoesNotThrow(() -> listener.handleRegisteredServiceExpiredEvent(event));
    }

    @Test
    void verifyServiceExpirationWithRemovalEvent() throws Throwable {
        BaseWebBasedRegisteredService registeredService = RegisteredServiceTestUtils.getRegisteredService();
        DefaultRegisteredServiceContact contact = new DefaultRegisteredServiceContact();
        contact.setName("Test");
        contact.setEmail("casuser@example.org");
        contact.setPhone("13477465421");
        registeredService.getContacts().add(contact);
        DefaultRegisteredServicesEventListener listener = new DefaultRegisteredServicesEventListener(this.servicesManager, this.casProperties, this.communicationsManager);
        listener.handleRefreshEvent(new CasRegisteredServicesRefreshEvent((Object)this, this.clientInfo));
        listener.handleEnvironmentChangeEvent(new EnvironmentChangeEvent(Set.of()));
        CasRegisteredServiceExpiredEvent event = new CasRegisteredServiceExpiredEvent((Object)this, (RegisteredService)registeredService, true, this.clientInfo);
        listener.handleRegisteredServiceExpiredEvent(event);
    }

    @TestConfiguration(value="RegisteredServicesEventListenerTestConfiguration", proxyBeanMethods=false)
    static class RegisteredServicesEventListenerTestConfiguration {
        RegisteredServicesEventListenerTestConfiguration() {
        }

        @ConditionalOnMissingBean(name={"smsSender"})
        @Bean
        public SmsSender smsSender() {
            return MockSmsSender.INSTANCE;
        }
    }
}

