/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.services.RegisteredServiceAccessStrategyRequest;
import org.apereo.cas.services.RemoteEndpointServiceAccessStrategy;
import org.apereo.cas.util.MockWebServer;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

@Tag(value="RegisteredService")
class RemoteEndpointServiceAccessStrategyTests {
    private static final File JSON_FILE = new File(FileUtils.getTempDirectoryPath(), "remoteEndpointServiceAccessStrategy.json");
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();

    RemoteEndpointServiceAccessStrategyTests() {
    }

    @Test
    void verifySerializeToJson() throws IOException {
        RemoteEndpointServiceAccessStrategy strategyWritten = new RemoteEndpointServiceAccessStrategy();
        MAPPER.writeValue(JSON_FILE, (Object)strategyWritten);
        RemoteEndpointServiceAccessStrategy credentialRead = (RemoteEndpointServiceAccessStrategy)MAPPER.readValue(JSON_FILE, RemoteEndpointServiceAccessStrategy.class);
        Assertions.assertEquals((Object)strategyWritten, (Object)credentialRead);
    }

    @Test
    void verifyOperation() throws Throwable {
        RemoteEndpointServiceAccessStrategy strategy = new RemoteEndpointServiceAccessStrategy();
        strategy.setEndpointUrl("http://localhost:8755");
        strategy.setAcceptableResponseCodes("200,201");
        try (MockWebServer webServer = new MockWebServer(8755, (Resource)new ByteArrayResource("OK".getBytes(StandardCharsets.UTF_8), "REST Output"), "application/json");){
            webServer.start();
            Assertions.assertTrue((boolean)strategy.authorizeRequest(RegisteredServiceAccessStrategyRequest.builder().principalId("casuser").build()));
        }
    }

    @Test
    void verifyFails() throws Throwable {
        RemoteEndpointServiceAccessStrategy strategy = new RemoteEndpointServiceAccessStrategy();
        strategy.setEndpointUrl("http://localhost:1234");
        strategy.setAcceptableResponseCodes("600");
        try (MockWebServer webServer = new MockWebServer(8756, (Resource)new ByteArrayResource("OK".getBytes(StandardCharsets.UTF_8), "REST Output"), "application/json");){
            webServer.start();
            Assertions.assertFalse((boolean)strategy.authorizeRequest(RegisteredServiceAccessStrategyRequest.builder().principalId("casuser").build()));
        }
    }
}

