/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.services.BaseWebBasedRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.RestfulRegisteredServiceProxyPolicy;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.MockWebServer;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;

@Tag(value="RegisteredService")
class RestfulRegisteredServiceProxyPolicyTests {
    private static final File JSON_FILE = new File(FileUtils.getTempDirectoryPath(), "RestfulRegisteredServiceProxyPolicyTests.json");
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();

    RestfulRegisteredServiceProxyPolicyTests() {
    }

    @Test
    void verifySerialization() throws Throwable {
        RestfulRegisteredServiceProxyPolicy policy = new RestfulRegisteredServiceProxyPolicy();
        policy.setEndpoint("http://localhost:9222");
        policy.setHeaders(CollectionUtils.wrap((String)"header", (Object)"value"));
        MAPPER.writeValue(JSON_FILE, (Object)policy);
        RestfulRegisteredServiceProxyPolicy readPolicy = (RestfulRegisteredServiceProxyPolicy)MAPPER.readValue(JSON_FILE, RestfulRegisteredServiceProxyPolicy.class);
        Assertions.assertEquals((Object)policy, (Object)readPolicy);
    }

    @Test
    void verifyOperationPasses() throws Throwable {
        try (MockWebServer webServer = new MockWebServer(9222, (Resource)new ByteArrayResource("".getBytes(StandardCharsets.UTF_8), "Output"), HttpStatus.OK);){
            webServer.start();
            BaseWebBasedRegisteredService service = RegisteredServiceTestUtils.getRegisteredService();
            RestfulRegisteredServiceProxyPolicy policy = new RestfulRegisteredServiceProxyPolicy();
            policy.setEndpoint("http://localhost:9222");
            policy.setHeaders(CollectionUtils.wrap((String)"header", (Object)"value"));
            Assertions.assertTrue((boolean)policy.isAllowedProxyCallbackUrl((RegisteredService)service, new URI("https://proxy.example.org").toURL()));
        }
    }

    @Test
    void verifyOperationFails() throws Throwable {
        try (MockWebServer webServer = new MockWebServer(9222, (Resource)new ByteArrayResource("".getBytes(StandardCharsets.UTF_8), "Output"), HttpStatus.FORBIDDEN);){
            webServer.start();
            BaseWebBasedRegisteredService service = RegisteredServiceTestUtils.getRegisteredService();
            RestfulRegisteredServiceProxyPolicy policy = new RestfulRegisteredServiceProxyPolicy();
            policy.setEndpoint("http://localhost:9222");
            policy.setHeaders(CollectionUtils.wrap((String)"header", (Object)"value"));
            Assertions.assertFalse((boolean)policy.isAllowedProxyCallbackUrl((RegisteredService)service, new URI("https://proxy.example.org").toURL()));
        }
    }
}

