/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.CasModelRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.services.RegisteredServicePublicKey;
import org.apereo.cas.services.RegisteredServicePublicKeyImpl;
import org.apereo.cas.services.ReturnEncryptedAttributeReleasePolicy;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

@Tag(value="Attributes")
@SpringBootTest(classes={RefreshAutoConfiguration.class})
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
class ReturnEncryptedAttributeReleasePolicyTests {
    private static final File JSON_FILE = new File(FileUtils.getTempDirectoryPath(), "EncryptingAttributeReleasePolicyTests.json");
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();
    @Autowired
    private ConfigurableApplicationContext applicationContext;

    ReturnEncryptedAttributeReleasePolicyTests() {
    }

    @Test
    void verifySerialization() throws IOException {
        ArrayList<String> allowedAttributes = new ArrayList<String>();
        allowedAttributes.add("attributeOne");
        ReturnEncryptedAttributeReleasePolicy policyWritten = new ReturnEncryptedAttributeReleasePolicy(allowedAttributes);
        MAPPER.writeValue(JSON_FILE, (Object)policyWritten);
        ReturnEncryptedAttributeReleasePolicy policyRead = (ReturnEncryptedAttributeReleasePolicy)MAPPER.readValue(JSON_FILE, ReturnEncryptedAttributeReleasePolicy.class);
        Assertions.assertEquals((Object)policyWritten, (Object)policyRead);
        Assertions.assertNotNull((Object)policyWritten.toString());
    }

    @Test
    void verifyNoPublicKey() throws Throwable {
        ReturnEncryptedAttributeReleasePolicy policy = new ReturnEncryptedAttributeReleasePolicy(CollectionUtils.wrapList((Object[])new String[]{"cn"}));
        CasModelRegisteredService registeredService = CoreAuthenticationTestUtils.getRegisteredService();
        RegisteredServiceAttributeReleasePolicyContext context = RegisteredServiceAttributeReleasePolicyContext.builder().applicationContext((ApplicationContext)this.applicationContext).registeredService((RegisteredService)registeredService).service(CoreAuthenticationTestUtils.getService()).principal(CoreAuthenticationTestUtils.getPrincipal((String)"casuser")).build();
        Map results = policy.getAttributes(context);
        Assertions.assertTrue((boolean)results.isEmpty());
        RegisteredServicePublicKeyImpl servicePublicKey = new RegisteredServicePublicKeyImpl();
        Mockito.when((Object)registeredService.getPublicKey()).thenReturn((Object)servicePublicKey);
        results = policy.getAttributes(context);
        Assertions.assertTrue((boolean)results.isEmpty());
    }

    @Test
    void verifyBadCipher() throws Throwable {
        ReturnEncryptedAttributeReleasePolicy policy = new ReturnEncryptedAttributeReleasePolicy(CollectionUtils.wrapList((Object[])new String[]{"cn"}));
        CasModelRegisteredService registeredService = CoreAuthenticationTestUtils.getRegisteredService();
        RegisteredServicePublicKey servicePublicKey = (RegisteredServicePublicKey)Mockito.mock(RegisteredServicePublicKey.class);
        Mockito.when((Object)servicePublicKey.getAlgorithm()).thenReturn((Object)"BAD");
        Mockito.when((Object)servicePublicKey.createInstance()).thenReturn((Object)((PublicKey)Mockito.mock(PublicKey.class)));
        Mockito.when((Object)registeredService.getPublicKey()).thenReturn((Object)servicePublicKey);
        RegisteredServiceAttributeReleasePolicyContext context = RegisteredServiceAttributeReleasePolicyContext.builder().registeredService((RegisteredService)registeredService).applicationContext((ApplicationContext)this.applicationContext).service(CoreAuthenticationTestUtils.getService()).principal(CoreAuthenticationTestUtils.getPrincipal((String)"casuser")).build();
        Map results = policy.getAttributes(context);
        Assertions.assertTrue((boolean)results.isEmpty());
    }

    @Test
    void verifyEncrypt() throws Throwable {
        ReturnEncryptedAttributeReleasePolicy policy = new ReturnEncryptedAttributeReleasePolicy(CollectionUtils.wrapList((Object[])new String[]{"cn", "uid", "mail"}));
        CasModelRegisteredService registeredService = CoreAuthenticationTestUtils.getRegisteredService();
        RegisteredServicePublicKeyImpl servicePublicKey = new RegisteredServicePublicKeyImpl("classpath:keys/RSA1024Public.key", "RSA");
        Mockito.when((Object)registeredService.getPublicKey()).thenReturn((Object)servicePublicKey);
        RegisteredServiceAttributeReleasePolicyContext context = RegisteredServiceAttributeReleasePolicyContext.builder().registeredService((RegisteredService)registeredService).applicationContext((ApplicationContext)this.applicationContext).service(CoreAuthenticationTestUtils.getService()).principal(CoreAuthenticationTestUtils.getPrincipal((String)"casuser")).build();
        Map results = policy.getAttributes(context);
        Assertions.assertEquals((int)policy.getAllowedAttributes().size(), (int)results.size());
    }
}

