/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.TimeBasedRegisteredServiceAccessStrategy;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="RegisteredService")
class TimeBasedRegisteredServiceAccessStrategyTests {
    private static final File JSON_FILE = new File(FileUtils.getTempDirectoryPath(), "timeBasedRegisteredServiceAccessStrategy.json");
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();

    TimeBasedRegisteredServiceAccessStrategyTests() {
    }

    @Test
    void checkAuthorizationByRangePass() {
        TimeBasedRegisteredServiceAccessStrategy authz = new TimeBasedRegisteredServiceAccessStrategy();
        authz.setStartingDateTime(ZonedDateTime.now(ZoneOffset.UTC).toString());
        authz.setEndingDateTime(ZonedDateTime.now(ZoneOffset.UTC).plusMinutes(10L).toString());
        Assertions.assertTrue((boolean)authz.isServiceAccessAllowed((RegisteredService)RegisteredServiceTestUtils.getRegisteredService(), CoreAuthenticationTestUtils.getService()));
    }

    @Test
    void checkAuthorizationByRangeFailStartTime() {
        TimeBasedRegisteredServiceAccessStrategy authz = new TimeBasedRegisteredServiceAccessStrategy();
        authz.setStartingDateTime(ZonedDateTime.now(ZoneOffset.UTC).plusDays(1L).toString());
        authz.setEndingDateTime(ZonedDateTime.now(ZoneOffset.UTC).plusMinutes(10L).toString());
        Assertions.assertFalse((boolean)authz.isServiceAccessAllowed((RegisteredService)RegisteredServiceTestUtils.getRegisteredService(), CoreAuthenticationTestUtils.getService()));
    }

    @Test
    void checkFailWithNowAfterEndTime() {
        TimeBasedRegisteredServiceAccessStrategy authz = new TimeBasedRegisteredServiceAccessStrategy();
        authz.setStartingDateTime(ZonedDateTime.now(ZoneOffset.UTC).minusDays(10L).toString());
        authz.setEndingDateTime(ZonedDateTime.now(ZoneOffset.UTC).minusDays(5L).toString());
        Assertions.assertFalse((boolean)authz.isServiceAccessAllowed((RegisteredService)RegisteredServiceTestUtils.getRegisteredService(), CoreAuthenticationTestUtils.getService()));
    }

    @Test
    void checkLocalFailWithNowAfterEndTime() {
        TimeBasedRegisteredServiceAccessStrategy authz = new TimeBasedRegisteredServiceAccessStrategy();
        authz.setStartingDateTime(LocalDateTime.now(ZoneOffset.UTC).minusDays(10L).toString());
        authz.setEndingDateTime(LocalDateTime.now(ZoneOffset.UTC).minusDays(5L).toString());
        Assertions.assertFalse((boolean)authz.isServiceAccessAllowed((RegisteredService)RegisteredServiceTestUtils.getRegisteredService(), CoreAuthenticationTestUtils.getService()));
    }

    @Test
    void checkLocalFailWithNowBeforeStartTime() {
        TimeBasedRegisteredServiceAccessStrategy authz = new TimeBasedRegisteredServiceAccessStrategy();
        authz.setStartingDateTime(LocalDateTime.now(ZoneOffset.UTC).plusDays(10L).toString());
        authz.setEndingDateTime(LocalDateTime.now(ZoneOffset.UTC).minusDays(15L).toString());
        Assertions.assertFalse((boolean)authz.isServiceAccessAllowed((RegisteredService)RegisteredServiceTestUtils.getRegisteredService(), CoreAuthenticationTestUtils.getService()));
    }

    @Test
    void checkExpressionLanguage() {
        TimeBasedRegisteredServiceAccessStrategy authz = new TimeBasedRegisteredServiceAccessStrategy();
        authz.setStartingDateTime("${#localStartDay}");
        authz.setEndingDateTime("${#localEndDay}");
        authz.setZoneId("${#zoneId}");
        Assertions.assertTrue((boolean)authz.isServiceAccessAllowed((RegisteredService)RegisteredServiceTestUtils.getRegisteredService(), CoreAuthenticationTestUtils.getService()));
    }

    @Test
    void checkAuthorizationByRangePassEndTime() {
        TimeBasedRegisteredServiceAccessStrategy authz = new TimeBasedRegisteredServiceAccessStrategy();
        authz.setStartingDateTime(ZonedDateTime.now(ZoneOffset.UTC).toString());
        authz.setEndingDateTime(ZonedDateTime.now(ZoneOffset.UTC).plusSeconds(30L).toString());
        Assertions.assertTrue((boolean)authz.isServiceAccessAllowed((RegisteredService)RegisteredServiceTestUtils.getRegisteredService(), CoreAuthenticationTestUtils.getService()));
    }

    @Test
    void verifySerializeATimeBasedRegisteredServiceAccessStrategyToJson() throws IOException {
        TimeBasedRegisteredServiceAccessStrategy authWritten = new TimeBasedRegisteredServiceAccessStrategy();
        MAPPER.writeValue(JSON_FILE, (Object)authWritten);
        TimeBasedRegisteredServiceAccessStrategy credentialRead = (TimeBasedRegisteredServiceAccessStrategy)MAPPER.readValue(JSON_FILE, TimeBasedRegisteredServiceAccessStrategy.class);
        Assertions.assertEquals((Object)authWritten, (Object)credentialRead);
    }
}

