/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.support;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.services.RegisteredServiceAttributeFilter;
import org.apereo.cas.services.support.RegisteredServiceMappedRegexAttributeFilter;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.cas.util.serialization.SerializationUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="RegisteredService")
class RegisteredServiceMappedRegexAttributeFilterTests {
    private static final File JSON_FILE = new File(FileUtils.getTempDirectoryPath(), "registeredServiceMappedRegexAttributeFilter.json");
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();
    private static final String PHONE = "phone";
    private static final String FAMILY_NAME = "familyName";
    private static final String GIVEN_NAME = "givenName";
    private static final String UID = "uid";
    private final Map<String, List<Object>> givenAttributesMap = new HashMap<String, List<Object>>();
    private RegisteredServiceMappedRegexAttributeFilter filter;

    RegisteredServiceMappedRegexAttributeFilterTests() {
        this.givenAttributesMap.put(UID, List.of("loggedInTestUid"));
        this.givenAttributesMap.put(PHONE, List.of("1290"));
        this.givenAttributesMap.put(FAMILY_NAME, List.of("Smith"));
        this.givenAttributesMap.put(GIVEN_NAME, List.of("John"));
        this.givenAttributesMap.put("employeeId", List.of("E1234"));
        this.givenAttributesMap.put("memberOf", Arrays.asList("math", "science", "chemistry", "marathon"));
        this.givenAttributesMap.put("setAttribute", Stream.of("math", "science", "chemistry").collect(Collectors.toList()));
    }

    @BeforeEach
    public void initialize() {
        this.filter = new RegisteredServiceMappedRegexAttributeFilter();
    }

    @Test
    void verifyPatternFilter() throws Throwable {
        this.filter.setPatterns(Collections.singletonMap("memberOf", "^m"));
        Map attrs = this.filter.filter(this.givenAttributesMap);
        Assertions.assertEquals((int)attrs.size(), (int)this.givenAttributesMap.size());
        Assertions.assertEquals((int)2, (int)CollectionUtils.toCollection(attrs.get("memberOf")).size());
    }

    @Test
    void verifyPattern() throws Throwable {
        this.filter = new RegisteredServiceMappedRegexAttributeFilter(Collections.singletonMap("memberOf", "^m"));
        Map attrs = this.filter.filter(this.givenAttributesMap);
        Assertions.assertEquals((int)attrs.size(), (int)this.givenAttributesMap.size());
        Assertions.assertEquals((int)2, (int)CollectionUtils.toCollection(attrs.get("memberOf")).size());
    }

    @Test
    void verifyPatternFilterExcludeUnmatched() throws Throwable {
        this.filter.setPatterns(Collections.singletonMap("memberOf", "^m"));
        this.filter.setExcludeUnmappedAttributes(true);
        Map attrs = this.filter.filter(this.givenAttributesMap);
        Assertions.assertEquals((int)1, (int)attrs.size());
        Assertions.assertEquals((int)2, (int)CollectionUtils.toCollection(attrs.get("memberOf")).size());
    }

    @Test
    void verifyPatternFilterFullMatch() throws Throwable {
        this.filter.setPatterns(Collections.singletonMap("memberOf", "^m"));
        this.filter.setCompleteMatch(true);
        Map attrs = this.filter.filter(this.givenAttributesMap);
        Assertions.assertEquals((int)attrs.size(), (int)(this.givenAttributesMap.size() - 1));
        Assertions.assertFalse((boolean)attrs.containsKey("memberOf"));
    }

    @Test
    void verifySerialization() throws Throwable {
        byte[] data = SerializationUtils.serialize((Serializable)this.filter);
        RegisteredServiceAttributeFilter secondFilter = (RegisteredServiceAttributeFilter)SerializationUtils.deserializeAndCheckObject((byte[])data, RegisteredServiceAttributeFilter.class);
        Assertions.assertEquals((Object)secondFilter, (Object)this.filter);
    }

    @Test
    void verifySerializeARegisteredServiceRegexAttributeFilterToJson() throws IOException {
        this.filter.setPatterns(Collections.singletonMap("memberOf", "^\\w{3}$"));
        MAPPER.writeValue(JSON_FILE, (Object)this.filter);
        RegisteredServiceMappedRegexAttributeFilter filterRead = (RegisteredServiceMappedRegexAttributeFilter)MAPPER.readValue(JSON_FILE, RegisteredServiceMappedRegexAttributeFilter.class);
        Assertions.assertEquals((Object)this.filter, (Object)filterRead);
    }
}

