/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.support;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.services.RegisteredServiceAttributeFilter;
import org.apereo.cas.services.support.RegisteredServiceMutantRegexAttributeFilter;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.cas.util.serialization.SerializationUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="RegisteredService")
class RegisteredServiceMutantRegexAttributeFilterTests {
    private static final File JSON_FILE = new File(FileUtils.getTempDirectoryPath(), "RegisteredServiceMutantRegexAttributeFilterTests.json");
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();
    private RegisteredServiceMutantRegexAttributeFilter filter;
    private Map<String, List<Object>> givenAttributesMap;

    RegisteredServiceMutantRegexAttributeFilterTests() {
    }

    @BeforeEach
    public void initialize() {
        this.filter = new RegisteredServiceMutantRegexAttributeFilter();
        this.givenAttributesMap = new HashMap<String, List<Object>>();
        this.givenAttributesMap.put("employeeId", List.of("E1234"));
        this.givenAttributesMap.put("memberOf", Arrays.asList("math101", "science", "chemistry", "marathon101"));
    }

    @Test
    void verifyPatternFilter() throws Throwable {
        this.filter.setPatterns(Collections.singletonMap("memberOf", "^m"));
        Map attrs = this.filter.filter(this.givenAttributesMap);
        Assertions.assertEquals((int)attrs.size(), (int)this.givenAttributesMap.size());
        Assertions.assertEquals((int)2, (int)CollectionUtils.toCollection(attrs.get("memberOf")).size());
    }

    @Test
    void verifySerialization() throws Throwable {
        byte[] data = SerializationUtils.serialize((Serializable)this.filter);
        RegisteredServiceAttributeFilter secondFilter = (RegisteredServiceAttributeFilter)SerializationUtils.deserializeAndCheckObject((byte[])data, RegisteredServiceAttributeFilter.class);
        Assertions.assertEquals((Object)secondFilter, (Object)this.filter);
    }

    @Test
    void verifySerializeARegisteredServiceRegexAttributeFilterToJson() throws IOException {
        this.filter.setPatterns(Collections.singletonMap("memberOf", CollectionUtils.wrapList((Object[])new String[]{"^mar(.+)", "^mat(.+)", "prefix$1"})));
        this.filter.setExcludeUnmappedAttributes(true);
        this.filter.setCaseInsensitive(true);
        MAPPER.writeValue(JSON_FILE, (Object)this.filter);
        RegisteredServiceMutantRegexAttributeFilter filterRead = (RegisteredServiceMutantRegexAttributeFilter)MAPPER.readValue(JSON_FILE, RegisteredServiceMutantRegexAttributeFilter.class);
        Assertions.assertEquals((Object)this.filter, (Object)filterRead);
    }

    @Test
    void verifyMutantPatternValues() throws Throwable {
        this.filter.setPatterns(Collections.singletonMap("memberOf", CollectionUtils.wrapList((Object[])new String[]{"^mar(.+)(101) -> prefix$1$2", "^mat(.+)(101) -> postfix$1$2"})));
        this.filter.setCaseInsensitive(false);
        this.filter.setExcludeUnmappedAttributes(true);
        Map results = this.filter.filter(this.givenAttributesMap);
        Assertions.assertEquals((int)1, (int)results.size());
        Collection values = (Collection)results.get("memberOf");
        Assertions.assertTrue((boolean)values.contains("prefixathon101"));
        Assertions.assertTrue((boolean)values.contains("postfixh101"));
    }
}

