/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.support;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeFilter;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.services.ReturnAllowedAttributeReleasePolicy;
import org.apereo.cas.services.support.RegisteredServiceRegexAttributeFilter;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.cas.util.serialization.SerializationUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

@Tag(value="RegisteredService")
@SpringBootTest(classes={RefreshAutoConfiguration.class})
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
class RegisteredServiceRegexAttributeFilterTests {
    private static final File JSON_FILE = new File(FileUtils.getTempDirectoryPath(), "registeredServiceRegexAttributeFilter.json");
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();
    private static final String PHONE = "phone";
    private static final String FAMILY_NAME = "familyName";
    private static final String GIVEN_NAME = "givenName";
    private static final String UID = "uid";
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    private final RegisteredServiceAttributeFilter filter = new RegisteredServiceRegexAttributeFilter("^.{5,}$");
    private final Map<String, List<Object>> givenAttributesMap = new HashMap<String, List<Object>>();

    RegisteredServiceRegexAttributeFilterTests() {
        this.givenAttributesMap.put(UID, List.of("loggedInTestUid"));
        this.givenAttributesMap.put(PHONE, List.of("1290"));
        this.givenAttributesMap.put(FAMILY_NAME, List.of("Smith"));
        this.givenAttributesMap.put(GIVEN_NAME, List.of("John"));
        this.givenAttributesMap.put("employeeId", List.of("E1234"));
        this.givenAttributesMap.put("memberOf", Arrays.asList("math", "science", "chemistry"));
        this.givenAttributesMap.put("setAttribute", Stream.of("math", "science", "chemistry").collect(Collectors.toList()));
    }

    @Test
    void verifyPatternFilter() throws Throwable {
        Map attrs = this.filter.filter(this.givenAttributesMap);
        Assertions.assertEquals((int)5, (int)attrs.size());
        Assertions.assertFalse((boolean)attrs.containsKey(PHONE));
        Assertions.assertFalse((boolean)attrs.containsKey(GIVEN_NAME));
        Assertions.assertTrue((boolean)attrs.containsKey(UID));
        Assertions.assertTrue((boolean)attrs.containsKey("memberOf"));
        List mapAttributes = (List)attrs.get("setAttribute");
        Assertions.assertTrue((boolean)mapAttributes.contains("science"));
        Assertions.assertTrue((boolean)mapAttributes.contains("chemistry"));
        List obj = (List)attrs.get("memberOf");
        Assertions.assertEquals((int)2, (int)obj.size());
    }

    @Test
    void verifyServiceAttributeFilterAllowedAttributesWithARegexFilter() throws Throwable {
        ReturnAllowedAttributeReleasePolicy policy = new ReturnAllowedAttributeReleasePolicy();
        policy.setAllowedAttributes(Arrays.asList("attr1", "attr3", "another"));
        policy.setAttributeFilter((RegisteredServiceAttributeFilter)new RegisteredServiceRegexAttributeFilter("v3"));
        Principal p = (Principal)Mockito.mock(Principal.class);
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
        map.put("attr1", List.of("value1"));
        map.put("attr2", List.of("value2"));
        map.put("attr3", Arrays.asList("v3", "v4"));
        Mockito.when((Object)p.getAttributes()).thenReturn(map);
        Mockito.when((Object)p.getId()).thenReturn((Object)"principalId");
        RegisteredServiceAttributeReleasePolicyContext context = RegisteredServiceAttributeReleasePolicyContext.builder().registeredService((RegisteredService)RegisteredServiceTestUtils.getRegisteredService("test")).service((Service)RegisteredServiceTestUtils.getService()).applicationContext((ApplicationContext)this.applicationContext).principal(p).build();
        Map attr = policy.getAttributes(context);
        Assertions.assertEquals((int)1, (int)attr.size());
        Assertions.assertTrue((boolean)attr.containsKey("attr3"));
        byte[] data = SerializationUtils.serialize((Serializable)policy);
        ReturnAllowedAttributeReleasePolicy p2 = (ReturnAllowedAttributeReleasePolicy)SerializationUtils.deserializeAndCheckObject((byte[])data, ReturnAllowedAttributeReleasePolicy.class);
        Assertions.assertNotNull((Object)p2);
        Assertions.assertEquals((Object)p2.getAllowedAttributes(), (Object)policy.getAllowedAttributes());
        Assertions.assertEquals((Object)p2.getAttributeFilter(), (Object)policy.getAttributeFilter());
    }

    @Test
    void verifySerialization() throws Throwable {
        byte[] data = SerializationUtils.serialize((Serializable)this.filter);
        RegisteredServiceAttributeFilter secondFilter = (RegisteredServiceAttributeFilter)SerializationUtils.deserializeAndCheckObject((byte[])data, RegisteredServiceAttributeFilter.class);
        Assertions.assertEquals((Object)secondFilter, (Object)this.filter);
    }

    @Test
    void verifyDefault() throws Throwable {
        RegisteredServiceAttributeFilter data = (RegisteredServiceAttributeFilter)Mockito.mock(RegisteredServiceAttributeFilter.class);
        Mockito.when((Object)data.getOrder()).thenCallRealMethod();
        Assertions.assertEquals((int)Integer.MIN_VALUE, (int)data.getOrder());
    }

    @Test
    void verifySerializeARegisteredServiceRegexAttributeFilterToJson() throws IOException {
        MAPPER.writeValue(JSON_FILE, (Object)this.filter);
        RegisteredServiceRegexAttributeFilter filterRead = (RegisteredServiceRegexAttributeFilter)MAPPER.readValue(JSON_FILE, RegisteredServiceRegexAttributeFilter.class);
        Assertions.assertEquals((Object)this.filter, (Object)filterRead);
    }
}

