/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.support;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.services.support.RegisteredServiceScriptedAttributeFilter;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.core.io.ClassPathResource;

@Tag(value="GroovyServices")
class RegisteredServiceScriptedAttributeFilterTests {
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();
    private Map<String, List<Object>> givenAttributesMap;

    RegisteredServiceScriptedAttributeFilterTests() {
    }

    @BeforeEach
    public void initialize() {
        this.givenAttributesMap = new HashMap<String, List<Object>>();
        this.givenAttributesMap.put("employeeId", List.of("E1234"));
        this.givenAttributesMap.put("memberOf", Arrays.asList("math101", "science", "chemistry", "marathon101"));
    }

    @Test
    void verifyScriptedAttributeFilter() throws Throwable {
        File f = File.createTempFile("attr", ".groovy");
        InputStream stream = new ClassPathResource("groovy-attr-filter.groovy").getInputStream();
        FileUtils.copyInputStreamToFile((InputStream)stream, (File)f);
        RegisteredServiceScriptedAttributeFilter filter = new RegisteredServiceScriptedAttributeFilter(0, "file:" + f.getCanonicalPath());
        Map results = filter.filter(this.givenAttributesMap);
        Assertions.assertEquals((int)3, (int)results.size());
        File file = new File(FileUtils.getTempDirectoryPath(), "verifyScriptedAttributeFilter.json");
        MAPPER.writeValue(file, (Object)filter);
        RegisteredServiceScriptedAttributeFilter read = (RegisteredServiceScriptedAttributeFilter)MAPPER.readValue(file, RegisteredServiceScriptedAttributeFilter.class);
        Assertions.assertEquals((Object)filter, (Object)read);
    }

    @Test
    void verifyScriptedAttributeFilterInlined() throws Throwable {
        RegisteredServiceScriptedAttributeFilter filter = new RegisteredServiceScriptedAttributeFilter(0, "groovy {logger.debug('exec'); return attributes;}");
        Map results = filter.filter(this.givenAttributesMap);
        Assertions.assertEquals((int)2, (int)results.size());
        File file = new File(FileUtils.getTempDirectoryPath(), "verifyScriptedAttributeFilterInlined.json");
        MAPPER.writeValue(file, (Object)filter);
        RegisteredServiceScriptedAttributeFilter read = (RegisteredServiceScriptedAttributeFilter)MAPPER.readValue(file, RegisteredServiceScriptedAttributeFilter.class);
        Assertions.assertEquals((Object)filter, (Object)read);
    }
}

