/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.util;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apereo.cas.services.AuthenticationDateRegisteredServiceSingleSignOnParticipationPolicy;
import org.apereo.cas.services.CasRegisteredService;
import org.apereo.cas.services.ChainingRegisteredServiceSingleSignOnParticipationPolicy;
import org.apereo.cas.services.DefaultRegisteredServiceAcceptableUsagePolicy;
import org.apereo.cas.services.LastUsedTimeRegisteredServiceSingleSignOnParticipationPolicy;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAcceptableUsagePolicy;
import org.apereo.cas.services.RegisteredServiceSingleSignOnParticipationPolicy;
import org.apereo.cas.services.util.RegisteredServiceJsonSerializer;
import org.apereo.cas.util.CollectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.StaticApplicationContext;

@Tag(value="FileSystem")
class RegisteredServiceJsonSerializerTests {
    RegisteredServiceJsonSerializerTests() {
    }

    @Test
    void verifyPrinter() throws Throwable {
        StaticApplicationContext applicationContext = new StaticApplicationContext();
        applicationContext.refresh();
        RegisteredServiceJsonSerializer zer = new RegisteredServiceJsonSerializer((ConfigurableApplicationContext)applicationContext);
        Assertions.assertFalse((boolean)zer.supports(new File("bad-file")));
        Assertions.assertFalse((boolean)zer.getContentTypes().isEmpty());
    }

    @Test
    void verifyWriter() throws Throwable {
        StaticApplicationContext applicationContext = new StaticApplicationContext();
        applicationContext.refresh();
        RegisteredServiceJsonSerializer zer = new RegisteredServiceJsonSerializer((ConfigurableApplicationContext)applicationContext);
        StringWriter writer = new StringWriter();
        zer.to((Writer)writer, (Object)new CasRegisteredService());
        Assertions.assertNotNull((Object)zer.from((Writer)writer));
    }

    @Test
    void verifyList() throws Throwable {
        StaticApplicationContext applicationContext = new StaticApplicationContext();
        applicationContext.refresh();
        RegisteredServiceJsonSerializer zer = new RegisteredServiceJsonSerializer((ConfigurableApplicationContext)applicationContext);
        CasRegisteredService registeredService = new CasRegisteredService();
        registeredService.setName("CasService");
        String results = zer.fromList((Collection)CollectionUtils.wrapList((Object[])new RegisteredService[]{registeredService}));
        Assertions.assertNotNull((Object)zer.fromList(results));
    }

    @Test
    void checkNullability() {
        StaticApplicationContext applicationContext = new StaticApplicationContext();
        applicationContext.refresh();
        RegisteredServiceJsonSerializer zer = new RegisteredServiceJsonSerializer((ConfigurableApplicationContext)applicationContext);
        String json = "{\n    \"@class\" : \"org.apereo.cas.services.CasRegisteredService\",\n        \"serviceId\" : \"^https://xyz.*\",\n        \"name\" : \"XYZ\",\n        \"id\" : \"20161214\"\n}".indent(4);
        CasRegisteredService registeredService = (CasRegisteredService)zer.from(json);
        Assertions.assertNotNull((Object)registeredService);
        Assertions.assertNotNull((Object)registeredService.getAccessStrategy());
        Assertions.assertNotNull((Object)registeredService.getAttributeReleasePolicy());
        Assertions.assertNotNull((Object)registeredService.getProxyPolicy());
        Assertions.assertNotNull((Object)registeredService.getUsernameAttributeProvider());
    }

    @Test
    void verifySsoPolicySerialization() throws Throwable {
        StaticApplicationContext applicationContext = new StaticApplicationContext();
        applicationContext.refresh();
        DefaultRegisteredServiceAcceptableUsagePolicy policyWritten = new DefaultRegisteredServiceAcceptableUsagePolicy();
        policyWritten.setEnabled(true);
        policyWritten.setMessageCode("example.code");
        policyWritten.setText("example text");
        CasRegisteredService registeredService = new CasRegisteredService();
        registeredService.setAcceptableUsagePolicy((RegisteredServiceAcceptableUsagePolicy)policyWritten);
        ChainingRegisteredServiceSingleSignOnParticipationPolicy policy = new ChainingRegisteredServiceSingleSignOnParticipationPolicy();
        policy.addPolicies(Arrays.asList(new LastUsedTimeRegisteredServiceSingleSignOnParticipationPolicy(TimeUnit.SECONDS, 100L, 1), new AuthenticationDateRegisteredServiceSingleSignOnParticipationPolicy(TimeUnit.SECONDS, 100L, 1)));
        registeredService.setSingleSignOnParticipationPolicy((RegisteredServiceSingleSignOnParticipationPolicy)policy);
        RegisteredServiceJsonSerializer zer = new RegisteredServiceJsonSerializer((ConfigurableApplicationContext)applicationContext);
        String results = zer.toString((Object)registeredService);
        RegisteredService read = (RegisteredService)zer.from(results);
        Assertions.assertEquals((Object)registeredService, (Object)read);
    }

    @Test
    void verifyEmptyStringAsNull() throws Throwable {
        StaticApplicationContext applicationContext = new StaticApplicationContext();
        applicationContext.refresh();
        RegisteredServiceJsonSerializer zer = new RegisteredServiceJsonSerializer((ConfigurableApplicationContext)applicationContext);
        String json = "  {\n      \"@class\" : \"org.apereo.cas.services.CasRegisteredService\",\n          \"serviceId\" : \"^https://xyz.*\",\n          \"name\" : \"XYZ\",\n          \"id\" : \"20161214\"\n\"authenticationPolicy\" : {\n  \"@class\" : \"org.apereo.cas.services.DefaultRegisteredServiceAuthenticationPolicy\"}}".indent(2);
        RegisteredService serialized = (RegisteredService)zer.from(json);
        Assertions.assertNotNull((Object)serialized);
        Assertions.assertNotNull((Object)serialized.getAuthenticationPolicy());
        Assertions.assertNull((Object)serialized.getAuthenticationPolicy().getCriteria());
    }
}

