/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.crypto;

import lombok.Generated;
import org.apereo.cas.util.crypto.GlibcCryptPasswordEncoder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlibcCryptPasswordEncoderTests {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GlibcCryptPasswordEncoderTests.class);
    private static final String PASSWORD_CLEAR = "12345abcDEF!$";

    @Test
    public void sha512EncodingTest() {
        Assertions.assertTrue((boolean)this.testEncodingRoundtrip("SHA-512"));
        Assertions.assertTrue((boolean)this.testEncodingRoundtrip("6"));
        Assertions.assertTrue((boolean)this.testMatchWithDifferentSalt("SHA-512", "$6$rounds=1000$df273de606d3609a$GAPcq.K4jO3KkfusCM7Zr8Cci4qf.jOsWj5hkGBpwRg515bKk93afAXHy/lg.2LPr8ZItHoR3AR5X3XOXndZI0"));
    }

    @Test
    public void ha256EncodingTest() {
        Assertions.assertTrue((boolean)this.testEncodingRoundtrip("SHA-256"));
        Assertions.assertTrue((boolean)this.testEncodingRoundtrip("5"));
        Assertions.assertTrue((boolean)this.testMatchWithDifferentSalt("SHA-256", "$5$rounds=1000$e98244bb01b64f47$2qphrK8axtGjgmCJFYwaH7czw5iK9feLl7tKjyTlDy0"));
    }

    @Test
    public void md5EncodingTest() {
        Assertions.assertTrue((boolean)this.testEncodingRoundtrip("MD5"));
        Assertions.assertTrue((boolean)this.testEncodingRoundtrip("1"));
        Assertions.assertTrue((boolean)this.testMatchWithDifferentSalt("MD5", "$1$c4676fd0$HOHZ2CYp45lZAAQyvF4C21"));
    }

    @Test
    public void desUnixCryptEncodingTest() {
        Assertions.assertTrue((boolean)this.testEncodingRoundtrip("aB"));
        Assertions.assertTrue((boolean)this.testEncodingRoundtrip("42xyz"));
        Assertions.assertTrue((boolean)this.testMatchWithDifferentSalt("aB", "aB4fMcNOggJoQ"));
    }

    private boolean testEncodingRoundtrip(String algorithm) {
        GlibcCryptPasswordEncoder encoder = new GlibcCryptPasswordEncoder(algorithm, 0, null);
        String passwordHash = encoder.encode((CharSequence)PASSWORD_CLEAR);
        LOGGER.debug("Password [{}] was encoded by algorithm [{}] to hash [{}]", new Object[]{PASSWORD_CLEAR, algorithm, passwordHash});
        boolean match = encoder.matches((CharSequence)PASSWORD_CLEAR, passwordHash);
        LOGGER.debug("Does password [{}] match original password [{}]: {}", new Object[]{passwordHash, PASSWORD_CLEAR, match});
        return match;
    }

    private boolean testMatchWithDifferentSalt(String algorithm, String encodedPassword) {
        GlibcCryptPasswordEncoder encoder = new GlibcCryptPasswordEncoder(algorithm, 0, null);
        boolean match = encoder.matches((CharSequence)PASSWORD_CLEAR, encodedPassword);
        LOGGER.debug("Does password [{}] match original password [{}]: {}", new Object[]{encodedPassword, PASSWORD_CLEAR, match});
        return match;
    }
}

