/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.junit;

import java.lang.reflect.Modifier;
import org.apereo.cas.util.junit.ConditionalIgnore;
import org.apereo.cas.util.junit.IgnoreCondition;
import org.junit.Assume;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class ConditionalIgnoreRule
implements TestRule {
    private static boolean hasConditionalIgnoreAnnotation(Description target) {
        return target.getTestClass().isAnnotationPresent(ConditionalIgnore.class) || target.getAnnotation(ConditionalIgnore.class) != null;
    }

    private static IgnoreCondition getIgnoreCondition(Description target) {
        ConditionalIgnore annotation = (ConditionalIgnore)target.getAnnotation(ConditionalIgnore.class);
        if (annotation == null) {
            annotation = target.getTestClass().getAnnotation(ConditionalIgnore.class);
        }
        return new IgnoreConditionCreator(target, annotation).create();
    }

    public Statement apply(Statement base, Description target) {
        IgnoreCondition condition;
        if (ConditionalIgnoreRule.hasConditionalIgnoreAnnotation(target) && !(condition = ConditionalIgnoreRule.getIgnoreCondition(target)).isSatisfied().booleanValue()) {
            return new IgnoreStatement(condition);
        }
        return base;
    }

    public static class IgnoreStatement
    extends Statement {
        private final IgnoreCondition condition;

        IgnoreStatement(IgnoreCondition condition) {
            this.condition = condition;
        }

        public void evaluate() {
            Assume.assumeTrue((String)("Ignored by " + this.condition.getClass().getSimpleName()), (boolean)false);
        }
    }

    private static class IgnoreConditionCreator {
        private final Description target;
        private final Class<? extends IgnoreCondition> conditionType;

        IgnoreConditionCreator(Description target, ConditionalIgnore annotation) {
            this.target = target;
            this.conditionType = annotation.condition();
        }

        IgnoreCondition create() {
            this.checkConditionType();
            try {
                return this.createCondition();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private IgnoreCondition createCondition() throws Exception {
            if (this.isConditionTypeStandalone()) {
                return this.conditionType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return this.conditionType.getDeclaredConstructor(this.target.getClass()).newInstance(this.target);
        }

        private void checkConditionType() {
            if (!this.isConditionTypeStandalone() && !this.isConditionTypeDeclaredInTarget()) {
                String msg = "Conditional class '%s' is a member class but was not declared inside the test case using it.\nEither make this class a static class, standalone class (by declaring it in it's own file) or move it inside the test case using it";
                throw new IllegalArgumentException(String.format("Conditional class '%s' is a member class but was not declared inside the test case using it.\nEither make this class a static class, standalone class (by declaring it in it's own file) or move it inside the test case using it", this.conditionType.getName()));
            }
        }

        private boolean isConditionTypeStandalone() {
            return !this.conditionType.isMemberClass() || Modifier.isStatic(this.conditionType.getModifiers());
        }

        private boolean isConditionTypeDeclaredInTarget() {
            return this.target.getClass().isAssignableFrom(this.conditionType.getDeclaringClass());
        }
    }
}

