/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.junit;

import org.apereo.cas.util.SocketUtils;
import org.apereo.cas.util.junit.ConditionalIgnore;
import org.apereo.cas.util.junit.IgnoreCondition;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.Parameterized;
import org.junit.runners.ParentRunner;

public class ConditionalParameterizedRunner
extends Parameterized {
    public ConditionalParameterizedRunner(Class<?> klass) throws Throwable {
        super(klass);
    }

    protected void runChild(Runner runner, RunNotifier notifier) {
        ConditionalIgnore ignore = (ConditionalIgnore)((ParentRunner)runner).getTestClass().getAnnotation(ConditionalIgnore.class);
        if (ConditionalParameterizedRunner.shouldRunTestsWithCondition(ignore)) {
            super.runChild(runner, notifier);
        }
    }

    private static boolean shouldRunTestsWithCondition(ConditionalIgnore ignore) {
        if (ignore == null) {
            return true;
        }
        boolean shouldRun = false;
        if (ignore.condition() == null) {
            shouldRun = true;
        } else {
            IgnoreCondition condition = ignore.condition().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            shouldRun = condition.isSatisfied();
        }
        if (shouldRun && ignore.port() > 0) {
            shouldRun = !SocketUtils.isTcpPortAvailable((int)ignore.port());
        }
        return shouldRun;
    }
}

