/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.junit;

import org.apereo.cas.util.SocketUtils;
import org.apereo.cas.util.junit.ConditionalIgnore;
import org.apereo.cas.util.junit.ConditionalIgnoreRule;
import org.apereo.cas.util.junit.IgnoreCondition;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

public class ConditionalSpringRunner
extends SpringJUnit4ClassRunner {
    public ConditionalSpringRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
    }

    protected boolean isTestMethodIgnored(FrameworkMethod frameworkMethod) {
        ConditionalIgnore ignore = frameworkMethod.getDeclaringClass().getAnnotation(ConditionalIgnore.class);
        if (ignore != null) {
            return !ConditionalSpringRunner.isIgnoreConditionSatisfied(ignore);
        }
        ignore = (ConditionalIgnore)frameworkMethod.getAnnotation(ConditionalIgnore.class);
        if (ignore != null) {
            return !ConditionalSpringRunner.isIgnoreConditionSatisfied(ignore);
        }
        return super.isTestMethodIgnored(frameworkMethod);
    }

    protected Statement withBeforeClasses(Statement statement) {
        ConditionalIgnore ignore = this.getTestClass().getJavaClass().getAnnotation(ConditionalIgnore.class);
        if (ignore != null && !ConditionalSpringRunner.isIgnoreConditionSatisfied(ignore)) {
            IgnoreCondition condition = ignore.condition().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return new ConditionalIgnoreRule.IgnoreStatement(condition);
        }
        return super.withBeforeClasses(statement);
    }

    protected Statement withAfterClasses(Statement statement) {
        ConditionalIgnore ignore = this.getTestClass().getJavaClass().getAnnotation(ConditionalIgnore.class);
        if (ignore != null && !ConditionalSpringRunner.isIgnoreConditionSatisfied(ignore)) {
            IgnoreCondition condition = ignore.condition().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return new ConditionalIgnoreRule.IgnoreStatement(condition);
        }
        return super.withAfterClasses(statement);
    }

    private static boolean isIgnoreConditionSatisfied(ConditionalIgnore ignore) throws Exception {
        if (ignore.condition() == null) {
            return !SocketUtils.isTcpPortAvailable((int)ignore.port());
        }
        boolean portRunning = !SocketUtils.isTcpPortAvailable((int)ignore.port());
        IgnoreCondition condition = ignore.condition().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Boolean satisfied = condition.isSatisfied();
        if (satisfied == null || satisfied.booleanValue()) {
            return portRunning;
        }
        return satisfied;
    }
}

