/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;

public class MockWebServer
implements AutoCloseable {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MockWebServer.class);
    private final Worker worker;
    private Thread workerThread;

    public MockWebServer(int port) {
        try {
            this.worker = new Worker(new ServerSocket(port), null, "application/json");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot create Web server", e);
        }
    }

    public MockWebServer(int port, Resource resource, HttpStatus status) {
        try {
            this.worker = new Worker(new ServerSocket(port), resource, status);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot create Web server", e);
        }
    }

    public MockWebServer(int port, Resource resource, String contentType) {
        try {
            this.worker = new Worker(new ServerSocket(port), resource, contentType);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot create Web server", e);
        }
    }

    public MockWebServer(int port, String data) {
        try {
            this.worker = new Worker(new ServerSocket(port), (Resource)new ByteArrayResource(data.getBytes(StandardCharsets.UTF_8)), "application/json");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot create Web server", e);
        }
    }

    public MockWebServer(int port, Function funcExec) {
        try {
            this.worker = new Worker(new ServerSocket(port), funcExec);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot create Web server", e);
        }
    }

    public void start() {
        this.workerThread = new Thread((Runnable)this.worker, "MockWebServer.Worker");
        this.workerThread.start();
    }

    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        this.worker.stop();
        try {
            this.workerThread.join();
        }
        catch (InterruptedException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void close() {
        this.stop();
    }

    public boolean isRunning() {
        return this.workerThread.isAlive();
    }

    private static class Worker
    implements Runnable {
        private static final String STATUS_LINE = "HTTP/1.1 %s %s\r\n";
        private static final String SEPARATOR = "\r\n";
        private static final int BUFFER_SIZE = 2048;
        private final ServerSocket serverSocket;
        private final Resource resource;
        private final String contentType;
        private final Function<Socket, Object> functionToExecute;
        private boolean running;
        private HttpStatus status = HttpStatus.OK;

        Worker(ServerSocket sock, Resource resource, String contentType) {
            this(sock, resource, contentType, HttpStatus.OK);
        }

        Worker(ServerSocket sock, Resource resource, HttpStatus status) {
            this(sock, resource, "application/json", status);
        }

        Worker(ServerSocket sock, Resource resource, String contentType, HttpStatus status) {
            this.serverSocket = sock;
            this.resource = resource;
            this.contentType = contentType;
            this.functionToExecute = null;
            this.running = true;
            this.status = status;
        }

        Worker(ServerSocket sock, Function<Socket, Object> functionToExecute) {
            this.serverSocket = sock;
            this.functionToExecute = functionToExecute;
            this.resource = null;
            this.contentType = "application/json";
            this.running = true;
            this.status = HttpStatus.OK;
        }

        private static byte[] header(String name, Object value) {
            return String.format("%s: %s\r\n", name, value).getBytes(StandardCharsets.UTF_8);
        }

        @Override
        public synchronized void run() {
            while (this.running) {
                try {
                    Socket socket = this.serverSocket.accept();
                    if (this.functionToExecute != null) {
                        LOGGER.trace("Executed function with result [{}]", this.functionToExecute.apply(socket));
                    } else {
                        this.writeResponse(socket);
                    }
                    socket.shutdownOutput();
                    Thread.sleep(100L);
                }
                catch (SocketException e) {
                    LOGGER.debug("Stopping on socket close.");
                    this.running = false;
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }

        public void stop() {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                LOGGER.trace("Exception when closing the server socket: [{}]", (Object)e.getMessage());
            }
        }

        private void writeResponse(Socket socket) throws IOException {
            if (this.resource != null) {
                LOGGER.debug("Socket response for resource [{}]", (Object)this.resource.getFilename());
                OutputStream out = socket.getOutputStream();
                String statusLine = String.format(STATUS_LINE, this.status.value(), this.status.getReasonPhrase());
                out.write(statusLine.getBytes(StandardCharsets.UTF_8));
                out.write(Worker.header("Content-Length", this.resource.contentLength()));
                out.write(Worker.header("Content-Type", this.contentType));
                out.write(SEPARATOR.getBytes(StandardCharsets.UTF_8));
                byte[] buffer = new byte[2048];
                try (InputStream in = this.resource.getInputStream();){
                    int count = 0;
                    while ((count = in.read(buffer)) > -1) {
                        out.write(buffer, 0, count);
                    }
                }
                LOGGER.debug("Wrote response for resource [{}] for [{}]", (Object)this.resource.getFilename(), (Object)this.resource.contentLength());
            }
        }
    }
}

